/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.clouditems.AtlassianSpace;
import com.geolang.ascema.endpointcommon.domain.clouditems.BitbucketRepo;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraIssueSecurityLevel;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraProject;
import com.geolang.ascema.endpointcommon.domain.clouditems.MIPLabel;
import com.geolang.ascema.indexingcommon.endpoint.alfresco.AspectTree;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudGroup;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudUser;
import com.geolang.ascema.indexingcommon.endpoint.google.GoogleDriveLabel;
import com.geolang.ascema.managerservice.controllers.CloudItemsController;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebAspect;
import com.geolang.ascema.managerservice.rest.requests.o365.CloudUsersAndGroups;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cloudcache"})
public class CloudCacheRestService {
    @Autowired
    private CloudItemsController controller;

    @PostMapping(value={"/usergroups"})
    public CloudUsersAndGroups getUsersAndGroupsForHost(@RequestParam(value="host") String host) {
        return this.controller.getUsersAndGroupsForHost(host);
    }

    @PostMapping(value={"/searchusers"})
    public List<CloudUser> searchUsersForHost(@RequestParam(value="host") String host, @RequestParam(value="prefix") String prefix) {
        CloudUsersAndGroups ugs = this.controller.getUsersAndGroupsForHost(host);
        return ugs.getUsersStartingWith(prefix);
    }

    @PostMapping(value={"/searchgroups"})
    public List<CloudGroup> searchGroupsForHost(@RequestParam(value="host") String host, @RequestParam(value="prefix") String prefix) {
        CloudUsersAndGroups ugs = this.controller.getUsersAndGroupsForHost(host);
        return ugs.getGroupsStartingWith(prefix);
    }

    @PostMapping(value={"/spaces"})
    public List<AtlassianSpace> getSpacesForHost(@RequestParam(value="host") String host) {
        return this.controller.getSpacesForHost(host);
    }

    @PostMapping(value={"/projects"})
    public List<JiraProject> getProjectsForHost(@RequestParam(value="host") String host) {
        return this.controller.getProjectsForHost(host);
    }

    @PostMapping(value={"/schemes"})
    public List<JiraIssueSecurityLevel> getSchemesForHost(@RequestParam(value="host") String host) {
        return this.controller.getSchemesForHost(host);
    }

    @PostMapping(value={"/repos"})
    public List<BitbucketRepo> getReposForHost(@RequestParam(value="host") String host) {
        return this.controller.getReposForHost(host);
    }

    @PostMapping(value={"/googlelabels"})
    public List<GoogleDriveLabel> getGoogleLabelsForHost(@RequestParam(value="host") String host) {
        return this.controller.getGoogleLabelsForHost(host);
    }

    @PostMapping(value={"/miplabels"})
    public List<MIPLabel> getMipLabelsForHost(@RequestParam(value="host") String host) {
        return this.controller.getO365MipLabelsForHost(host);
    }

    @RequestMapping(value={"/miplabelsdefault"})
    public List<MIPLabel> getDefaultMipLabels() {
        return this.controller.getDefaultMipLabels();
    }

    @PostMapping(value={"/aspects"})
    public List<WebAspect> getAspectsForHost(@RequestParam(value="host") String host) {
        AspectTree tree = this.controller.getAspectsForHost(host);
        ArrayList<WebAspect> ret = new ArrayList<WebAspect>();
        List roots = tree.getRoots();
        roots.sort((a, b) -> a.getData().getDisplayName().compareTo(b.getData().getDisplayName()));
        for (AspectTree.Node node : roots) {
            WebAspect wa = new WebAspect(node.getData(), tree.getHostname());
            ret.add(wa);
            this.addChildNodes(wa, node.getChildren());
        }
        return ret;
    }

    private void addChildNodes(WebAspect parent, List<AspectTree.Node> children) {
        for (AspectTree.Node node : children) {
            WebAspect wa = new WebAspect(node.getData(), parent.getHostname());
            parent.addChild(wa);
            this.addChildNodes(wa, node.getChildren());
        }
    }
}

