/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointclassification.types.FileHolder;
import com.geolang.ascema.endpointclassification.types.TemplateDetails;
import com.geolang.ascema.endpointclassification.types.TrainingResult;
import com.geolang.ascema.managerdomain.web.ReTrainCommand;
import com.geolang.ascema.managerdomain.web.WebFileHolder;
import com.geolang.ascema.managerdomain.web.WebTemplateDetails;
import com.geolang.ascema.managerdomain.web.WebTrainingResult;
import com.geolang.ascema.managerservice.controllers.classification.ClassificationCreationSession;
import com.geolang.ascema.managerservice.controllers.classification.ClassificationLookupController;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/classification"})
public class ClassificationRestService {
    @Autowired
    private ClassificationCreationSession controller;
    @Autowired
    private ClassificationLookupController lookup;

    @PostMapping(value={"/add"})
    public WebTrainingResult addTemplate(Principal principal, @RequestParam(value="name") String name, @RequestParam(value="files") MultipartFile[] uploadfiles) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        ArrayList<FileHolder> fhs = new ArrayList<FileHolder>();
        for (MultipartFile f : uploadfiles) {
            try {
                FileHolder fh = new FileHolder(f.getOriginalFilename(), f.getInputStream());
                fhs.add(fh);
            }
            catch (IOException ex) {
                Logger.getLogger(ClassificationRestService.class.getName()).log(Level.SEVERE, null, ex);
                return new WebTrainingResult(false, ex.getMessage());
            }
        }
        return new WebTrainingResult(this.controller.addTemplate(name, fhs, user));
    }

    @PostMapping(value={"/checktraining"})
    public WebTrainingResult checkTraining(@RequestParam(value="name") String name, @RequestParam(value="files") MultipartFile[] candidates) {
        ArrayList<FileHolder> fhs = new ArrayList<FileHolder>();
        for (MultipartFile wfh : candidates) {
            try {
                FileHolder fh = new FileHolder(wfh.getOriginalFilename(), wfh.getInputStream());
                fhs.add(fh);
            }
            catch (IOException ex) {
                Logger.getLogger(ClassificationRestService.class.getName()).log(Level.SEVERE, null, ex);
                TrainingResult res = new TrainingResult();
                res.setIsSuccess(false);
                res.setMessage("Failed to read files " + ex.getMessage());
                return new WebTrainingResult(res);
            }
        }
        TrainingResult res = this.controller.checkTraining(name, fhs);
        return new WebTrainingResult(res);
    }

    @PostMapping(value={"/retrain"})
    public WebTrainingResult reTrain(@RequestParam(value="com") ReTrainCommand com) {
        TrainingResult res = this.controller.reTrain(com.getTemplateName(), Arrays.asList(com.getOldFiles()), Arrays.asList(com.getNewFiles()));
        return new WebTrainingResult(res);
    }

    @PostMapping(value={"/save"})
    public boolean save() {
        this.controller.save();
        return true;
    }

    @PostMapping(value={"/discardchanges"})
    public boolean discardChanges() {
        this.controller.discardChanges();
        return true;
    }

    @RequestMapping(value={"/listtemplates"})
    public List<WebTemplateDetails> getAllTemplatesExceptUnknown() {
        ArrayList<WebTemplateDetails> ret = new ArrayList<WebTemplateDetails>();
        for (TemplateDetails td : this.lookup.getAllTemplatesExceptUnknown()) {
            ret.add(new WebTemplateDetails(td));
        }
        return ret;
    }

    @RequestMapping(value={"/listnames"})
    public List<String> getTemplateNames() {
        return this.lookup.getTemplateNames();
    }

    @PostMapping(value={"/delete"})
    public boolean deleteClassification(Principal principal, @RequestParam(value="name") String classname) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        return this.lookup.deleteClassification(classname, user);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(WebFileHolder.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebTemplateDetails.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(ReTrainCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

