/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.AtlassianPathStatusEvent;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebConnectionStatus;
import com.geolang.ascema.managerservice.rest.security.AtlassianLicenceFilter;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atlassian"})
public class AtlassianRestService {
    private static final Logger LOG = Logger.getLogger(AtlassianRestService.class.getName());
    private NamedCompletableCollection<String, List<WebConnectionStatus>> deviceToFuture;
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private LicenseManager mgr;
    @Autowired
    private CompletableManager completeMgr;

    @Bean
    public FilterRegistrationBean<AtlassianLicenceFilter> atlassianlicenseFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new AtlassianLicenceFilter(this.mgr));
        registrationBean.addUrlPatterns(new String[]{"/api/atlassian/*"});
        return registrationBean;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.deviceToFuture = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void handlePathStatusChange(AtlassianPathStatusEvent ev) {
        String path = ev.getPath();
        this.deviceToFuture.completeIfContains((Object)path, Collections.singletonList(new WebConnectionStatus(path, ev.isOk(), ev.getReason())));
    }

    @PostMapping(value={"/checkPath"})
    public boolean checkPath(@RequestParam(value="path") String path) {
        return this.endpointController.checkAtlassianPath(path.trim());
    }

    @Async
    @PostMapping(value={"/status"})
    public CompletableFuture<List<WebConnectionStatus>> getStatus(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        return this.deviceToFuture.putOrUpdate((Object)deviceId, 10);
    }
}

