/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.AtlassianSpacesEvent;
import com.geolang.ascema.managerevents.BitBucketReposEvent;
import com.geolang.ascema.managerevents.CloudUsersAndGroupsEvent;
import com.geolang.ascema.managerevents.ConfirmResultEvent;
import com.geolang.ascema.managerevents.DatabaseResultsAvailableEvent;
import com.geolang.ascema.managerevents.EmailChangeEvent;
import com.geolang.ascema.managerevents.JiraProjectsEvent;
import com.geolang.ascema.managerevents.JiraSecuritySchemesEvent;
import com.geolang.ascema.managerevents.JobStateChangeEvent;
import com.geolang.ascema.managerevents.LicenseChangeEvent;
import com.geolang.ascema.managerevents.ProgressEvent;
import com.geolang.ascema.managerevents.ResultsAvailableEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerevents.UpdateDeviceCapabilitiesEvent;
import com.geolang.ascema.managerevents.UserNotificationChangeEvent;
import com.geolang.ascema.managerservice.rest.asyncmessages.BaseMessage;
import com.geolang.ascema.managerservice.rest.asyncmessages.CloudPlatformTypes;
import com.geolang.ascema.managerservice.rest.asyncmessages.EmailChange;
import com.geolang.ascema.managerservice.rest.asyncmessages.IgnoreJobComplete;
import com.geolang.ascema.managerservice.rest.asyncmessages.JobProgress;
import com.geolang.ascema.managerservice.rest.asyncmessages.JobUpdate;
import com.geolang.ascema.managerservice.rest.asyncmessages.LicenseChange;
import com.geolang.ascema.managerservice.rest.asyncmessages.ResultsAvailable;
import com.geolang.ascema.managerservice.rest.asyncmessages.ResultsChanged;
import com.geolang.ascema.managerservice.rest.asyncmessages.SessionChange;
import com.geolang.ascema.managerservice.rest.asyncmessages.UpdateDeviceCapabilities;
import com.geolang.ascema.managerservice.rest.asyncmessages.UserNotificationAvailable;
import com.geolang.ascema.managerservice.rest.requests.o365.CloudUsersAndGroups;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/async"})
public class AsyncService {
    private static final Logger LOG = Logger.getLogger(AsyncService.class.getName());
    private final List<SseEmitter> emitters = new CopyOnWriteArrayList();
    private final Map<String, Integer> delayMap = new HashMap();
    private Instant lastSentResults = Instant.now();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultsAvailableWithDelay(String deviceId, String jobId) {
        String key = deviceId + jobId;
        if (this.lastSentResults.plus(1L, ChronoUnit.SECONDS).isAfter(Instant.now())) {
            Map map = this.delayMap;
            synchronized (map) {
                if (this.delayMap.containsKey(key)) {
                    this.delayMap.put(key, (Integer)this.delayMap.get(key) + 1);
                } else {
                    this.delayMap.put(key, 1);
                }
            }
        } else {
            if (this.delayMap.containsKey(key)) {
                this.addNewBaseMessage((BaseMessage)new ResultsAvailable(deviceId, jobId, (Integer)this.delayMap.get(key) + 1));
                this.delayMap.remove(key);
            } else {
                this.addNewBaseMessage((BaseMessage)new ResultsAvailable(deviceId, jobId, 1));
            }
            this.lastSentResults = Instant.now();
        }
    }

    private void addNewBaseMessage(BaseMessage base) {
        ArrayList<SseEmitter> failed = new ArrayList<SseEmitter>();
        for (SseEmitter emitter : this.emitters) {
            try {
                emitter.send((Object)base);
            }
            catch (IOException e) {
                emitter.complete();
                LOG.fine("sse emitter done");
                failed.add(emitter);
            }
        }
        if (!failed.isEmpty()) {
            this.emitters.removeAll(failed);
        }
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void onJobChange(JobStateChangeEvent ev) {
        JobUpdate ju = new JobUpdate(ev.getTaskInstanceId(), ev.getDeviceId(), ev.getState().ordinal());
        this.addNewBaseMessage((BaseMessage)ju);
    }

    @Subscribe
    public void onUpdateAgentCapabilities(UpdateDeviceCapabilitiesEvent ev) {
        this.addNewBaseMessage((BaseMessage)new UpdateDeviceCapabilities(ev));
    }

    @Subscribe
    public void onEmailChange(EmailChangeEvent ev) {
        this.addNewBaseMessage((BaseMessage)new EmailChange(ev));
    }

    @Subscribe
    public void handleSessionsChange(SessionChangeEvent ev) {
        this.addNewBaseMessage((BaseMessage)new SessionChange(ev));
    }

    @Subscribe
    public void handleUserNotificationChange(UserNotificationChangeEvent ev) {
        this.addNewBaseMessage((BaseMessage)new UserNotificationAvailable(ev));
    }

    @Subscribe
    public void handleJobChange(ResultsAvailableEvent ev) {
        this.addResultsAvailableWithDelay(ev.getDeviceId(), ev.getJobId());
    }

    @Subscribe
    public void handledbJobChange(DatabaseResultsAvailableEvent ev) {
        this.addResultsAvailableWithDelay(ev.getDeviceId(), ev.getJobId());
    }

    @Subscribe
    public void handleResultsChanged(ConfirmResultEvent ev) {
        this.addNewBaseMessage((BaseMessage)new ResultsChanged(ev));
    }

    @Subscribe
    void handleLicenseChange(LicenseChangeEvent ev) {
        this.addNewBaseMessage((BaseMessage)new LicenseChange(ev));
    }

    @Subscribe
    void handleProgressEvent(ProgressEvent ev) {
        this.addNewBaseMessage((BaseMessage)new JobProgress(ev));
    }

    @Subscribe
    public void handleAvailableSpaces(AtlassianSpacesEvent ev) {
        this.addNewBaseMessage((BaseMessage)CloudPlatformTypes.fromSpaces((List)ev.getSpaces()));
    }

    @Subscribe
    public void handleJiraProjectsAvailable(JiraProjectsEvent ev) {
        this.addNewBaseMessage((BaseMessage)CloudPlatformTypes.fromProjects((List)ev.getProjects()));
    }

    @Subscribe
    public void handleJiraSecuritySchemeesAvailable(JiraSecuritySchemesEvent ev) {
        this.addNewBaseMessage(CloudPlatformTypes.fromSecuritySchemes((List)ev.getSchemes()));
    }

    @Subscribe
    void handleBitbucketReposAvailable(BitBucketReposEvent ev) {
        this.addNewBaseMessage((BaseMessage)CloudPlatformTypes.fromRepos((List)ev.getRepos()));
    }

    @Subscribe
    public void handleAvailableUsers(CloudUsersAndGroupsEvent ev) {
        this.addNewBaseMessage((BaseMessage)CloudPlatformTypes.fromUsersAndGroups((CloudUsersAndGroups)new CloudUsersAndGroups(ev.getUsers(), ev.getGroups(), ev.getDeviceType())));
    }

    @Subscribe
    public void handleIgnoreJobComplete(IgnoreJobComplete ev) {
        this.addNewBaseMessage((BaseMessage)ev);
    }

    @GetMapping(path={"/sse"}, produces={"text/event-stream"})
    public SseEmitter subscribe() {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        this.emitters.add(emitter);
        LOG.fine("number of subscribers is " + this.emitters.size());
        emitter.onCompletion(() -> {
            this.emitters.remove(emitter);
            LOG.info("Emitter removed onCompletion");
        });
        emitter.onTimeout(() -> {
            this.emitters.remove(emitter);
            LOG.info("Emitter removed onTimout");
        });
        return emitter;
    }
}

