/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.indexingcommon.endpoint.alfresco.AspectTree;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.AlfrescoAspectsEvent;
import com.geolang.ascema.managerevents.AlfrescoPathStatusEvent;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.CompletableCollection;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.geolang.ascema.managerservice.rest.TimedCompletableFuture;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebAspect;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebConnectionStatus;
import com.geolang.ascema.managerservice.rest.security.AlfrescoLicenseFilter;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alfresco"})
public class AlfrescoRestService {
    private NamedCompletableCollection<String, WebConnectionStatus> deviceToFuture;
    private CompletableCollection<List<WebAspect>> waitingForAspectsCollection;
    private AspectTree allAspects = null;
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private LicenseManager mgr;
    @Autowired
    private CompletableManager completeMgr;

    @Bean
    public FilterRegistrationBean<AlfrescoLicenseFilter> licenseFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new AlfrescoLicenseFilter(this.mgr));
        registrationBean.addUrlPatterns(new String[]{"/api/alfresco/*"});
        return registrationBean;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.waitingForAspectsCollection = this.completeMgr.newCompletableCollection(Collections.emptyList());
        this.deviceToFuture = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void handleNewAspects(AlfrescoAspectsEvent ev) {
        this.allAspects = ev.getAspects();
        ArrayList<WebAspect> ret = new ArrayList<WebAspect>();
        List roots = this.allAspects.getRoots();
        roots.sort((a, b) -> a.getData().getDisplayName().compareTo(b.getData().getDisplayName()));
        for (AspectTree.Node node : roots) {
            WebAspect wa = new WebAspect(node.getData(), this.allAspects.getHostname());
            ret.add(wa);
            this.addChildNodes(wa, node.getChildren());
        }
        this.waitingForAspectsCollection.completeAll(ret);
    }

    private void addChildNodes(WebAspect parent, List<AspectTree.Node> children) {
        for (AspectTree.Node node : children) {
            WebAspect wa = new WebAspect(node.getData(), parent.getHostname());
            parent.addChild(wa);
            this.addChildNodes(wa, node.getChildren());
        }
    }

    @Subscribe
    public void handlePathStatusChange(AlfrescoPathStatusEvent ev) {
        String path = ev.getPath();
        this.deviceToFuture.completeIfContains((Object)path, (Object)new WebConnectionStatus(ev.getPath(), ev.isOk(), ev.getReason()));
    }

    @RequestMapping(value={"/getaspects"})
    public boolean getAspects() {
        this.endpointController.getAspects();
        return true;
    }

    @PostMapping(value={"/checkPath"})
    public boolean checkPath(@RequestParam(value="path") String path) {
        return this.endpointController.checkAlfrescoPath(path.trim());
    }

    @Async
    @PostMapping(value={"/status"})
    public CompletableFuture<WebConnectionStatus> getStatus(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        return this.deviceToFuture.putOrUpdate((Object)deviceId, 10);
    }

    @Async
    @RequestMapping(value={"/aspectstatus"})
    public CompletableFuture<List<WebAspect>> getStatus() throws InterruptedException {
        TimedCompletableFuture f = new TimedCompletableFuture(new CompletableFuture(), 60);
        this.waitingForAspectsCollection.add(f);
        return f.getFuture();
    }
}

