/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.indexingcommon.endpoint.google.DriveLabelModificationCommand;
import com.geolang.ascema.indexingcommon.endpoint.google.DriveLabelModificationSerialisation;
import com.geolang.ascema.indexingcommon.endpoint.o365.O365Category;
import com.geolang.ascema.indexingcommon.endpoint.o365.O365CategoryColour;
import com.geolang.ascema.indexingcommon.endpoint.o365.O365CategorySerialisation;
import com.geolang.ascema.managerdomain.actions.InFlightAndDeferredActionsCollection;
import com.geolang.ascema.managerdomain.actions.InFlightName;
import com.geolang.ascema.managerdomain.domain.DeferredAction;
import com.geolang.ascema.managerdomain.web.WebHostAndPath;
import com.geolang.ascema.managerdomain.web.actions.ActionableDataPointDetails;
import com.geolang.ascema.managerdomain.web.actions.ActionableResultsDataSliceRequest;
import com.geolang.ascema.managerdomain.web.actions.ActionableResultsPage;
import com.geolang.ascema.managerdomain.web.actions.BulkActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.DeferredBulkActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.DeferredHostAndPathActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.DeviceWithActionableTasks;
import com.geolang.ascema.managerdomain.web.actions.SimpleActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.WebDeferredAction;
import com.geolang.ascema.managerdomain.web.actions.WebInFlight;
import com.geolang.ascema.managerdomain.web.actions.WebInFlightName;
import com.geolang.ascema.managerpersistence.DeferredActionSummary;
import com.geolang.ascema.managerservice.controllers.tasks.actions.ActionsController;
import com.geolang.ascema.managerservice.controllers.tasks.actions.DeferredActionsController;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/actions"})
public class ActionsRestService {
    @Autowired
    private ActionsController actionRunner;
    @Autowired
    private DeferredActionsController deferredController;
    @Autowired
    private InFlightAndDeferredActionsCollection inFlightCollection;

    @GetMapping(value={"/list"})
    ResponseEntity<List<WebDeferredAction>> getAllDeferred() {
        ArrayList<WebDeferredAction> ret = new ArrayList<WebDeferredAction>();
        for (DeferredAction da : this.deferredController.getAllDeferredActions()) {
            ret.add(new WebDeferredAction(da));
        }
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/listsummary"})
    ResponseEntity<List<DeferredActionSummary>> getAllDeferredSummary() {
        List ret = this.deferredController.getAllDeferredActionSummary();
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/listfromname"})
    public ResponseEntity<List<WebDeferredAction>> listFromName(@RequestParam(value="name") String name) {
        ArrayList<WebDeferredAction> ret = new ArrayList<WebDeferredAction>();
        for (DeferredAction da : this.deferredController.getAllDeferredActionsFromName(name)) {
            ret.add(new WebDeferredAction(da));
        }
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/deletebyname"})
    public long deleteDeferredByName(Principal principal, @RequestParam(value="name") String name) {
        return this.deferredController.deleteDeferredByName(principal.getName(), name);
    }

    @PostMapping(value={"/delete"})
    public boolean deleteDeferred(Principal principal, @RequestParam(value="id") Long id) {
        return this.deferredController.deleteDeferred(principal.getName(), id);
    }

    @GetMapping(value={"/listinflight"})
    public ResponseEntity<List<WebInFlightName>> getInFlightGroupNames() {
        List inf = this.inFlightCollection.getGroupNames();
        ArrayList<WebInFlightName> ret = new ArrayList<WebInFlightName>();
        for (InFlightName n : inf) {
            ret.add(new WebInFlightName(n));
        }
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/getinflightgroup"})
    public ResponseEntity<List<WebInFlight>> inFlightFromName(@RequestParam(value="inflight") WebInFlightName inf) {
        List ret = this.inFlightCollection.getInFlightForGroupName(inf.toInFlightName()).stream().map(e -> new WebInFlight(e)).collect(Collectors.toList());
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/performsimple"})
    public ResponseEntity<String> performActions(Principal principal, @RequestBody SimpleActionsCommand com) {
        List ret = this.actionRunner.runSimpleActions(principal.getName(), com);
        if (ret == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)((String)ret.get(0)), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/performbulk"})
    public ResponseEntity<WebInFlightName> performBulkActions(Principal principal, @RequestBody BulkActionsCommand com) {
        InFlightName ret = this.actionRunner.runBulkActions(principal.getName(), com);
        if (ret == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new WebInFlightName(ret), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/performdeferredbulk"})
    public boolean performDeferredBulkActions(Principal principal, @RequestBody DeferredBulkActionsCommand com) {
        return this.deferredController.createDeferredBulkActions(principal.getName(), com);
    }

    @PostMapping(value={"/drivelabelmodificationser"})
    public String serializeDriveLabelModificationCommand(@RequestBody DriveLabelModificationCommand com) {
        return DriveLabelModificationSerialisation.toJson((DriveLabelModificationCommand)com);
    }

    @RequestMapping(value={"/o365categoryser/{name}/{colour}"})
    public ResponseEntity<String> serializeO365Category(@PathVariable(value="name") String name, @PathVariable(value="colour") int colour) {
        O365CategoryColour[] allowed = O365CategoryColour.values();
        if (colour < allowed.length) {
            O365CategoryColour convertedColour = allowed[colour];
            O365Category cat = new O365Category(name, convertedColour);
            String ret = O365CategorySerialisation.toJson((O365Category)cat);
            if (!ret.isEmpty()) {
                return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
            }
        } else {
            Logger.getLogger(ActionsRestService.class.getName()).log(Level.WARNING, "colour is out of bounds {0}  {1}", new Object[]{name, colour});
        }
        Logger.getLogger(ActionsRestService.class.getName()).log(Level.WARNING, "failed to convert {0}  {1}", new Object[]{name, colour});
        return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @PostMapping(value={"/results"})
    public ResponseEntity<ActionableResultsPage> getPaginatedResults(@RequestParam(value="filter") ActionableResultsDataSliceRequest filter) {
        ActionableResultsPage res = this.actionRunner.getPageOfActionableResults(filter);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/actionabledevices"})
    public ResponseEntity<List<DeviceWithActionableTasks>> getActionableDevices() {
        List ret = this.actionRunner.getActionableDevices();
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/dpdetails"})
    public ResponseEntity<List<ActionableDataPointDetails>> getDatapointDetails(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="taskId") String taskId, @RequestParam(value="actId") String actionableId) {
        List res = this.actionRunner.getDatapointDetails(deviceId, taskId, actionableId);
        return ResponseEntity.ok((Object)res);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(SimpleActionsCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DeferredHostAndPathActionsCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebHostAndPath.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DriveLabelModificationCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(ActionableResultsDataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(BulkActionsCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DeferredBulkActionsCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebInFlightName.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

