/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.savedpatterns;

import com.geolang.ascema.domainmodelpublic.pattern.SpecialPatternType;
import com.geolang.ascema.managerdomain.domain.SavedCompoundPattern;
import com.geolang.ascema.managerdomain.domain.SavedPattern;
import com.geolang.ascema.managerdomain.domain.SavedSimilarFile;
import com.geolang.ascema.managerpersistence.savedpatterns.IPatternSerialization;
import com.geolang.ascema.managerpersistence.savedpatterns.ISavedPatternRepository;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.persist.savedpatterns.SerializationFST;
import com.geolang.ascema.patternmatching.patterns.MIPLabelPattern;
import com.geolang.ascema.patternmatching.patterns.MetadataPattern;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PatternStore {
    private final IPatternSerialization serialiser = new SerializationFST();
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private ISavedPatternRepository repo;

    @Transactional
    public boolean patternExistsByName(String name) {
        return this.repo.findBySavedNameIgnoreCase(name).isPresent();
    }

    public void deletePatternByName(String name, String user) {
        this.repo.deleteById((Object)name);
        this.auditLog.patternDeleted(name, user);
    }

    public Iterable<SavedPattern> getAll() {
        return this.repo.findAll();
    }

    public Optional<List<String>> getKeywordListsByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.keywordListFromSavedPattern((SavedPattern)opt.get()));
    }

    public List<String> keywordListFromSavedPattern(SavedPattern sp) {
        return (List)this.serialiser.asObject(sp.getPatternBlob());
    }

    public boolean addOrUpdateKeywordList(String name, List<String> strings, String user) {
        byte[] bytea = this.serialiser.asByteArray(strings);
        SavedPattern sp = new SavedPattern(name, bytea, SpecialPatternType.LISTKEYWORD);
        this.save(sp, user);
        return true;
    }

    public Optional<String> getKeywordByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.keywordFromSavedPattern((SavedPattern)opt.get()));
    }

    public String keywordFromSavedPattern(SavedPattern sp) {
        byte[] bytes = sp.getPatternBlob();
        Charset charset = StandardCharsets.UTF_8;
        return new String(bytes, charset);
    }

    public boolean addOrUpdateKeyword(String name, String kw, String user) {
        Charset charset = StandardCharsets.UTF_8;
        byte[] bytes = kw.getBytes(charset);
        SavedPattern sp = new SavedPattern(name, bytes, SpecialPatternType.KEYWORD);
        this.save(sp, user);
        return true;
    }

    public Optional<String> getFilenamePatternByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.filenamePatternFromSavedPattern((SavedPattern)opt.get()));
    }

    public String filenamePatternFromSavedPattern(SavedPattern sp) {
        byte[] bytes = sp.getPatternBlob();
        Charset charset = StandardCharsets.UTF_8;
        return new String(bytes, charset);
    }

    public boolean addOrUpdateFilenamePattern(String name, String kw, String user) {
        Charset charset = StandardCharsets.UTF_8;
        byte[] bytes = kw.getBytes(charset);
        SavedPattern sp = new SavedPattern(name, bytes, SpecialPatternType.FILENAME);
        this.save(sp, user);
        return true;
    }

    public Optional<MetadataPattern> getMetadataPatternByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.metadataFromSavedPattern((SavedPattern)opt.get()));
    }

    public MetadataPattern metadataFromSavedPattern(SavedPattern sp) {
        byte[] bytes = sp.getPatternBlob();
        Charset charset = StandardCharsets.UTF_8;
        String name = new String(bytes, charset);
        return MetadataPattern.fromName((String)name);
    }

    public boolean addOrUpdateMetadataPattern(String key, String val, String name, String user) {
        MetadataPattern mp = new MetadataPattern(key, val);
        String str = mp.getName();
        Charset charset = StandardCharsets.UTF_8;
        byte[] bytes = str.getBytes(charset);
        SavedPattern sp = new SavedPattern(name, bytes, SpecialPatternType.METADATA);
        this.save(sp, user);
        return true;
    }

    public Optional<MIPLabelPattern> getMipLabelPatternByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.mipLabelFromSavedPattern((SavedPattern)opt.get()));
    }

    public MIPLabelPattern mipLabelFromSavedPattern(SavedPattern sp) {
        byte[] bytes = sp.getPatternBlob();
        Charset charset = StandardCharsets.UTF_8;
        String name = new String(bytes, charset);
        return MIPLabelPattern.fromName((String)name);
    }

    public boolean addOrUpdateMipLabelPattern(String displayName, List<MIPLabelPattern.MipIdAndLabel> val, String user) {
        MIPLabelPattern mp = new MIPLabelPattern(val, displayName);
        String str = mp.getName();
        Charset charset = StandardCharsets.UTF_8;
        byte[] bytes = str.getBytes(charset);
        SavedPattern sp = new SavedPattern(displayName, bytes, SpecialPatternType.MIPS_LABEL);
        this.save(sp, user);
        return true;
    }

    public Optional<String> getRegexByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.regexFromSavedPattern((SavedPattern)opt.get()));
    }

    public String regexFromSavedPattern(SavedPattern sp) {
        byte[] bytes = sp.getPatternBlob();
        Charset charset = StandardCharsets.UTF_8;
        return new String(bytes, charset);
    }

    public boolean addOrUpdateRegex(String name, String regex, String user) {
        Charset charset = StandardCharsets.UTF_8;
        byte[] bytes = regex.getBytes(charset);
        SavedPattern sp = new SavedPattern(name, bytes, SpecialPatternType.REGEX);
        this.save(sp, user);
        return true;
    }

    public Optional<SavedCompoundPattern> getCompoundByName(String name) {
        Optional scb = this.repo.findById((Object)name);
        if (!scb.isPresent()) {
            return Optional.empty();
        }
        SavedCompoundPattern ret = this.savedCompoundPatternFromSavedPattern((SavedPattern)scb.get());
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public SavedCompoundPattern savedCompoundPatternFromSavedPattern(SavedPattern sp) {
        return (SavedCompoundPattern)this.serialiser.asObject(sp.getPatternBlob());
    }

    public SavedCompoundPattern saveCompound(SavedCompoundPattern in, String user) {
        byte[] bytea = this.serialiser.asByteArray((Object)in);
        SavedPattern sp = new SavedPattern(in.getName(), bytea, SpecialPatternType.COMPLEX);
        this.save(sp, user);
        return in;
    }

    List<SavedCompoundPattern> getAllCompound() {
        ArrayList<SavedCompoundPattern> ret = new ArrayList<SavedCompoundPattern>();
        for (SavedPattern blob : this.repo.findByType(SpecialPatternType.COMPLEX)) {
            SavedCompoundPattern s = (SavedCompoundPattern)this.serialiser.asObject(blob.getPatternBlob());
            ret.add(s);
        }
        return ret;
    }

    public boolean addOrUpdateSimilarFile(String filePath, String hash, String displayName, String user) {
        SavedSimilarFile in = new SavedSimilarFile(displayName, hash, filePath);
        byte[] bytea = this.serialiser.asByteArray((Object)in);
        SavedPattern sp = new SavedPattern(displayName, bytea, SpecialPatternType.SIMILAR_FILE);
        this.save(sp, user);
        return true;
    }

    public Optional<SavedSimilarFile> getSimilarFileByName(String name) {
        Optional opt = this.repo.findById((Object)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.similarFileFromSavedPattern((SavedPattern)opt.get()));
    }

    public SavedSimilarFile similarFileFromSavedPattern(SavedPattern sp) {
        return (SavedSimilarFile)this.serialiser.asObject(sp.getPatternBlob());
    }

    public void save(SavedPattern sp, String user) {
        this.auditLog.patternCreated(sp, user);
        this.repo.save((Object)sp);
    }
}

