/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.savedpatterns;

import com.geolang.ascema.managerdomain.domain.SavedCompoundPattern;
import com.geolang.ascema.managerservice.persist.savedpatterns.PatternStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CompoundPatternCache {
    private final Map<String, SavedCompoundPattern> byDescriptionCache = new HashMap();
    private final PatternStore repo;

    public CompoundPatternCache(PatternStore store) {
        this.repo = store;
    }

    public void init() {
        List all = this.getAll();
        for (SavedCompoundPattern p : all) {
            this.byDescriptionCache.put(p.getDescription(), p);
        }
    }

    public Optional<SavedCompoundPattern> findByName(String name) {
        return this.repo.getCompoundByName(name);
    }

    public Optional<SavedCompoundPattern> findByDescription(String desc) {
        SavedCompoundPattern ret = (SavedCompoundPattern)this.byDescriptionCache.get(desc);
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public SavedCompoundPattern addOrUpdate(SavedCompoundPattern req, String user) {
        this.byDescriptionCache.put(req.getDescription(), req);
        return this.repo.saveCompound(req, user);
    }

    public synchronized boolean delete(String name, String user) {
        Optional s = this.findByName(name);
        if (!s.isPresent()) {
            return false;
        }
        SavedCompoundPattern pat = (SavedCompoundPattern)s.get();
        this.byDescriptionCache.remove(pat.getDescription());
        this.repo.deletePatternByName(pat.getName(), user);
        return true;
    }

    public List<SavedCompoundPattern> getAll() {
        return this.repo.getAllCompound();
    }
}

