/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.keys;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStore;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStoreBackgroundWriter;
import com.geolang.ascema.managerservice.persist.keys.PemStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.security.KeyPair;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.util.binary.BasicBinaryEncryptor;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class KeyPairStoreBackgroundWriter {
    private static final Logger LOG = Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName());
    private static final String FILENAME = "ks.npkcs12";
    private final File file;
    private final Set<KPAndDevice> store;
    BasicBinaryEncryptor binaryEncryptor = new BasicBinaryEncryptor();
    ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("KeyPairStoreBackgroundWriter-"));

    public KeyPairStoreBackgroundWriter(Provider bcProvider) {
        Object pw = System.getProperty("ASCEMA_KS_PW");
        if (null == pw) {
            pw = "##KSPersistence##" + SettingsFile.getInstance().getKeyFileSec();
        }
        String journalEncryptStr = "sdfsdfsd" + (String)pw + "3249082rejd";
        this.binaryEncryptor.setPassword(journalEncryptStr);
        String ksFolder = WorkingFolder.getKeyStoreFolder();
        String filePath = ksFolder + File.separator + FILENAME;
        this.file = new File(filePath);
        try {
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(KeyPairStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.file.length() != 0L) {
            byte[] fileContent = null;
            try {
                fileContent = Files.readAllBytes(this.file.toPath());
            }
            catch (IOException ex) {
                Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.store = fileContent != null ? Collections.synchronizedSet(this.bin2KeyPairList(fileContent)) : Collections.synchronizedSet(new HashSet());
        } else {
            this.store = Collections.synchronizedSet(new HashSet());
        }
    }

    public void stop() {
        this.executor.shutdown();
    }

    Map<String, KeyPair> getStore() {
        HashMap<String, KeyPair> ret = new HashMap<String, KeyPair>();
        for (KPAndDevice kpd : this.store) {
            try {
                KeyPair kp = PemStore.decKey((byte[])kpd.kp, (String)kpd.devId);
                ret.put(kpd.devId, kp);
            }
            catch (IOException ex) {
                Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ret;
    }

    void cleanForTesting() {
        try {
            this.file.delete();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void add(String devId, KeyPair kp) {
        if (devId == null || devId.isEmpty()) {
            LOG.warning("no deviceId in add");
            return;
        }
        try {
            byte[] arr = PemStore.encKey((KeyPair)kp, (String)devId);
            KPAndDevice kpd = new KPAndDevice(arr, devId);
            this.store.add(kpd);
            this.executor.submit(() -> {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.write();
            });
        }
        catch (IOException ex) {
            Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() {
        byte[] bytes;
        if (this.executor.getQueue().size() > 0) {
            return;
        }
        Set set = this.store;
        synchronized (set) {
            bytes = this.keyPairList2Bin(this.store);
        }
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            fos.write(bytes);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(KeyPairStoreBackgroundWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Set<KPAndDevice> bin2KeyPairList(byte[] in) {
        byte[] data;
        try {
            data = this.binaryEncryptor.decrypt(in);
        }
        catch (EncryptionOperationNotPossibleException e) {
            LOG.log(Level.SEVERE, "Failed to decrypt file {0}", e.getMessage());
            return Collections.emptySet();
        }
        try (ByteArrayInputStream b = new ByteArrayInputStream(data);){
            Set set;
            try (ObjectInputStream o = new ObjectInputStream(b);){
                Object obj = o.readObject();
                set = (Set)obj;
            }
            return set;
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.severe(e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] keyPairList2Bin(Set<KPAndDevice> kp) {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(kp);
                byArray = this.binaryEncryptor.encrypt(b.toByteArray());
            }
            return byArray;
        }
        catch (IOException e) {
            LOG.severe(e.getLocalizedMessage());
            return null;
        }
    }
}

