/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.keys;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStoreBackgroundWriter;
import java.io.IOException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;

@Service
public class KeyPairStore
implements DisposableBean {
    private static final Logger LOG = Logger.getLogger(KeyPairStore.class.getName());
    private final KeyPairStoreBackgroundWriter writer;
    private Provider bcProvider;
    private Map<String, KeyPair> map = new ConcurrentHashMap();

    public KeyPairStore() {
        this.bcProvider = new BouncyCastleProvider();
        Security.addProvider(this.bcProvider);
        this.writer = new KeyPairStoreBackgroundWriter(this.bcProvider);
        this.map = this.writer.getStore();
        LOG.log(Level.INFO, "Loaded {0} keys", this.map.size());
    }

    public void destroy() throws Exception {
        this.writer.stop();
    }

    void clearForTesting() throws IOException {
        if (!WorkingFolder.isSetForTesting()) {
            throw new AssertionError((Object)"no no no");
        }
        this.map.clear();
        this.writer.cleanForTesting();
    }

    public boolean saveKeyPairForDevice(String deviceId, KeyPair kp) {
        this.map.put(deviceId, kp);
        this.writer.add(deviceId, kp);
        return true;
    }

    public Optional<KeyPair> getKeyPairForDevice(String deviceId) {
        if (this.map.containsKey(deviceId)) {
            return Optional.of((KeyPair)this.map.get(deviceId));
        }
        LOG.log(Level.WARNING, "No key found for {0}", deviceId);
        return Optional.empty();
    }
}

