/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.domainmodelpublic.pattern.MIPLabelDefaults;
import com.geolang.ascema.endpointcommon.domain.clouditems.MIPLabel;
import com.geolang.ascema.managerevents.O365MipLabelsEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class O365MipLabelsCache {
    private static final Logger LOG = Logger.getLogger(O365MipLabelsCache.class.getName());
    Map<String, List<MIPLabel>> hostToLabels = new HashMap();

    public synchronized void add(O365MipLabelsEvent ev) {
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            LOG.log(Level.INFO, "set {0} mip labels", ev.getLabels().size());
            this.hostToLabels.put(ev.getHost(), ev.getLabels());
        } else {
            LOG.warning("No host in O365MipLabelsEvent");
        }
    }

    public synchronized List<MIPLabel> getForHost(String host) {
        if (this.hostToLabels.containsKey(host)) {
            List ret = (List)this.hostToLabels.get(host);
            Collections.sort(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public synchronized void clearForHost(String host) {
        this.hostToLabels.remove(host);
    }

    public List<MIPLabel> getDefault() {
        ArrayList<MIPLabel> ret = new ArrayList<MIPLabel>();
        for (MIPLabelDefaults.DefaultLabel m : MIPLabelDefaults.getDefaultLabels()) {
            ret.add(new MIPLabel("", m.id(), m.name(), "", "", m.tooltip(), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE));
        }
        return ret;
    }
}

