/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.endpointcommon.domain.clouditems.JiraIssueSecurityLevel;
import com.geolang.ascema.managerevents.JiraSecuritySchemesEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class JiraSecuritySchemeCache {
    private static final Logger LOG = Logger.getLogger(JiraSecuritySchemeCache.class.getName());
    Map<String, List<JiraIssueSecurityLevel>> hostToLevel = new HashMap();

    public synchronized void add(JiraSecuritySchemesEvent ev) {
        LOG.log(Level.INFO, "add {0} security schemes for {1}", new Object[]{ev.getSchemes().size(), ev.getHost()});
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            this.hostToLevel.put(ev.getHost(), ev.getSchemes());
        }
    }

    public synchronized List<JiraIssueSecurityLevel> getForHost(String host) {
        if (this.hostToLevel.containsKey(host)) {
            List ret = (List)this.hostToLevel.get(host);
            Collections.sort(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public synchronized void clearForHost(String host) {
        this.hostToLevel.remove(host);
    }
}

