/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.endpointcommon.domain.clouditems.JiraProject;
import com.geolang.ascema.managerevents.JiraProjectsEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class JiraProjectCache {
    private static final Logger LOG = Logger.getLogger(JiraProjectCache.class.getName());
    Map<String, List<JiraProject>> hostToProj = new HashMap();

    public synchronized void add(JiraProjectsEvent ev) {
        LOG.log(Level.INFO, "add {0} jira projects for {1}", new Object[]{ev.getProjects().size(), ev.getHost()});
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            this.hostToProj.put(ev.getHost(), ev.getProjects());
        }
    }

    public synchronized List<JiraProject> getForHost(String host) {
        if (this.hostToProj.containsKey(host)) {
            List ret = (List)this.hostToProj.get(host);
            Collections.sort(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public synchronized void clearForHost(String host) {
        this.hostToProj.remove(host);
    }
}

