/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.indexingcommon.endpoint.google.GoogleDriveLabel;
import com.geolang.ascema.managerevents.GoogleDriveLabelsEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class GoogleDriveLabelsCache {
    private static final Logger LOG = Logger.getLogger(GoogleDriveLabelsCache.class.getName());
    Map<String, List<GoogleDriveLabel>> hostToLabels = new HashMap();

    public synchronized void add(GoogleDriveLabelsEvent ev) {
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            LOG.log(Level.INFO, "set {0} gdrive labels", ev.getLabels().size());
            this.hostToLabels.put(ev.getHost(), ev.getLabels());
        } else {
            LOG.warning("No host in googleLabelsEvent");
        }
    }

    public synchronized List<GoogleDriveLabel> getForHost(String host) {
        if (this.hostToLabels.containsKey(host)) {
            List ret = (List)this.hostToLabels.get(host);
            Collections.sort(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public synchronized void clearForHost(String host) {
        this.hostToLabels.remove(host);
    }
}

