/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.endpointcommon.domain.clouditems.AtlassianSpace;
import com.geolang.ascema.managerevents.AtlassianSpacesEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class ConfluenceSpaceCache {
    private static final Logger LOG = Logger.getLogger(ConfluenceSpaceCache.class.getName());
    Map<String, List<AtlassianSpace>> hostToSpace = new HashMap();

    public synchronized void add(AtlassianSpacesEvent ev) {
        LOG.log(Level.INFO, "add {0} spaces for {1}", new Object[]{ev.getSpaces().size(), ev.getHost()});
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            this.hostToSpace.put(ev.getHost(), ev.getSpaces());
        }
    }

    public synchronized List<AtlassianSpace> getForHost(String host) {
        if (this.hostToSpace.containsKey(host)) {
            List ret = (List)this.hostToSpace.get(host);
            Collections.sort(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public synchronized void clearForHost(String host) {
        this.hostToSpace.remove(host);
    }
}

