/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.rest.DataValidation;
import com.geolang.ascema.managerservice.rest.requests.o365.CloudUsersAndGroups;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystemException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class CloudUserGroupStore {
    private static final Logger LOG = Logger.getLogger(CloudUserGroupStore.class.getName());
    private final String folder = WorkingFolder.getUserGroupCacheFolder();

    Optional<CloudUsersAndGroups> getForHost(String host) {
        try {
            String filename = this.hostNameToFileSytemSafe(host);
            String filePath = this.folder + File.separator + filename;
            File f = new File(filePath);
            if (f.exists()) {
                return this.read(f, host);
            }
        }
        catch (FileSystemException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return Optional.empty();
    }

    void setForHost(String host, CloudUsersAndGroups ugs) {
        try {
            this.clearForHost(host);
            String filename = this.hostNameToFileSytemSafe(host);
            String filePath = this.folder + File.separator + filename;
            File f = new File(filePath);
            this.write(f, host, ugs);
            LOG.log(Level.INFO, "Set cache for {0}", host);
        }
        catch (FileSystemException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    void clearForHost(String host) {
        try {
            String filename = this.hostNameToFileSytemSafe(host);
            String filePath = this.folder + File.separator + filename;
            File f = new File(filePath);
            if (f.exists()) {
                f.delete();
                LOG.log(Level.INFO, "clear usergroup cache for {0}", host);
            }
        }
        catch (FileSystemException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    void clearAll() {
        try {
            FileUtils.cleanDirectory((File)new File(this.folder));
            LOG.info("cleared all usergroup caches");
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private String hostNameToFileSytemSafe(String in) throws FileSystemException {
        Object name = in.replaceAll("\\W+", "x");
        if (!DataValidation.isValidNameForFilesystem((String)name) && !DataValidation.isValidNameForFilesystem((String)(name = (String)name + "XXX"))) {
            throw new FileSystemException((String)name);
        }
        return name;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<CloudUsersAndGroups> read(File file, String host) {
        try (FileInputStream fi = new FileInputStream(file);){
            ObjectInputStream in;
            block15: {
                Optional<CloudUsersAndGroups> optional;
                in = new ObjectInputStream(fi);
                try {
                    String h = in.readUTF();
                    if (h.equals(host)) break block15;
                    LOG.log(Level.INFO, "file found for {0} but wrong host {1}", new Object[]{h, host});
                    optional = Optional.empty();
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
                return optional;
            }
            CloudUsersAndGroups ret = (CloudUsersAndGroups)in.readObject();
            Optional<CloudUsersAndGroups> optional = Optional.of(ret);
            in.close();
            return optional;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CloudUserGroupStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(CloudUserGroupStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Optional.empty();
    }

    private void write(File file, String host, CloudUsersAndGroups ugs) {
        try (FileOutputStream f = new FileOutputStream(file);
             ObjectOutputStream out = new ObjectOutputStream(f);){
            out.writeUTF(host);
            out.writeObject(ugs);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CloudUserGroupStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CloudUserGroupStore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

