/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudCredentials;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerevents.CloudUsersAndGroupsEvent;
import com.geolang.ascema.managerservice.persist.cloudcache.CloudUserGroupStore;
import com.geolang.ascema.managerservice.rest.requests.o365.CloudUsersAndGroups;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class CloudUserGroupCache {
    private static final Logger LOG = Logger.getLogger(CloudUserGroupCache.class.getName());
    Map<String, CloudUsersAndGroups> hostToUgs = new HashMap();
    Map<String, CloudUsersAndGroups> replacing = new HashMap();
    private final CloudUserGroupStore store = new CloudUserGroupStore();

    public synchronized void add(CloudUsersAndGroupsEvent ev) {
        LOG.log(Level.INFO, "add {0} users and {1} groups  for {2}", new Object[]{ev.getUsers().size(), ev.getGroups().size(), ev.getHost()});
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            if (ev.isFirstMessage() && ev.isLastMessage()) {
                this.hostToUgs.put(ev.getHost(), new CloudUsersAndGroups(ev.getUsers(), ev.getGroups(), ev.getDeviceType()));
                this.store.setForHost(ev.getHost(), (CloudUsersAndGroups)this.hostToUgs.get(ev.getHost()));
            } else if (ev.isFirstMessage()) {
                if (this.hostToUgs.containsKey(ev.getHost())) {
                    CloudUsersAndGroups rep = (CloudUsersAndGroups)this.hostToUgs.get(ev.getHost());
                    if (!rep.getUsers().isEmpty()) {
                        this.replacing.put(ev.getHost(), rep);
                    }
                    this.hostToUgs.remove(ev.getHost());
                }
                this.hostToUgs.put(ev.getHost(), new CloudUsersAndGroups(ev.getUsers(), ev.getGroups(), ev.getDeviceType()));
            } else if (ev.isLastMessage()) {
                CloudUsersAndGroups ugs = (CloudUsersAndGroups)this.hostToUgs.get(ev.getHost());
                if (ugs == null) {
                    LOG.log(Level.WARNING, "got final message with users from {0} but no existing users??", ev.getHost());
                    this.hostToUgs.put(ev.getHost(), new CloudUsersAndGroups(ev.getUsers(), ev.getGroups(), ev.getDeviceType()));
                } else {
                    ugs.getGroups().addAll(ev.getGroups());
                    ugs.getUsers().addAll(ev.getUsers());
                }
                this.replacing.remove(ev.getHost());
                this.store.setForHost(ev.getHost(), (CloudUsersAndGroups)this.hostToUgs.get(ev.getHost()));
            } else {
                CloudUsersAndGroups ugs = (CloudUsersAndGroups)this.hostToUgs.get(ev.getHost());
                if (ugs == null) {
                    LOG.log(Level.WARNING, "not first message with users from {0} but no existing users??", ev.getHost());
                    this.hostToUgs.put(ev.getHost(), new CloudUsersAndGroups(ev.getUsers(), ev.getGroups(), ev.getDeviceType()));
                } else {
                    ugs.getGroups().addAll(ev.getGroups());
                    ugs.getUsers().addAll(ev.getUsers());
                }
            }
        }
    }

    public synchronized CloudUsersAndGroups getUsersAndGroupsForHost(String host) {
        if (this.replacing.containsKey(host)) {
            return (CloudUsersAndGroups)this.replacing.get(host);
        }
        if (this.hostToUgs.containsKey(host)) {
            return (CloudUsersAndGroups)this.hostToUgs.get(host);
        }
        LOG.log(Level.WARNING, "no users and groups for host {0}", host);
        return new CloudUsersAndGroups(Collections.emptySet(), Collections.emptySet(), DeviceType.ATLASSIAN);
    }

    public synchronized void clearForHost(String host) {
        this.hostToUgs.remove(host);
        this.replacing.remove(host);
    }

    public void loadFromStoreIfEmpty(DeviceRegistration agent) {
        Optional opt = agent.getExpandedCredentials();
        if (opt.isPresent()) {
            String host = ((CloudCredentials)opt.get()).getHost();
            if (this.replacing.containsKey(host) || this.hostToUgs.containsKey(host)) {
                return;
            }
            Optional ugs = this.store.getForHost(host);
            if (ugs.isPresent()) {
                this.hostToUgs.put(host, (CloudUsersAndGroups)ugs.get());
            }
        }
    }
}

