/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.endpointcommon.domain.clouditems.BitbucketRepo;
import com.geolang.ascema.managerevents.BitBucketReposEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class BitbucketRepoCache {
    private static final Logger LOG = Logger.getLogger(BitbucketRepoCache.class.getName());
    Map<String, List<BitbucketRepo>> hostToRepo = new HashMap();

    public synchronized void add(BitBucketReposEvent ev) {
        LOG.log(Level.INFO, "add {0} repos for {1}", new Object[]{ev.getRepos().size(), ev.getHost()});
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            this.hostToRepo.put(ev.getHost(), ev.getRepos());
        }
    }

    public synchronized List<BitbucketRepo> getForHost(String host) {
        if (this.hostToRepo.containsKey(host)) {
            List ret = (List)this.hostToRepo.get(host);
            Collections.sort(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public synchronized void clearForHost(String host) {
        this.hostToRepo.remove(host);
    }
}

