/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.persist.cloudcache;

import com.geolang.ascema.indexingcommon.endpoint.alfresco.AspectTree;
import com.geolang.ascema.managerevents.AlfrescoAspectsEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class AlfrescoAspectCache {
    private static final Logger LOG = Logger.getLogger(AlfrescoAspectCache.class.getName());
    Map<String, AspectTree> hostToAspect = new HashMap();

    public synchronized void add(AlfrescoAspectsEvent ev) {
        LOG.log(Level.INFO, "add aspects for {0}", ev.getHost());
        if (ev.getHost() != null && !ev.getHost().isEmpty()) {
            this.hostToAspect.put(ev.getHost(), ev.getAspects());
        }
    }

    public synchronized AspectTree getForHost(String host) {
        if (this.hostToAspect.containsKey(host)) {
            return (AspectTree)this.hostToAspect.get(host);
        }
        return new AspectTree(host);
    }

    public synchronized void clearForHost(String host) {
        this.hostToAspect.remove(host);
    }
}

