/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging.serverserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.Progress;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.domain.clouditems.CloudItemType;
import com.geolang.ascema.endpointcommon.domain.clouditems.CloudItemsFactory;
import com.geolang.ascema.endpointcommon.jms.JMSCerts;
import com.geolang.ascema.endpointcommon.messages.AlfrescoAspectsMessage;
import com.geolang.ascema.endpointcommon.messages.AlfrescoPathMessage;
import com.geolang.ascema.endpointcommon.messages.AtlassianPathMessage;
import com.geolang.ascema.endpointcommon.messages.CloudItemsMessage;
import com.geolang.ascema.endpointcommon.messages.ConnectionResponseMessage;
import com.geolang.ascema.endpointcommon.messages.MessageBase;
import com.geolang.ascema.endpointcommon.messages.MessageSerialiser;
import com.geolang.ascema.endpointcommon.messages.RespondToJobMessage;
import com.geolang.ascema.endpointcommon.messages.SendLogMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateJobProgressMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateJobStateMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.AlertServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.CancelJobServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.CheckAtlassianPathServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.CheckPathServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.EmailChangeServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetCloudItemsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetCloudUsersServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.JobsAvailableServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.OpenFileServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.PauseJobServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationJMSFac;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIUrlServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.SetCloudCredentialsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.SetFollowNetworkSharesServerMessage;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudCredentials;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerdomain.domain.SecondaryConfig;
import com.geolang.ascema.managerevents.AlfrescoAspectsEvent;
import com.geolang.ascema.managerevents.AlfrescoPathStatusEvent;
import com.geolang.ascema.managerevents.AtlassianPathStatusEvent;
import com.geolang.ascema.managerevents.AtlassianSpacesEvent;
import com.geolang.ascema.managerevents.BitBucketReposEvent;
import com.geolang.ascema.managerevents.ConnectionStatusEvent;
import com.geolang.ascema.managerevents.DeviceLogAvailableEvent;
import com.geolang.ascema.managerevents.EmailChangeEvent;
import com.geolang.ascema.managerevents.JiraProjectsEvent;
import com.geolang.ascema.managerevents.JiraSecuritySchemesEvent;
import com.geolang.ascema.managerevents.NotificationEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerevents.UpdateDeviceCapabilitiesEvent;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.messaging.LocalJMSServer;
import com.geolang.ascema.managerservice.messaging.serverserver.BaseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.ByeServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.ISlave;
import com.geolang.ascema.managerservice.messaging.serverserver.JoinServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.LicenceLimitReachedServerServerMesage;
import com.geolang.ascema.managerservice.messaging.serverserver.NameTakenServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.PingServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.ServerServerMessageJMSFac;
import com.geolang.ascema.managerservice.messaging.serverserver.SessionChangeServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.SlaveEnd;
import com.geolang.ascema.managerservice.messaging.serverserver.UseMasterLicenseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.UseUIServerServerMessage;
import com.google.common.eventbus.Subscribe;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class SlaveEnd
implements ISlave,
ExceptionListener,
MessageListener {
    private ActiveMQSslConnectionFactory factory;
    private Connection connection = null;
    private Queue inboundNotificationsQueue;
    private MessageConsumer consumer;
    private static final Logger LOG = Logger.getLogger(SlaveEnd.class.getName());
    private Session session = null;
    private MessageProducer producer = null;
    private MessageProducer largeProducer = null;
    private final SettingsFile settings = SettingsFile.getInstance();
    private boolean isRunning = false;
    private ThreadPoolExecutor service;
    @Autowired
    private DeviceService endpointService;
    @Autowired
    private TaskManager taskManger;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private ResultsManager searchResultsManager;
    @Autowired
    private AlertingController alertingController;

    public SlaveEnd() {
        MessageBus.getBus().register((Object)this);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean start() {
        try {
            this.stop(false);
            this.service = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("SlaveEnd-"));
            String s = "ssl://" + this.settings.getMasterHost() + ":" + this.settings.getMasterSlavePort() + "?verifyHostName=false";
            LOG.log(Level.INFO, "Connecting to primary on {0}", s);
            this.factory = new ActiveMQSslConnectionFactory(s);
            this.factory.setKeyAndTrustManagers(JMSCerts.getClientKeyManager(), JMSCerts.getClientTrustManager(), new SecureRandom());
            this.factory.setTrustedPackages(new ArrayList<String>(Arrays.asList("java.lang,java.util,com.geolang.ascema".split(","))));
            this.connection = this.factory.createConnection();
            this.connection.setExceptionListener((ExceptionListener)this);
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer((Destination)this.session.createQueue("AscemaServerInQueue"));
            this.producer.setDeliveryMode(2);
            this.largeProducer = this.session.createProducer((Destination)this.session.createQueue("AscemaServerLargeInQueue"));
            this.largeProducer.setDeliveryMode(2);
            this.inboundNotificationsQueue = this.session.createQueue(this.settings.getUUID());
            this.consumer = this.session.createConsumer((Destination)this.inboundNotificationsQueue);
            this.consumer.setMessageListener((MessageListener)this);
            this.isRunning = true;
            this.service.submit(() -> this.join());
            LOG.info("Connected to primary");
            return true;
        }
        catch (JMSException ex) {
            LOG.log(Level.WARNING, "failed to connect {0}", ex.getLocalizedMessage());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public boolean testConnection() {
        try {
            String s = "ssl://" + this.settings.getMasterHost() + ":" + this.settings.getMasterSlavePort() + "?verifyHostName=false";
            LOG.log(Level.INFO, "Testing connection to primary on {0}", s);
            this.factory = new ActiveMQSslConnectionFactory(s);
            this.factory.setKeyAndTrustManagers(JMSCerts.getClientKeyManager(), JMSCerts.getClientTrustManager(), new SecureRandom());
            this.factory.setTrustedPackages(new ArrayList<String>(Arrays.asList("java.lang,java.util,com.geolang.ascema".split(","))));
            this.connection = this.factory.createConnection();
            this.connection.setExceptionListener((ExceptionListener)this);
            this.connection.start();
        }
        catch (Exception ex) {
            Logger.getLogger(SlaveEnd.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        try {
            this.connection.close();
        }
        catch (JMSException ex) {
            Logger.getLogger(SlaveEnd.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public void onException(JMSException jmse) {
        LOG.log(Level.WARNING, "On Secondary end JMS Exception {0}", jmse.getLocalizedMessage());
        this.stop(false);
    }

    public synchronized void stop(boolean forever) {
        if (!this.isRunning()) {
            return;
        }
        this.isRunning = false;
        this.service.submit(() -> this.bye(forever));
        this.service.shutdown();
        try {
            this.service.awaitTermination(20L, TimeUnit.SECONDS);
            LOG.info("Slave Drained OK");
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.connection == null) {
            return;
        }
        LOG.info("Closing Secondary JMS connection");
        try {
            this.connection.close();
            if (this.producer != null) {
                this.producer.close();
            }
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (JMSException ex) {
            LOG.log(Level.WARNING, ex.getLocalizedMessage());
        }
        this.connection = null;
        LOG.info("Closed JMS connection");
    }

    @Subscribe
    public void handleSessionChange(SessionChangeEvent ev) {
        Optional reg = this.endpointService.getDeviceFromId(ev.getDeviceId(), true);
        if (reg.isPresent()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), this.settings.getManagerName(), ev.getReason(), (DeviceRegistration)reg.get(), "");
            this.sendMessageNoReply((BaseServerServerMessage)msg);
        }
    }

    @Subscribe
    public void handleUpdateAgentCapabilities(UpdateDeviceCapabilitiesEvent ev) {
        Optional reg = this.endpointService.getDeviceFromId(ev.getDeviceId(), true);
        if (reg.isPresent()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), this.settings.getManagerName(), SessionChangeEvent.Reason.UPDATED, (DeviceRegistration)reg.get(), "");
            this.sendMessageNoReply((BaseServerServerMessage)msg);
        }
    }

    @Subscribe
    public void handleEmailChange(EmailChangeEvent ev) {
        Optional reg = this.endpointService.getDeviceFromId(ev.getDeviceId(), true);
        if (reg.isPresent()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), this.settings.getManagerName(), SessionChangeEvent.Reason.UPDATED, (DeviceRegistration)reg.get(), "");
            this.sendMessageNoReply((BaseServerServerMessage)msg);
        }
    }

    @Subscribe
    public void handleSendLog(DeviceLogAvailableEvent ev) {
        SendLogMessage msg = new SendLogMessage(ev.getLog(), ev.getDeviceId());
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handlePlatformConnectionStatusChange(ConnectionStatusEvent ev) {
        ConnectionResponseMessage msg = new ConnectionResponseMessage(ev.getStatus(), ev.getDeviceId());
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAlfrescoPathStatusChange(AlfrescoPathStatusEvent ev) {
        AlfrescoPathMessage msg = new AlfrescoPathMessage(ev.isOk(), ev.getReason(), ev.getDeviceId(), ev.getPath());
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAlfrescoNewAspects(AlfrescoAspectsEvent ev) {
        AlfrescoAspectsMessage msg = new AlfrescoAspectsMessage(ev.getHost(), ev.getDeviceId(), ev.getAspects());
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAtlassianPathStatusChange(AtlassianPathStatusEvent ev) {
        AtlassianPathMessage msg = new AtlassianPathMessage(ev.isOk(), ev.getReason(), ev.getDeviceId(), ev.getPath());
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAtlassianNewSpaces(AtlassianSpacesEvent ev) {
        CloudItemsMessage msg = CloudItemsFactory.toMessage((String)ev.getDeviceId(), (Collection)ev.getSpaces(), (CloudItemType)CloudItemType.CONFLUENCE_SPACE);
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAtlassianNewProjects(JiraProjectsEvent ev) {
        CloudItemsMessage msg = CloudItemsFactory.toMessage((String)ev.getDeviceId(), (Collection)ev.getProjects(), (CloudItemType)CloudItemType.JIRA_PROJECT);
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAtlassianNewSecurityLevels(JiraSecuritySchemesEvent ev) {
        CloudItemsMessage msg = CloudItemsFactory.toMessage((String)ev.getDeviceId(), (Collection)ev.getSchemes(), (CloudItemType)CloudItemType.JIRA_SECURITY_LEVEL);
        this.sendMessageNoReply((MessageBase)msg);
    }

    @Subscribe
    public void handleAtlassianNewRepos(BitBucketReposEvent ev) {
        CloudItemsMessage msg = CloudItemsFactory.toMessage((String)ev.getDeviceId(), (Collection)ev.getRepos(), (CloudItemType)CloudItemType.BITBUCKET_REPO);
        this.sendMessageNoReply((MessageBase)msg);
    }

    public boolean sendResult(BaseResult res) {
        ByteBuffer bytes = res.toByteBuffer();
        RespondToJobMessage msg = new RespondToJobMessage(res.getDeviceId());
        msg.setManagerUUID(this.settings.getUUID());
        this.sendLargeMessageNoReply(bytes, (MessageBase)msg);
        return true;
    }

    public void updateJobState(String instanceId, String deviceId, JobState state, Progress progress, String reason, ActionResult actionResult) {
        UpdateJobStateMessage msg = new UpdateJobStateMessage(instanceId, state, deviceId, progress, reason, actionResult);
        msg.setManagerUUID(this.settings.getUUID());
        this.sendMessageNoReply((MessageBase)msg);
    }

    public void updateJobProgress(String taskInstanceId, String deviceId, Progress progress) {
        UpdateJobProgressMessage msg = new UpdateJobProgressMessage(taskInstanceId, deviceId, progress);
        msg.setManagerUUID(this.settings.getUUID());
        this.sendMessageNoReply((MessageBase)msg);
    }

    public void join() {
        SecondaryConfig config = new SecondaryConfig(this.settings.getUUID(), this.settings.getManagerName(), this.licenseManager.getAllocatedLicense());
        ArrayList<DeviceRegistration> deepcopy = new ArrayList<DeviceRegistration>();
        for (DeviceRegistration r : this.endpointService.getAllDevices(false)) {
            deepcopy.add(new DeviceRegistration(r));
        }
        JoinServerServerMessage msg = new JoinServerServerMessage(config, deepcopy);
        this.sendMessageNoReply((BaseServerServerMessage)msg);
    }

    public void bye(boolean forever) {
        ByeServerServerMessage msg = new ByeServerServerMessage(this.settings.getUUID(), forever);
        this.sendMessageNoReply((BaseServerServerMessage)msg);
    }

    private boolean sendLargeMessageNoReply(ByteBuffer bytes, MessageBase base) {
        if (this.connection == null) {
            return false;
        }
        try {
            BytesMessage bm = this.session.createBytesMessage();
            bm.setStringProperty("TYPE", MessageSerialiser.toJson((MessageBase)base));
            bm.writeBytes(bytes.array());
            this.largeProducer.send((Message)bm);
            return true;
        }
        catch (JMSException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private boolean sendMessageNoReply(BaseServerServerMessage base) {
        if (this.connection == null) {
            return false;
        }
        try {
            MapMessage mapMessage = this.session.createMapMessage();
            ServerServerMessageJMSFac.toJMSMessage((BaseServerServerMessage)base, (MapMessage)mapMessage);
            this.producer.send((Message)mapMessage);
            return true;
        }
        catch (JMSException ex) {
            LOG.log(Level.SEVERE, "SendMessageNoReply", ex);
            return false;
        }
    }

    private boolean sendMessageNoReply(MessageBase base) {
        if (this.connection == null) {
            return false;
        }
        try {
            TextMessage message = this.session.createTextMessage();
            message.setText(MessageSerialiser.toJson((MessageBase)base));
            this.producer.send((Message)message);
            return true;
        }
        catch (JMSException ex) {
            LOG.log(Level.SEVERE, "SendMessageNoReply", ex);
            return false;
        }
    }

    public void onMessage(Message message) {
        try {
            switch (message.getStringProperty("mtkey")) {
                case "mtsn": {
                    if (message instanceof MapMessage) {
                        MapMessage msg = (MapMessage)message;
                        String deviceId = msg.getString("deviceId");
                        Optional opt = ServerNotificationJMSFac.fromJMSMessage((String)ServerNotificationJMSFac.getJsonFromMessage((Message)message));
                        if (opt.isPresent()) {
                            this.routeServerNotificationMessage((ServerNotificationBase)opt.get(), deviceId);
                            break;
                        }
                        LOG.warning("failed to deserialise server notification");
                    }
                    break;
                }
                case "mtss": {
                    if (message instanceof MapMessage) {
                        MapMessage msg = (MapMessage)message;
                        Optional base = ServerServerMessageJMSFac.fromJMSMessage((MapMessage)msg);
                        if (base.isPresent()) {
                            this.processServerServerMessage((BaseServerServerMessage)base.get());
                            break;
                        }
                        LOG.warning("failed to deserialise server server message in Secondary");
                    }
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unknown message type sent from server {0}", message);
                }
            }
        }
        catch (JMSException e) {
            LOG.log(Level.SEVERE, "onMessage", e);
        }
    }

    private void routeServerNotificationMessage(ServerNotificationBase notify, String deviceId) {
        LOG.log(Level.INFO, "Receive server notification {0}", notify);
        block1 : switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$messages$servernotification$NotificationType[notify.getType().ordinal()]) {
            case 1: {
                JobsAvailableServerMessage msg = (JobsAvailableServerMessage)notify;
                this.endpointService.informJobAvailable(deviceId, msg.getJobs(), msg.getUidetails());
                break;
            }
            case 2: {
                CancelJobServerMessage msg = (CancelJobServerMessage)notify;
                this.taskManger.cancelJob(msg.getInstanceId(), deviceId);
                break;
            }
            case 3: {
                PauseJobServerMessage msg = (PauseJobServerMessage)notify;
                this.taskManger.pauseJob(msg.getInstanceId(), deviceId, false);
                break;
            }
            case 4: {
                EmailChangeServerMessage msg = (EmailChangeServerMessage)notify;
                this.endpointService.setEmailOnDevice(deviceId, msg.getEmail());
                break;
            }
            case 5: {
                AlertServerMessage msg = (AlertServerMessage)notify;
                this.alertingController.alertEndpoint(deviceId, msg);
                break;
            }
            case 6: {
                ServerUIUrlServerMessage msg = (ServerUIUrlServerMessage)notify;
                this.endpointService.tellDeviceWhereUIIs(msg.getDeviceId(), msg.getDetails());
                break;
            }
            case 7: {
                SetFollowNetworkSharesServerMessage msg = (SetFollowNetworkSharesServerMessage)notify;
                this.endpointService.setFollowNetworkShares(msg.getUser(), deviceId, msg.isFollow());
                break;
            }
            case 8: {
                this.endpointService.getLog(deviceId);
                break;
            }
            case 9: {
                CheckPathServerMessage msg = (CheckPathServerMessage)notify;
                this.endpointService.checkAlfrescoPath(msg.getPath());
                break;
            }
            case 10: {
                CheckAtlassianPathServerMessage msg = (CheckAtlassianPathServerMessage)notify;
                this.endpointService.checkAtlassianPath(msg.getPath());
                break;
            }
            case 11: {
                this.endpointService.getAspects();
                break;
            }
            case 12: {
                GetCloudItemsServerMessage msg = (GetCloudItemsServerMessage)notify;
                switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$clouditems$CloudItemType[msg.getItemType().ordinal()]) {
                    case 1: {
                        this.endpointService.getBitbucketRepos();
                        break block1;
                    }
                    case 2: {
                        this.endpointService.getAtlassianSpaces();
                        break block1;
                    }
                    case 3: {
                        this.endpointService.getJiraProjects();
                        break block1;
                    }
                    case 4: {
                        this.endpointService.getJiraSecuritySchemes();
                        break block1;
                    }
                }
                LOG.log(Level.WARNING, "unknown cloud item type {0}", msg.getItemType());
                break;
            }
            case 13: {
                DeviceType type = ((GetCloudUsersServerMessage)notify).getDeviceType();
                this.endpointService.getCloudUsers(type);
                break;
            }
            case 14: {
                SetCloudCredentialsServerMessage msg = (SetCloudCredentialsServerMessage)notify;
                CloudCredentials creds = msg.getCredentials();
                this.endpointService.testCloudCredentials(deviceId, creds);
                break;
            }
            case 15: {
                SetCloudCredentialsServerMessage msg = (SetCloudCredentialsServerMessage)notify;
                CloudCredentials creds = msg.getCredentials();
                try {
                    this.endpointService.setCloudCredentialsAndDeviceType("primary", deviceId, creds.toJSON(), creds.getType());
                }
                catch (JsonProcessingException ex) {
                    Logger.getLogger(SlaveEnd.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case 16: {
                OpenFileServerMessage msg = (OpenFileServerMessage)notify;
                this.searchResultsManager.openFile(msg.getFilepath(), msg.getLink(), deviceId, true);
                break;
            }
        }
    }

    private void processServerServerMessage(BaseServerServerMessage base) {
        LOG.log(Level.INFO, "Receive server server message {0}", base);
        switch (1.$SwitchMap$com$geolang$ascema$managerservice$messaging$serverserver$ServerServerMessageType[base.getType().ordinal()]) {
            case 1: {
                SessionChangeServerServerMessage msg = (SessionChangeServerServerMessage)base;
                switch (1.$SwitchMap$com$geolang$ascema$managerevents$SessionChangeEvent$Reason[msg.getReason().ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.endpointService.allowAccess(msg.getUser(), msg.getDeviceReg().getDeviceId());
                        break;
                    }
                    case 3: {
                        this.endpointService.denyAccess(msg.getUser(), msg.getDeviceReg().getDeviceId());
                        break;
                    }
                    case 4: {
                        this.endpointService.deleteDevice(msg.getUser(), msg.getDeviceReg().getDeviceId());
                        break;
                    }
                    case 5: {
                        this.endpointService.updateDevice(msg.getDeviceReg());
                    }
                }
                break;
            }
            case 2: {
                UseMasterLicenseServerServerMessage msg2 = (UseMasterLicenseServerServerMessage)base;
                this.licenseManager.setAllocations(msg2.getAllocations());
                break;
            }
            case 3: {
                NameTakenServerServerMessage msg = (NameTakenServerServerMessage)base;
                Notification n = new Notification("Secondary Configuration Error", "Name already taken " + msg.getName() + "- failed to connect ", NotificationType.ERROR);
                MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)n));
                LOG.log(Level.WARNING, "Name already taken for secondary - {0} stopping secondary", msg.getName());
                this.stop(false);
                break;
            }
            case 4: {
                UseUIServerServerMessage msg = (UseUIServerServerMessage)base;
                this.endpointService.setPrimaryUIDetails(msg.isUse(), msg.getDetails());
                break;
            }
            case 5: {
                LicenceLimitReachedServerServerMesage msg = (LicenceLimitReachedServerServerMesage)base;
                Notification n = new Notification("Licence limit reached", "Licence limit reached for secondary managers. Licence on your primary server allows a maximum of " + msg.getMaxSecondaryAgents() + " secondary managers", NotificationType.ERROR);
                MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)n));
                LOG.log(Level.WARNING, "License Limit. Cannot join primary as max secondary allowed in licence is  {0} stopping secondary", msg.getMaxSecondaryAgents());
                this.stop(false);
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Unhandled server server message in slave {0}", base);
            }
        }
    }

    public void ping() {
        PingServerServerMessage ping = new PingServerServerMessage(this.settings.getUUID(), this.settings.getManagerName());
        this.sendMessageNoReply((BaseServerServerMessage)ping);
    }
}

