/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging.serverserver;

import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.messages.AlfrescoAspectsMessage;
import com.geolang.ascema.endpointcommon.messages.AlfrescoPathMessage;
import com.geolang.ascema.endpointcommon.messages.AtlassianPathMessage;
import com.geolang.ascema.endpointcommon.messages.CloudItemsMessage;
import com.geolang.ascema.endpointcommon.messages.CloudUsersAndGroupsMessage;
import com.geolang.ascema.endpointcommon.messages.ConnectionResponseMessage;
import com.geolang.ascema.endpointcommon.messages.DatabaseTestQueryResponseMessage;
import com.geolang.ascema.endpointcommon.messages.DeviceCapabilitesMessage;
import com.geolang.ascema.endpointcommon.messages.MessageBase;
import com.geolang.ascema.endpointcommon.messages.MessageSerialiser;
import com.geolang.ascema.endpointcommon.messages.MultipleConnectionResponseMessage;
import com.geolang.ascema.endpointcommon.messages.SendLogMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateEmailMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateJobProgressMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateJobStateMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.JobsAvailableServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.LicenseAllocation;
import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerdomain.domain.SecondaryConfig;
import com.geolang.ascema.managerdomain.web.WebSecondaryConfig;
import com.geolang.ascema.managerevents.AlfrescoAspectsEvent;
import com.geolang.ascema.managerevents.AlfrescoPathStatusEvent;
import com.geolang.ascema.managerevents.AtlassianPathStatusEvent;
import com.geolang.ascema.managerevents.CloudUsersAndGroupsEvent;
import com.geolang.ascema.managerevents.ConnectionStatusEvent;
import com.geolang.ascema.managerevents.ConnectionStatusMultipleEvent;
import com.geolang.ascema.managerevents.DBTestResultsEvent;
import com.geolang.ascema.managerevents.DeviceLogAvailableEvent;
import com.geolang.ascema.managerevents.EmailChangeEvent;
import com.geolang.ascema.managerevents.NotificationEvent;
import com.geolang.ascema.managerevents.ProgressEvent;
import com.geolang.ascema.managerevents.ServerNameChangeEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerevents.UpdateDeviceCapabilitiesEvent;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerpersistence.ISecondaryConfigRepository;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.results.ResultsReciever;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateUpdater;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.messaging.JmsServerBase;
import com.geolang.ascema.managerservice.messaging.LocalJMSServer;
import com.geolang.ascema.managerservice.messaging.serverserver.ActiveSlave;
import com.geolang.ascema.managerservice.messaging.serverserver.ActiveSlaveCollection;
import com.geolang.ascema.managerservice.messaging.serverserver.BaseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.ByeServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.CloudItemsBusHelper;
import com.geolang.ascema.managerservice.messaging.serverserver.JoinServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.LicenceLimitReachedServerServerMesage;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import com.geolang.ascema.managerservice.messaging.serverserver.NameTakenServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.PingServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.ServerServerMessageJMSFac;
import com.geolang.ascema.managerservice.messaging.serverserver.SessionChangeServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.UseMasterLicenseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.UseUIServerServerMessage;
import jakarta.annotation.PostConstruct;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterEnd
extends JmsServerBase {
    @Autowired
    @Lazy
    private ResultsReciever resultsReceiver;
    @Autowired
    @Lazy
    private TaskManager taskManager;
    @Autowired
    @Lazy
    JobStateUpdater jobStateUpdater;
    @Autowired
    @Lazy
    private EndpointStore endpointStore;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private ISecondaryConfigRepository slaveRepo;
    @Autowired
    AuditLogService auditLog;
    private MessageConsumer consumer;
    private MessageConsumer largeConsumer;
    private static final Logger LOG = Logger.getLogger(MasterEnd.class.getName());
    private final SettingsFile settings = SettingsFile.getInstance();
    private ThreadPoolExecutor service;
    private ActiveSlaveCollection activeSlaves;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() {
        this.activeSlaves = new ActiveSlaveCollection(this.endpointStore);
    }

    public void start() {
        try {
            this.service = new ThreadPoolExecutor(4, 6, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("masterEnd-"));
            super.start("ascemamaster", this.settings.getMasterSlavePort(), true);
        }
        catch (Exception ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        LOG.log(Level.INFO, "Draining messages {0}", this.service.getQueue().size());
        this.service.shutdown();
        try {
            this.service.awaitTermination(20L, TimeUnit.SECONDS);
            LOG.info("Drained OK");
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.stop();
    }

    public void setupConsumers() {
        try {
            this.consumer = this.getServerInSession().createConsumer((Destination)this.adminQueue);
            this.consumer.setMessageListener((MessageListener)this);
            this.largeConsumer = this.getServerInSession().createConsumer((Destination)this.largeQueue);
            this.largeConsumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            LOG.warning(e.getLocalizedMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof BytesMessage) {
                this.service.submit(() -> {
                    try {
                        this.processByteMessage((BytesMessage)message);
                    }
                    catch (JMSException ex) {
                        Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
            } else if (message instanceof MapMessage) {
                MapMessage mm = (MapMessage)message;
                String messageType = mm.getStringProperty("mtkey");
                if (messageType.equals("mtss")) {
                    Optional baseOpt = ServerServerMessageJMSFac.fromJMSMessage((MapMessage)mm);
                    if (baseOpt.isPresent()) {
                        this.processServerServerMessage((BaseServerServerMessage)baseOpt.get());
                    } else {
                        LOG.warning("Failed to deserialise server server message");
                    }
                }
            } else if (message instanceof TextMessage) {
                Optional baseOpt = MessageSerialiser.fromJson((String)((TextMessage)message).getText());
                if (!baseOpt.isPresent()) {
                    LOG.log(Level.WARNING, "Failed to deserialise message {0}", ((TextMessage)message).getText());
                    return;
                }
                MessageBase base = (MessageBase)baseOpt.get();
                this.service.submit(() -> {
                    try {
                        this.processMessage(base);
                    }
                    catch (JMSException ex) {
                        Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
            }
        }
        catch (JMSException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public WebSecondaryConfig getAttachedSlave(String slavename) {
        SecondaryConfig mgr = this.slaveRepo.findByName(slavename);
        if (mgr != null) {
            WebSecondaryConfig wsm = new WebSecondaryConfig(mgr, this.licenseManager.getExpireDate());
            Optional as = this.activeSlaves.getByName(mgr.getName());
            wsm.setConnected(as.isPresent());
            return wsm;
        }
        return null;
    }

    private void deleteSlaveByUUID(String uuid) {
        Optional mgr = this.slaveRepo.findById((Object)uuid);
        if (mgr.isPresent()) {
            this.deleteSlave((SecondaryConfig)mgr.get());
        } else {
            LOG.log(Level.INFO, "Failed to find slave to delete by uuid {0}", uuid);
        }
    }

    private boolean deleteSlave(SecondaryConfig conf) {
        this.slaveRepo.delete((Object)conf);
        this.activeSlaves.slaveLeave(conf.getUuid());
        LOG.log(Level.INFO, "Delete slave {0}", conf.getName());
        this.auditLog.removeSecondary(conf);
        return true;
    }

    public boolean deleteSlaveByName(String slavename) {
        SecondaryConfig mgr = this.slaveRepo.findByName(slavename);
        if (mgr != null) {
            return this.deleteSlave(mgr);
        }
        LOG.log(Level.INFO, "Failed to find slave to delete {0}", slavename);
        return false;
    }

    public List<WebSecondaryConfig> getAttachedSlaves() {
        ArrayList<WebSecondaryConfig> ret = new ArrayList<WebSecondaryConfig>();
        if (this.isRunning()) {
            Iterable all = this.slaveRepo.findAll();
            for (SecondaryConfig sm : all) {
                if (sm.getUuid().equals(this.settings.getUUID())) continue;
                WebSecondaryConfig wsm = new WebSecondaryConfig(sm, this.licenseManager.getExpireDate());
                Optional as = this.activeSlaves.getByUUID(sm.getUuid());
                wsm.setConnected(as.isPresent());
                ret.add(wsm);
            }
        }
        return ret;
    }

    public List<DeviceRegistration> getDevicesForSlave(String slaveName) {
        return this.activeSlaves.getAllDevicesForName(slaveName);
    }

    public boolean routeMessage(String deviceId, ServerNotificationBase base) {
        Optional slaveUUID = this.activeSlaves.getSlaveUUIDforDevice(deviceId);
        if (slaveUUID.isPresent()) {
            this.sendMessageToSlave((String)slaveUUID.get(), deviceId, base);
            return true;
        }
        return false;
    }

    public boolean routeMessage(String deviceId, BaseServerServerMessage base) {
        Optional devReg = this.endpointStore.getDeviceRegFromId(deviceId, true, true);
        if (devReg.isPresent()) {
            this.sendServerServerMessageToSlave(((DeviceRegistration)devReg.get()).getManagerUUID(), base, false);
            return true;
        }
        return false;
    }

    public Optional<DeviceRegistration> getDevice(String deviceId) {
        for (String uuid : this.activeSlaves.getAllSlaveUUIDs()) {
            List list = this.activeSlaves.getDevicesByUUID(uuid);
            if (list == null) continue;
            for (DeviceRegistration dr : list) {
                if (!dr.getDeviceId().equals(deviceId)) continue;
                return Optional.of(dr);
            }
        }
        return Optional.empty();
    }

    public void checkSlaveConnections() {
        this.activeSlaves.removeExpiredSlaveSessions();
    }

    public void tellSlavesToUseMasterUI() {
        this.service.submit(() -> {
            UseUIServerServerMessage msg = new UseUIServerServerMessage(this.settings.getPrimaryIsMainUI(), ProxySettings.getUIDetails((String)""));
            this.activeSlaves.getAllSlaveUUIDs().forEach(uuid -> this.sendServerServerMessageToSlave(uuid, (BaseServerServerMessage)msg, false));
        });
    }

    public void processByteMessage(BytesMessage bytesMessage) throws JMSException {
        String basestr = bytesMessage.getStringProperty("TYPE");
        Optional baseOpt = MessageSerialiser.fromJson((String)basestr);
        if (!baseOpt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to deserialise basemessage in bytemessage {0}", basestr);
            return;
        }
        MessageBase base = (MessageBase)baseOpt.get();
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$messages$MessageType[base.getType().ordinal()]) {
            case 1: {
                byte[] bytes = new byte[(int)bytesMessage.getBodyLength()];
                bytesMessage.readBytes(bytes);
                BaseResult result = BaseResult.fromByteArray((byte[])bytes);
                this.resultsReceiver.addResult(result);
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Unknown byte message type {0}", base.getType());
            }
        }
    }

    private void processServerServerMessage(BaseServerServerMessage base) {
        block0 : switch (1.$SwitchMap$com$geolang$ascema$managerservice$messaging$serverserver$ServerServerMessageType[base.getType().ordinal()]) {
            case 1: {
                SessionChangeServerServerMessage msg2 = (SessionChangeServerServerMessage)base;
                switch (1.$SwitchMap$com$geolang$ascema$managerevents$SessionChangeEvent$Reason[msg2.getReason().ordinal()]) {
                    case 1: {
                        this.addDevice(msg2);
                        break block0;
                    }
                    case 2: {
                        this.removeDevice(msg2);
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.updateDevice(msg2);
                        break block0;
                    }
                }
                LOG.log(Level.WARNING, "Unknown server server message {0}", base);
                break;
            }
            case 2: {
                JoinServerServerMessage slMsg = (JoinServerServerMessage)base;
                this.processJoin(slMsg);
                break;
            }
            case 3: {
                ByeServerServerMessage msg = (ByeServerServerMessage)base;
                if (msg.isForever()) {
                    this.deleteSlaveByUUID(base.getUuid());
                } else {
                    this.activeSlaves.slaveLeave(base.getUuid());
                }
                LOG.log(Level.INFO, "Secondary leaves: {0} forever={1}", new Object[]{base.getUuid(), msg.isForever()});
                break;
            }
            case 4: {
                PingServerServerMessage ping = (PingServerServerMessage)base;
                this.processPing(ping);
                break;
            }
        }
    }

    private void processPing(PingServerServerMessage ping) {
        ActiveSlave as;
        if (!this.checkForExistingName(ping.getName(), ping.getUuid())) {
            return;
        }
        this.activeSlaves.seenSlave(ping.getUuid());
        Optional slaveOpt = this.activeSlaves.getByUUID(ping.getUuid());
        if (slaveOpt.isPresent() && !(as = (ActiveSlave)slaveOpt.get()).getName().equals(ping.getName())) {
            MessageBus.getBus().post((Object)new ServerNameChangeEvent(ping.getName(), as.getName()));
            as.setName(ping.getName());
        }
    }

    private boolean checkForExistingName(String name, String uuid) {
        SecondaryConfig byName = this.slaveRepo.findByName(name);
        if (byName != null && !byName.getUuid().equals(uuid)) {
            LOG.log(Level.WARNING, "Secondary tries to attach with already taken name {0}", name);
            Notification n = new Notification("Secondary Configuration Error", "A secondary server tried to attach with the already taken name " + name, NotificationType.ERROR);
            MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)n));
            this.sendNameTakenMessageToSlave(uuid, name);
            return false;
        }
        return true;
    }

    private void checkForRename(JoinServerServerMessage msg) {
        SecondaryConfig ours;
        SecondaryConfig fromSlave = msg.getConfig();
        Optional oursOpt = this.slaveRepo.findById((Object)fromSlave.getUuid());
        if (oursOpt.isPresent() && !(ours = (SecondaryConfig)oursOpt.get()).getName().equals(fromSlave.getName())) {
            String old = ours.getName();
            ours.setName(fromSlave.getName());
            this.slaveRepo.save((Object)ours);
            Optional as = this.activeSlaves.getByName(old);
            if (as.isPresent()) {
                ((ActiveSlave)as.get()).setName(fromSlave.getName());
            }
            MessageBus.getBus().post((Object)new ServerNameChangeEvent(fromSlave.getName(), old));
        }
    }

    private boolean canAddSlave(String uuid) {
        int maxSecondaryAgents = this.licenseManager.getMaxSecondaryManagers();
        int allocatedSecondaryManagers = this.activeSlaves.getSize();
        if (allocatedSecondaryManagers >= maxSecondaryAgents) {
            LOG.log(Level.WARNING, "Cannot add more secondary manager. Maximum secodary managers allowed in licence is {0}", maxSecondaryAgents);
            Notification n = new Notification("Licence limit reached", "Licence limit reached for secondary managers. You have more number of secondary managers trying to connect but your licence allows a maximum of " + maxSecondaryAgents + " secondary managers. You can view details of your licence under Administration Menu. Contact sales to increase your licence quota.", NotificationType.ERROR);
            MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)n));
            this.sendLicenceLimitReachedMessageToSlave(uuid, maxSecondaryAgents);
            return false;
        }
        return true;
    }

    private void processJoin(JoinServerServerMessage msg) {
        this.checkForRename(msg);
        if (!this.canAddSlave(msg.getUuid())) {
            return;
        }
        if (!this.checkForExistingName(msg.getConfig().getName(), msg.getUuid())) {
            return;
        }
        SecondaryConfig fromSlave = msg.getConfig();
        this.activeSlaves.slaveJoin(fromSlave.getUuid(), msg.getConfig().getName());
        Optional oursOpt = this.slaveRepo.findById((Object)fromSlave.getUuid());
        if (!oursOpt.isPresent()) {
            SecondaryConfig ours = (SecondaryConfig)this.slaveRepo.save((Object)new SecondaryConfig(fromSlave.getUuid(), fromSlave.getName(), new LicenseAllocation(this.licenseManager.getExpireDate())));
            LOG.log(Level.INFO, "Send License allocations to {0}", fromSlave.getName());
            String id = fromSlave.getUuid();
            this.allocateLicense(id, ours.getAllocation());
            this.auditLog.addSecondary(ours);
        }
        this.activeSlaves.putDevicesByUUID(msg.getUuid(), new HashSet(msg.getDevs()));
        LOG.log(Level.INFO, "Secondary joins: {0}", fromSlave.getName());
    }

    private void addDevice(SessionChangeServerServerMessage msg) {
        ArrayList jobs;
        this.activeSlaves.updateDevice(msg.getSlaveName(), msg.getDeviceReg(), SessionChangeEvent.Reason.ADDED);
        String deviceId = msg.getDeviceReg().getDeviceId();
        LOG.log(Level.INFO, "device attached to slave {0} {1}", new Object[]{msg.getSlaveName(), msg.getDeviceReg().getHostname()});
        MessageBus.getBus().post((Object)new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.ADDED));
        if (msg.getDeviceReg().isValidated() && (jobs = this.taskManager.getJobsForDevice(deviceId)) != null && !jobs.isEmpty()) {
            LOG.log(Level.INFO, "send {0} jobs to remote device {1}", new Object[]{jobs.size(), msg.getDeviceReg().getDeviceDescription()});
            this.service.submit(() -> {
                ServerUIDetails details = ProxySettings.getUIDetails((String)deviceId);
                this.sendMessageToSlave(msg.getUuid(), deviceId, (ServerNotificationBase)new JobsAvailableServerMessage(jobs, details));
            });
        }
    }

    private void removeDevice(SessionChangeServerServerMessage msg) {
        LOG.log(Level.INFO, "device removed from slave {0} {1}", new Object[]{msg.getSlaveName(), msg.getDeviceReg().getHostname()});
        this.activeSlaves.updateDevice(msg.getSlaveName(), msg.getDeviceReg(), msg.getReason());
        MessageBus.getBus().post((Object)new SessionChangeEvent(msg.getDeviceReg().getDeviceId(), SessionChangeEvent.Reason.REMOVED));
    }

    private void updateDevice(SessionChangeServerServerMessage msg) {
        this.activeSlaves.updateDevice(msg.getSlaveName(), msg.getDeviceReg(), msg.getReason());
        MessageBus.getBus().post((Object)new SessionChangeEvent(msg.getDeviceReg().getDeviceId(), SessionChangeEvent.Reason.UPDATED));
    }

    private void processMessage(MessageBase base) throws JMSException {
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$messages$MessageType[base.getType().ordinal()]) {
            case 2: {
                UpdateEmailMessage msg3 = (UpdateEmailMessage)base;
                MessageBus.getBus().post((Object)new EmailChangeEvent(msg3.getDeviceId(), msg3.getEmail()));
                break;
            }
            case 3: {
                UpdateJobStateMessage msg4 = (UpdateJobStateMessage)base;
                this.jobStateUpdater.updateJobState(msg4.getTaskInstanceId(), msg4.getDeviceId(), msg4.getState(), msg4.getProgress(), msg4.getReason(), msg4.getActionResult());
                break;
            }
            case 4: {
                UpdateJobProgressMessage progressMsg = (UpdateJobProgressMessage)base;
                MessageBus.getBus().post((Object)new ProgressEvent(progressMsg.getDeviceId(), progressMsg.getTaskInstanceId(), progressMsg.getProgress()));
                break;
            }
            case 5: {
                SendLogMessage msg5 = (SendLogMessage)base;
                MessageBus.getBus().post((Object)new DeviceLogAvailableEvent(msg5.getDeviceId(), msg5.getLog()));
                break;
            }
            case 6: {
                DeviceCapabilitesMessage devCapMsg = (DeviceCapabilitesMessage)base;
                MessageBus.getBus().post((Object)new UpdateDeviceCapabilitiesEvent(devCapMsg.getDeviceId(), devCapMsg.getSyncFolders()));
                break;
            }
            case 7: {
                ConnectionResponseMessage msg6 = (ConnectionResponseMessage)base;
                MessageBus.getBus().post((Object)new ConnectionStatusEvent(msg6.getDeviceId(), msg6.getStatus()));
                break;
            }
            case 8: {
                DatabaseTestQueryResponseMessage msg = (DatabaseTestQueryResponseMessage)base;
                MessageBus.getBus().post((Object)new DBTestResultsEvent(msg.getDeviceId(), msg.getResults()));
                break;
            }
            case 9: {
                MultipleConnectionResponseMessage msg = (MultipleConnectionResponseMessage)base;
                MessageBus.getBus().post((Object)new ConnectionStatusMultipleEvent(msg.getDeviceId(), msg.getStatuses()));
                break;
            }
            case 10: {
                AlfrescoPathMessage msg7 = (AlfrescoPathMessage)base;
                MessageBus.getBus().post((Object)new AlfrescoPathStatusEvent(msg7.getDeviceId(), msg7.isOk(), msg7.getReason(), msg7.getPath()));
                break;
            }
            case 11: {
                AlfrescoAspectsMessage msg8 = (AlfrescoAspectsMessage)base;
                MessageBus.getBus().post((Object)new AlfrescoAspectsEvent(msg8.getHost(), msg8.getDeviceId(), msg8.getAspects()));
                break;
            }
            case 12: {
                CloudUsersAndGroupsMessage msg9 = (CloudUsersAndGroupsMessage)base;
                MessageBus.getBus().post((Object)new CloudUsersAndGroupsEvent(msg9.getHostName(), msg9.getDeviceId(), msg9.getUsers(), msg9.getGroups(), msg9.getDeviceType(), msg9.isFirstMessage(), msg9.isLastMessage()));
                break;
            }
            case 13: {
                AtlassianPathMessage msg10 = (AtlassianPathMessage)base;
                MessageBus.getBus().post((Object)new AtlassianPathStatusEvent(msg10.getDeviceId(), msg10.isOk(), msg10.getReason(), msg10.getPath()));
                break;
            }
            case 14: {
                CloudItemsBusHelper.dealWithPlatformObjects((CloudItemsMessage)((CloudItemsMessage)base));
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Unknown message type {0}", base.getType());
            }
        }
    }

    public void allocateLicense(String slaveUUID, LicenseAllocation allocations) {
        String uuid = SettingsFile.getInstance().getUUID();
        if (slaveUUID.equals(uuid)) {
            this.licenseManager.setAllocations(allocations);
            return;
        }
        this.service.submit(() -> {
            Optional smOpt = this.slaveRepo.findById((Object)slaveUUID);
            if (smOpt.isPresent()) {
                SecondaryConfig sm = (SecondaryConfig)smOpt.get();
                sm.setAllocation(allocations);
                this.slaveRepo.save((Object)sm);
            }
            UseMasterLicenseServerServerMessage msg = new UseMasterLicenseServerServerMessage(allocations);
            this.sendServerServerMessageToSlave(slaveUUID, (BaseServerServerMessage)msg, false);
        });
    }

    private void sendNameTakenMessageToSlave(String slaveUUID, String name) {
        this.service.submit(() -> {
            NameTakenServerServerMessage msg = new NameTakenServerServerMessage(name);
            this.sendServerServerMessageToSlave(slaveUUID, (BaseServerServerMessage)msg, true);
        });
    }

    private void sendLicenceLimitReachedMessageToSlave(String slaveUUID, int maxSecondaryAgents) {
        this.service.submit(() -> {
            LicenceLimitReachedServerServerMesage msg = new LicenceLimitReachedServerServerMesage(maxSecondaryAgents);
            this.sendServerServerMessageToSlave(slaveUUID, (BaseServerServerMessage)msg, true);
        });
    }

    private boolean sendServerServerMessageToSlave(String slaveUUID, BaseServerServerMessage base, boolean skipactivecheck) {
        try {
            Queue outQueue = this.getServerInSession().createQueue(slaveUUID);
            if (!skipactivecheck && !this.activeSlaves.getByUUID(slaveUUID).isPresent()) {
                LOG.log(Level.WARNING, "Secondary {0} not connected", slaveUUID);
                return false;
            }
            this.sendMessageFromAnyThread((Destination)outQueue, base);
            return true;
        }
        catch (JMSException ex) {
            Logger.getLogger(MasterEnd.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private boolean sendMessageToSlave(String slaveUUID, String deviceId, ServerNotificationBase base) {
        try {
            Queue outQueue = this.getServerInSession().createQueue(slaveUUID);
            if (!this.activeSlaves.getByUUID(slaveUUID).isPresent()) {
                LOG.log(Level.WARNING, "Secondary {0} not connected", slaveUUID);
                return false;
            }
            this.sendMessageFromAnyThreadMasterSlave((Destination)outQueue, deviceId, base);
            return true;
        }
        catch (JMSException ex) {
            Logger.getLogger(MasterEnd.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean isConnected(DeviceRegistration d) {
        return this.activeSlaves.isConnected(d);
    }
}

