/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging.serverserver;

import com.geolang.ascema.endpointcommon.domain.clouditems.AtlassianSpace;
import com.geolang.ascema.endpointcommon.domain.clouditems.BaseCloudItem;
import com.geolang.ascema.endpointcommon.domain.clouditems.BitbucketRepo;
import com.geolang.ascema.endpointcommon.domain.clouditems.CloudItemsFactory;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraIssueSecurityLevel;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraProject;
import com.geolang.ascema.endpointcommon.domain.clouditems.MIPLabel;
import com.geolang.ascema.endpointcommon.messages.CloudItemsMessage;
import com.geolang.ascema.indexingcommon.endpoint.google.GoogleDriveLabel;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.AtlassianSpacesEvent;
import com.geolang.ascema.managerevents.BitBucketReposEvent;
import com.geolang.ascema.managerevents.GoogleDriveLabelsEvent;
import com.geolang.ascema.managerevents.JiraProjectsEvent;
import com.geolang.ascema.managerevents.JiraSecuritySchemesEvent;
import com.geolang.ascema.managerevents.O365MipLabelsEvent;
import java.util.List;

public class CloudItemsBusHelper {
    public static void dealWithPlatformObjects(CloudItemsMessage msg) {
        List objects = CloudItemsFactory.fromMessage((CloudItemsMessage)msg);
        if (!objects.isEmpty()) {
            BaseCloudItem p = (BaseCloudItem)objects.get(0);
            if (p instanceof AtlassianSpace) {
                AtlassianSpace atlassianSpace = (AtlassianSpace)p;
                MessageBus.getBus().post((Object)new AtlassianSpacesEvent(atlassianSpace.getHostname(), msg.getDeviceId(), objects));
                return;
            }
            if (p instanceof JiraProject) {
                JiraProject jiraProject = (JiraProject)p;
                MessageBus.getBus().post((Object)new JiraProjectsEvent(jiraProject.getHostname(), msg.getDeviceId(), objects));
                return;
            }
            if (p instanceof JiraIssueSecurityLevel) {
                JiraIssueSecurityLevel jiraIssueSecurityLevel = (JiraIssueSecurityLevel)p;
                MessageBus.getBus().post((Object)new JiraSecuritySchemesEvent(jiraIssueSecurityLevel.getHostname(), msg.getDeviceId(), objects));
                return;
            }
            if (p instanceof BitbucketRepo) {
                BitbucketRepo bitbucketRepo = (BitbucketRepo)p;
                MessageBus.getBus().post((Object)new BitBucketReposEvent(bitbucketRepo.getHostname(), msg.getDeviceId(), objects));
                return;
            }
            if (p instanceof GoogleDriveLabel) {
                GoogleDriveLabel gLabels = (GoogleDriveLabel)p;
                MessageBus.getBus().post((Object)new GoogleDriveLabelsEvent(gLabels.getHostName(), msg.getDeviceId(), objects));
                return;
            }
            if (p instanceof MIPLabel) {
                MIPLabel mipLabels = (MIPLabel)p;
                MessageBus.getBus().post((Object)new O365MipLabelsEvent(mipLabels.getHostname(), msg.getDeviceId(), objects));
            }
        }
    }
}

