/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging.serverserver;

import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerservice.messaging.serverserver.ActiveSlave;
import com.geolang.ascema.managerservice.messaging.serverserver.ActiveSlaveCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ActiveSlaveCollection {
    private final EndpointStore endpointStore;
    private final ConcurrentHashMap<String, ActiveSlave> activeSlaves;

    public ActiveSlaveCollection(EndpointStore store) {
        this.endpointStore = store;
        this.activeSlaves = new ConcurrentHashMap();
    }

    Optional<ActiveSlave> getByName(String name) {
        for (ActiveSlave as : this.activeSlaves.values()) {
            if (!as.getName().equals(name)) continue;
            return Optional.of(as);
        }
        return Optional.empty();
    }

    Optional<ActiveSlave> getByUUID(String uuuid) {
        if (this.activeSlaves.containsKey(uuuid)) {
            return Optional.of((ActiveSlave)this.activeSlaves.get(uuuid));
        }
        return Optional.empty();
    }

    List<DeviceRegistration> getAllDevicesForName(String slaveName) {
        return this.endpointStore.getAllWithManagerName(slaveName);
    }

    List<DeviceRegistration> getDevicesByUUID(String uuid) {
        ActiveSlave as = (ActiveSlave)this.activeSlaves.get(uuid);
        if (as != null) {
            return this.getAllDevicesForName(as.getName());
        }
        return new ArrayList<DeviceRegistration>();
    }

    void putDevicesByUUID(String uuid, Set<DeviceRegistration> devices) {
        Optional as = this.getByUUID(uuid);
        if (as.isPresent()) {
            for (DeviceRegistration dr : devices) {
                this.endpointStore.save(dr);
                if (!dr.isConnected()) continue;
                ((ActiveSlave)as.get()).addDeviceId(dr.getDeviceId());
                MessageBus.getBus().post((Object)new SessionChangeEvent(dr.getDeviceId(), SessionChangeEvent.Reason.UPDATED));
            }
        }
    }

    void slaveJoin(String uuid, String slaveName) {
        this.activeSlaves.put(uuid, new ActiveSlave(uuid, slaveName));
    }

    void slaveLeave(String uuid) {
        this.activeSlaves.entrySet().removeIf(e -> ((ActiveSlave)e.getValue()).getUuid().equals(uuid));
    }

    Iterable<String> getAllSlaveNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ActiveSlave as : this.activeSlaves.values()) {
            ret.add(as.getName());
        }
        return ret;
    }

    Iterable<String> getAllSlaveUUIDs() {
        return new HashSet<String>(this.activeSlaves.keySet());
    }

    void removeExpiredSlaveSessions() {
        this.activeSlaves.entrySet().removeIf(e -> ((ActiveSlave)e.getValue()).isExpired());
    }

    void seenSlave(String uuid) {
        ActiveSlave as = (ActiveSlave)this.activeSlaves.get(uuid);
        if (as != null) {
            as.seen();
        }
    }

    boolean isConnected(DeviceRegistration d) {
        Optional as = this.getByName(d.getManagerName());
        if (as.isPresent()) {
            return ((ActiveSlave)as.get()).hasId(d.getDeviceId());
        }
        return false;
    }

    public Optional<String> getSlaveUUIDforDevice(String deviceId) {
        for (String uuid : this.activeSlaves.keySet()) {
            ActiveSlave as = (ActiveSlave)this.activeSlaves.get(uuid);
            if (!as.hasId(deviceId)) continue;
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    void updateDevice(String slaveName, DeviceRegistration deviceReg, SessionChangeEvent.Reason reason) {
        deviceReg.setManagerName(slaveName);
        this.endpointStore.save(deviceReg);
        Optional as = this.getByUUID(deviceReg.getManagerUUID());
        switch (1.$SwitchMap$com$geolang$ascema$managerevents$SessionChangeEvent$Reason[reason.ordinal()]) {
            case 1: 
            case 2: {
                if (!as.isPresent() || !deviceReg.isConnected()) break;
                ((ActiveSlave)as.get()).addDeviceId(deviceReg.getDeviceId());
                break;
            }
            case 3: {
                this.endpointStore.delete(deviceReg);
                if (!as.isPresent()) break;
                ((ActiveSlave)as.get()).removeDeviceId(deviceReg.getDeviceId());
                break;
            }
            case 4: 
            case 5: {
                if (!as.isPresent()) break;
                ((ActiveSlave)as.get()).removeDeviceId(deviceReg.getDeviceId());
            }
        }
    }

    int getSize() {
        return this.activeSlaves.size();
    }
}

