/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging.serverserver;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActiveSlave {
    private static final Logger LOG = Logger.getLogger(ActiveSlave.class.getName());
    private final String uuid;
    private String name;
    private LocalDateTime lastSeen;
    private static final int EXPIRE_AFTER_SECONDS = 120;
    private final Set<String> activeDeviceIds;

    public ActiveSlave(String uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.activeDeviceIds = new HashSet();
        this.lastSeen = LocalDateTime.now();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void seen() {
        this.lastSeen = LocalDateTime.now();
    }

    public void addDeviceId(String id) {
        this.activeDeviceIds.add(id);
    }

    public void removeDeviceId(String id) {
        this.activeDeviceIds.remove(id);
    }

    public boolean hasId(String id) {
        return this.activeDeviceIds.contains(id);
    }

    public boolean isExpired() {
        boolean ret = this.lastSeen.plus(120L, ChronoUnit.SECONDS).isBefore(LocalDateTime.now());
        if (ret) {
            LOG.log(Level.INFO, "secondary connection {0} is expired", this.name);
        }
        return ret;
    }
}

