/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging;

import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.domain.Progress;
import com.geolang.ascema.endpointcommon.messages.AgentDiagnosticDataMessage;
import com.geolang.ascema.endpointcommon.messages.AlfrescoAspectsMessage;
import com.geolang.ascema.endpointcommon.messages.AlfrescoPathMessage;
import com.geolang.ascema.endpointcommon.messages.AtlassianPathMessage;
import com.geolang.ascema.endpointcommon.messages.CloudItemsMessage;
import com.geolang.ascema.endpointcommon.messages.CloudUsersAndGroupsMessage;
import com.geolang.ascema.endpointcommon.messages.ConnectionResponseMessage;
import com.geolang.ascema.endpointcommon.messages.DatabaseTestQueryResponseMessage;
import com.geolang.ascema.endpointcommon.messages.DeviceCapabilitesMessage;
import com.geolang.ascema.endpointcommon.messages.MessageBase;
import com.geolang.ascema.endpointcommon.messages.MessageResponseSerialiser;
import com.geolang.ascema.endpointcommon.messages.MessageSerialiser;
import com.geolang.ascema.endpointcommon.messages.MessageType;
import com.geolang.ascema.endpointcommon.messages.MultipleConnectionResponseMessage;
import com.geolang.ascema.endpointcommon.messages.RegisterMessage;
import com.geolang.ascema.endpointcommon.messages.RequestClassificationModelMessage;
import com.geolang.ascema.endpointcommon.messages.SendLogMessage;
import com.geolang.ascema.endpointcommon.messages.ServerErrorAuditLogMessage;
import com.geolang.ascema.endpointcommon.messages.ServerReplyMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateEmailMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateJobProgressMessage;
import com.geolang.ascema.endpointcommon.messages.UpdateJobStateMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.domain.ManagerRole;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerevents.AlfrescoAspectsEvent;
import com.geolang.ascema.managerevents.AlfrescoPathStatusEvent;
import com.geolang.ascema.managerevents.AtlassianPathStatusEvent;
import com.geolang.ascema.managerevents.CloudUsersAndGroupsEvent;
import com.geolang.ascema.managerevents.ConnectionStatusEvent;
import com.geolang.ascema.managerevents.ConnectionStatusMultipleEvent;
import com.geolang.ascema.managerevents.DBTestResultsEvent;
import com.geolang.ascema.managerevents.DeviceLogAvailableEvent;
import com.geolang.ascema.managerevents.EmailChangeEvent;
import com.geolang.ascema.managerevents.NotificationEvent;
import com.geolang.ascema.managerevents.ProgressEvent;
import com.geolang.ascema.managerevents.RequestClassificationModelEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerevents.UpdateDeviceCapabilitiesEvent;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.ServerOutToDeviceListener;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.results.ResultsReciever;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateUpdater;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.messaging.ILargeMessageProcessor;
import com.geolang.ascema.managerservice.messaging.JmsServerBase;
import com.geolang.ascema.managerservice.messaging.LargeMessageHandler;
import com.geolang.ascema.managerservice.messaging.LocalJMSServer;
import com.geolang.ascema.managerservice.messaging.serverserver.CloudItemsBusHelper;
import com.geolang.ascema.managerservice.messaging.serverserver.ISlave;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStore;
import com.geolang.ascema.managerservice.servicediscovery.JMDNSServer;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;

@Service
public class LocalJMSServer
extends JmsServerBase
implements ILargeMessageProcessor {
    @Autowired
    private DeviceService serverCommon;
    @Autowired
    private ResultsReciever resultsReceiver;
    @Autowired
    @Lazy
    JobStateUpdater jobStateUpdater;
    @Autowired
    @Lazy
    private TaskManager taskManager;
    @Autowired
    private DeviceService endpointService;
    @Autowired
    private KeyPairStore kpStore;
    @Autowired
    private ProxySettings proxySettings;
    private ISlave slaveEnd;
    private MessageConsumer consumer;
    private MessageConsumer largeConsumer;
    private LargeMessageHandler largeHandler;
    private JMDNSServer dnsServer;
    private final SettingsFile settings = SettingsFile.getInstance();
    private static final Logger LOG = Logger.getLogger(LocalJMSServer.class.getName());
    private ThreadPoolExecutor service;
    private ThreadPoolExecutor postregisterworkExe;
    @Autowired
    AuditLogService auditLog;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.stop();
    }

    public void start() {
        try {
            LOG.info("start message bus");
            this.service = new ThreadPoolExecutor(6, 6, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("LocalJMSServer-"));
            this.postregisterworkExe = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("postregisterworkExe-"));
            this.largeHandler = new LargeMessageHandler((ILargeMessageProcessor)this, this.kpStore);
            super.setKpStore(this.kpStore);
            super.start("ascemalocal", this.settings.getMessageserverPort(), false);
            this.dnsServer = new JMDNSServer();
        }
        catch (Exception ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() {
        LOG.log(Level.INFO, "Draining messages {0}", this.service.getQueue().size());
        this.service.shutdown();
        this.largeHandler.stop();
        this.postregisterworkExe.shutdownNow();
        this.dnsServer.destroy();
        try {
            this.service.awaitTermination(20L, TimeUnit.SECONDS);
            LOG.info("Drained OK");
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.stop();
    }

    public void setupConsumers() {
        try {
            this.consumer = this.getServerInSession().createConsumer((Destination)this.adminQueue);
            this.consumer.setMessageListener((MessageListener)this);
            this.largeConsumer = this.getServerInSession().createConsumer((Destination)this.largeQueue);
            this.largeConsumer.setMessageListener((MessageListener)this.largeHandler);
        }
        catch (JMSException e) {
            LOG.warning(e.getLocalizedMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof BytesMessage) {
                LOG.severe("byte message on admin queue");
            } else if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                String type = message.getStringProperty("ascema-tmt");
                if (type != null && type.equals(MessageType.PRE_REGISTER.name())) {
                    String deviceId = message.getStringProperty("ascema-did");
                    this.service.submit(() -> {
                        try {
                            this.processPreRegisterMessage(deviceId, message.getJMSCorrelationID(), message.getJMSReplyTo());
                        }
                        catch (JMSException ex) {
                            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex.getMessage());
                        }
                    });
                    return;
                }
                Optional baseOpt = this.getMessageBase(textMessage);
                if (!baseOpt.isPresent()) {
                    LOG.log(Level.WARNING, "Failed to deserialise message from id {0}  {1}", new Object[]{message.getStringProperty("ascema-did"), message.getStringProperty("ascema-host")});
                    LOG.log(Level.WARNING, "Perhaps the agent is locked to another manager? Try setting LOCK_TO_MANAGER=false in agent.properties, once it connects you can remove the setting");
                    return;
                }
                MessageBase base = (MessageBase)baseOpt.get();
                if (base.getType().equals((Object)MessageType.PING)) {
                    this.serverCommon.markAsSeen(base.getDeviceId(), true);
                    this.sendPingReplyAsync(message.getJMSReplyTo(), message.getJMSCorrelationID(), MessageResponseSerialiser.toJson((ServerReplyMessage)new ServerReplyMessage(true)));
                } else {
                    this.serverCommon.markAsSeen(base.getDeviceId(), false);
                    this.service.submit(() -> {
                        try {
                            this.processMessage(base, message.getJMSCorrelationID(), message.getJMSReplyTo());
                        }
                        catch (JMSException ex) {
                            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, ex.getMessage());
                        }
                    });
                }
            }
        }
        catch (JMSException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }

    public void setSlaveEnd(ISlave slaveEnd) {
        this.slaveEnd = slaveEnd;
    }

    private Optional<MessageBase> getMessageBase(TextMessage msg) {
        String deviceId = "";
        try {
            deviceId = msg.getStringProperty("ascema-did");
            if (deviceId == null) {
                LOG.warning("No deviceId in message header?");
                return Optional.empty();
            }
            Optional kpOpt = this.kpStore.getKeyPairForDevice(deviceId);
            if (kpOpt.isPresent()) {
                return MessageSerialiser.fromJson((String)msg.getText(), (PrivateKey)((KeyPair)kpOpt.get()).getPrivate());
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "bad message {0} from {1}", new Object[]{ex.getMessage(), deviceId});
            Optional reg = this.endpointService.getDeviceFromId(deviceId, true);
            String devName = "Unknown (" + deviceId + ")";
            if (reg.isPresent()) {
                devName = ((DeviceRegistration)reg.get()).deviceDescriptionOrCloudName() + " (" + deviceId + ")";
            }
            String err = "Agent " + devName + " sent unrecognised message, perhaps it's the wrong version, or locked to another manager? See manager log for more details";
            MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)new Notification("Agent Message Failure", err, NotificationType.WARNING)));
        }
        LOG.log(Level.WARNING, "No key or wrong agent version {0}", new Object[]{deviceId});
        return Optional.empty();
    }

    public void processLargeMessage(String messageBase, byte[] bytes) {
        Optional baseOpt = MessageSerialiser.fromJson((String)messageBase);
        if (!baseOpt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to deserialise basemessage in bytemessage {0}", messageBase);
            return;
        }
        MessageBase base = (MessageBase)baseOpt.get();
        this.serverCommon.markAsSeen(base.getDeviceId(), true);
        switch (2.$SwitchMap$com$geolang$ascema$endpointcommon$messages$MessageType[base.getType().ordinal()]) {
            case 1: {
                boolean isSlave = this.settings.getManagerRole().equals((Object)ManagerRole.SECONDARY);
                BaseResult result = BaseResult.fromByteArray((byte[])bytes);
                String recipient = result.getManagerUUID();
                if (!isSlave || recipient == null || recipient.isEmpty() || recipient.equals(this.settings.getUUID())) {
                    this.resultsReceiver.addResult(result);
                    break;
                }
                this.slaveEnd.sendResult(result);
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Unknown byte message type {0}", base.getType());
            }
        }
    }

    private void processMessage(MessageBase base, String correlationId, Destination replyTo) throws JMSException {
        switch (2.$SwitchMap$com$geolang$ascema$endpointcommon$messages$MessageType[base.getType().ordinal()]) {
            case 2: {
                RegisterMessage rm = (RegisterMessage)base;
                String ret = this.register(rm);
                Optional fut = this.sendReplyAsync(replyTo, correlationId, MessageResponseSerialiser.toJson((ServerReplyMessage)new ServerReplyMessage(ret)));
                if (ret.isEmpty()) break;
                String deviceId = rm.getDeviceId();
                this.postregisterworkExe.submit(() -> {
                    try {
                        ((Future)fut.get()).get();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.registerServerEventsListener(deviceId);
                    ServerUIDetails details = ProxySettings.getUIDetails((String)deviceId);
                    this.serverCommon.tellDeviceWhereUIIs(deviceId, details);
                    MessageBus.getBus().post((Object)new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.ADDED));
                    this.serverCommon.informAgentOfAllJobs(deviceId);
                });
                break;
            }
            case 3: {
                this.serverCommon.bye(base.getDeviceId());
                break;
            }
            case 4: {
                this.sendReplyAsync(replyTo, correlationId, MessageResponseSerialiser.toJson((ServerReplyMessage)new ServerReplyMessage(this.serverCommon.getEmail(base.getDeviceId()))));
                break;
            }
            case 5: {
                UpdateEmailMessage msg3 = (UpdateEmailMessage)base;
                this.endpointService.setEmailOnDevice(msg3.getDeviceId(), msg3.getEmail());
                MessageBus.getBus().post((Object)new EmailChangeEvent(msg3.getDeviceId(), msg3.getEmail()));
                break;
            }
            case 6: {
                UpdateJobStateMessage msg4 = (UpdateJobStateMessage)base;
                String recipient = msg4.getManagerUUID();
                if (recipient == null || recipient.isEmpty() || recipient.equals(this.settings.getUUID())) {
                    this.largeHandler.insertJobChangeEvent(this.jobStateUpdater, msg4.getTaskInstanceId(), msg4.getDeviceId(), msg4.getState(), msg4.getProgress(), msg4.getReason(), msg4.getActionResult());
                    break;
                }
                Progress prog = msg4.getProgress().isPresent() ? (Progress)msg4.getProgress().get() : null;
                this.slaveEnd.updateJobState(msg4.getTaskInstanceId(), msg4.getDeviceId(), msg4.getState(), prog, msg4.getReason(), msg4.getActionResult());
                break;
            }
            case 7: {
                UpdateJobProgressMessage msg = (UpdateJobProgressMessage)base;
                String recipient = msg.getManagerUUID();
                if (recipient == null || recipient.isEmpty() || recipient.equals(this.settings.getUUID())) {
                    MessageBus.getBus().post((Object)new ProgressEvent(msg.getDeviceId(), msg.getTaskInstanceId(), msg.getProgress()));
                    break;
                }
                this.slaveEnd.updateJobProgress(msg.getTaskInstanceId(), msg.getDeviceId(), msg.getProgress());
                break;
            }
            case 8: {
                SendLogMessage msg5 = (SendLogMessage)base;
                MessageBus.getBus().post((Object)new DeviceLogAvailableEvent(msg5.getDeviceId(), msg5.getLog()));
                break;
            }
            case 9: {
                DeviceCapabilitesMessage devCapMsg = (DeviceCapabilitesMessage)base;
                if (devCapMsg.hasSyncFolders()) {
                    this.endpointService.updateAgentSyncFolders(devCapMsg.getDeviceId(), devCapMsg.getSyncFolders());
                    MessageBus.getBus().post((Object)new UpdateDeviceCapabilitiesEvent(devCapMsg.getDeviceId(), devCapMsg.getSyncFolders()));
                    break;
                }
                if (!devCapMsg.hasDbDrivers()) break;
                this.endpointService.updateAgentDatabaseDrivers(devCapMsg.getDeviceId(), devCapMsg.getDbDrivers());
                break;
            }
            case 10: {
                ConnectionResponseMessage msg6 = (ConnectionResponseMessage)base;
                MessageBus.getBus().post((Object)new ConnectionStatusEvent(msg6.getDeviceId(), msg6.getStatus()));
                break;
            }
            case 11: {
                DatabaseTestQueryResponseMessage msg = (DatabaseTestQueryResponseMessage)base;
                MessageBus.getBus().post((Object)new DBTestResultsEvent(msg.getDeviceId(), msg.getResults()));
                break;
            }
            case 12: {
                MultipleConnectionResponseMessage msg = (MultipleConnectionResponseMessage)base;
                MessageBus.getBus().post((Object)new ConnectionStatusMultipleEvent(msg.getDeviceId(), msg.getStatuses()));
                break;
            }
            case 13: {
                AlfrescoPathMessage msg7 = (AlfrescoPathMessage)base;
                MessageBus.getBus().post((Object)new AlfrescoPathStatusEvent(msg7.getDeviceId(), msg7.isOk(), msg7.getReason(), msg7.getPath()));
                break;
            }
            case 14: {
                AlfrescoAspectsMessage msg8 = (AlfrescoAspectsMessage)base;
                MessageBus.getBus().post((Object)new AlfrescoAspectsEvent(msg8.getHost(), msg8.getDeviceId(), msg8.getAspects()));
                break;
            }
            case 15: {
                CloudUsersAndGroupsMessage msg9 = (CloudUsersAndGroupsMessage)base;
                MessageBus.getBus().post((Object)new CloudUsersAndGroupsEvent(msg9.getHostName(), msg9.getDeviceId(), msg9.getUsers(), msg9.getGroups(), msg9.getDeviceType(), msg9.isFirstMessage(), msg9.isLastMessage()));
                break;
            }
            case 16: {
                AtlassianPathMessage msg10 = (AtlassianPathMessage)base;
                MessageBus.getBus().post((Object)new AtlassianPathStatusEvent(msg10.getDeviceId(), msg10.isOk(), msg10.getReason(), msg10.getPath()));
                break;
            }
            case 17: {
                CloudItemsBusHelper.dealWithPlatformObjects((CloudItemsMessage)((CloudItemsMessage)base));
                break;
            }
            case 18: {
                ServerErrorAuditLogMessage msg = (ServerErrorAuditLogMessage)base;
                this.auditLog.auditServerError(this.taskManager, msg);
                break;
            }
            case 19: {
                AgentDiagnosticDataMessage msg = (AgentDiagnosticDataMessage)base;
                this.endpointService.updateAgentDiagnostics(msg.getDeviceId(), msg.getData());
                break;
            }
            case 20: {
                RequestClassificationModelMessage msg = (RequestClassificationModelMessage)base;
                MessageBus.getBus().post((Object)new RequestClassificationModelEvent(msg.getTimestamp(), msg.getDeviceId()));
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Unknown message type {0}", base.getType());
            }
        }
    }

    private void processPreRegisterMessage(String deviceId, String jmsCorrelationID, Destination jmsReplyTo) {
        Optional opt = this.serverCommon.preRegister(deviceId);
        String ret = "";
        if (opt.isPresent()) {
            ret = (String)opt.get();
        }
        this.sendReplyAsync(jmsReplyTo, jmsCorrelationID, MessageResponseSerialiser.toJson((ServerReplyMessage)new ServerReplyMessage(ret)));
    }

    private String register(RegisterMessage rm) {
        Optional resp = this.serverCommon.register(rm.getDetails());
        if (resp.isPresent()) {
            return (String)resp.get();
        }
        LOG.warning("failed to register with sc");
        return "";
    }

    private void registerServerEventsListener(String deviceId) {
        try {
            Queue outQueue = this.getServerInSession().createQueue(deviceId);
            1 listener = new /* Unavailable Anonymous Inner Class!! */;
            this.serverCommon.registerCallback((ServerOutToDeviceListener)listener, deviceId);
        }
        catch (JMSException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, "registerServerEventsListener", ex);
        }
    }
}

