/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging;

import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.Progress;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.jms.KeyException;
import com.geolang.ascema.endpointcommon.jms.MessageEncryptor;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateUpdater;
import com.geolang.ascema.managerservice.messaging.ILargeMessageProcessor;
import com.geolang.ascema.managerservice.messaging.LocalJMSServer;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStore;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class LargeMessageHandler
implements MessageListener {
    private static final Logger LOG = Logger.getLogger(LargeMessageHandler.class.getName());
    private static final int LARGE = 51200;
    private final String msgFolder;
    private final ILargeMessageProcessor processor;
    private final ThreadPoolExecutor service;
    private AtomicLong counter = new AtomicLong(0L);
    private KeyPairStore kpStore;

    LargeMessageHandler(ILargeMessageProcessor processor, KeyPairStore store) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long maxMemoryGig = maxMemory / 0x40000000L;
        int numProcessors = 2;
        if (maxMemory == Long.MAX_VALUE || maxMemoryGig > 10L) {
            numProcessors = 3;
        }
        if (maxMemoryGig <= 4L) {
            numProcessors = 1;
        }
        LOG.log(Level.INFO, "LMQ set to {0} processors Max Memory is {1}G", new Object[]{numProcessors, maxMemoryGig});
        this.service = new ThreadPoolExecutor(numProcessors, numProcessors, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("LMQ-"));
        this.processor = processor;
        this.kpStore = store;
        this.msgFolder = WorkingFolder.getLargeMessageFolder();
        File folder = new File(this.msgFolder);
        String[] files = folder.list();
        if (files != null && files.length > 0) {
            LOG.log(Level.WARNING, "{0} Messages remain in the large message store attempt to process", files.length);
            for (String s : files) {
                this.service.submit(() -> {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(LargeMessageHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.processFile(this.msgFolder + File.separator + s);
                });
            }
        }
    }

    void stop() {
        this.service.shutdownNow();
    }

    private Optional<String> getMessageBaseJson(BytesMessage msg) {
        try {
            String deviceId = msg.getStringProperty("ascema-did");
            Optional kpOpt = this.kpStore.getKeyPairForDevice(deviceId);
            if (kpOpt.isPresent()) {
                String enc = msg.getStringProperty("TYPE");
                String dec = MessageEncryptor.decrypt((String)enc, (PrivateKey)((KeyPair)kpOpt.get()).getPrivate());
                return Optional.of(dec);
            }
        }
        catch (KeyException | JMSException ex) {
            Logger.getLogger(LocalJMSServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Optional.empty();
    }

    public void onMessage(Message msg) {
        block12: {
            try {
                if (!(msg instanceof BytesMessage)) {
                    LOG.severe("Not a byte message in LargeMessageHandler");
                    return;
                }
                BytesMessage bm = (BytesMessage)msg;
                Optional basestrOpt = this.getMessageBaseJson(bm);
                if (!basestrOpt.isPresent()) {
                    LOG.warning("Can't decode large message");
                    return;
                }
                String basestr = (String)basestrOpt.get();
                long len = bm.getBodyLength();
                byte[] bytes = new byte[(int)len];
                bm.readBytes(bytes);
                bm.clearBody();
                if (len > 51200L) {
                    Long filename = this.counter.incrementAndGet();
                    String filepath = this.msgFolder + File.separator + filename.toString();
                    File f = new File(filepath);
                    while (f.exists()) {
                        filename = this.counter.incrementAndGet();
                        filepath = this.msgFolder + File.separator + filename.toString();
                        f = new File(filepath);
                    }
                    try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filepath));){
                        oos.writeUTF(basestr);
                        oos.writeLong(len);
                        oos.write(bytes);
                    }
                    String filepathFinal = filepath;
                    this.service.submit(() -> this.processFile(filepathFinal));
                    break block12;
                }
                this.service.submit(() -> this.processor.processLargeMessage(basestr, bytes));
            }
            catch (JMSException | IOException ex) {
                Logger.getLogger(LargeMessageHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void insertJobChangeEvent(JobStateUpdater jobStateUpdater, String taskInstanceId, String deviceId, JobState state, Optional<Progress> progress, String reason, ActionResult actionResult) {
        if (state.isFinished() || state.isCancelled()) {
            this.service.submit(() -> jobStateUpdater.updateJobState(taskInstanceId, deviceId, state, progress, reason, actionResult));
        } else {
            jobStateUpdater.updateJobState(taskInstanceId, deviceId, state, progress, reason, actionResult);
        }
    }

    private void processFile(String filename) {
        try {
            byte[] bytes;
            String basestr;
            try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]));){
                basestr = ois.readUTF();
                long len = ois.readLong();
                bytes = new byte[(int)len];
                ois.readFully(bytes);
            }
            this.processor.processLargeMessage(basestr, bytes);
            File f = new File(filename);
            f.delete();
        }
        catch (Exception ex) {
            Logger.getLogger(LargeMessageHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

