/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging;

import com.geolang.ascema.endpointcommon.jms.JMSCerts;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationJMSFac;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.messaging.serverserver.BaseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.ServerServerMessageJMSFac;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStore;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslBrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public abstract class JmsServerBase
implements MessageListener {
    private static final Logger LOG = Logger.getLogger(JmsServerBase.class.getName());
    private PooledConnection connection;
    protected BrokerService broker;
    private String messageBrokerUrl;
    private Session serverInSession;
    private Session replySession;
    private MessageProducer replyProducer;
    private String lastMessage = "";
    private boolean isRunning = false;
    private ThreadPoolExecutor replyService;
    protected Queue adminQueue;
    protected Queue largeQueue;
    private Session pingReplySession;
    private MessageProducer pingReplyProducer;
    private ThreadPoolExecutor pingReplyService;
    private KeyPairStore kpStore;

    public abstract void start();

    public abstract void onMessage(Message var1);

    public abstract void setupConsumers();

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setKpStore(KeyPairStore kpStore) {
        this.kpStore = kpStore;
    }

    protected synchronized void start(String name, int port, boolean persist) {
        LOG.log(Level.INFO, "Starting jms {0}", name);
        try {
            this.replyService = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("replyService-"));
            this.pingReplyService = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("pingReplyService-"));
            this.messageBrokerUrl = "nio+ssl://0.0.0.0:" + port + "?daemon=true";
            TrustManager[] trustmanagers = JMSCerts.getServerTrustManager();
            KeyManager[] keymanagers = JMSCerts.getServerKeyManager();
            SecureRandom sr = new SecureRandom();
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(keymanagers, trustmanagers, sr);
            SSLContext.setDefault(ctx);
            this.broker = new SslBrokerService();
            ((SslBrokerService)this.broker).addSslConnector(this.messageBrokerUrl, keymanagers, trustmanagers, sr);
            ActiveMQSslConnectionFactory connectionFactoryInner = new ActiveMQSslConnectionFactory(this.messageBrokerUrl + "&verifyHostName=false");
            if (persist) {
                this.broker.setDataDirectory(WorkingFolder.getMessageQFolder());
            } else {
                this.broker.setPersistent(false);
            }
            PolicyMap policies = new PolicyMap();
            PolicyEntry policy = new PolicyEntry();
            policy.setGcInactiveDestinations(true);
            policy.setInactiveTimeoutBeforeGC(120000L);
            policies.setDefaultEntry(policy);
            this.broker.setDestinationPolicy(policies);
            this.broker.setMessageAuthorizationPolicy((cc, msg) -> {
                try {
                    String qname = msg.getDestination().getPhysicalName();
                    if (qname.equals("AscemaServerInQueue") || qname.equals("AscemaServerLargeInQueue")) {
                        return cc.getClientId().equals(this.connection.getClientID());
                    }
                    return true;
                }
                catch (JMSException ex) {
                    Logger.getLogger(JmsServerBase.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            });
            this.broker.setUseJmx(false);
            this.broker.setAdvisorySupport(false);
            this.broker.setEnableStatistics(false);
            this.broker.setBrokerName(name);
            LOG.log(Level.INFO, "broker startup...");
            this.broker.start();
            this.broker.waitUntilStarted();
            LOG.log(Level.INFO, "broker started");
            connectionFactoryInner.setKeyAndTrustManagers(keymanagers, trustmanagers, sr);
            connectionFactoryInner.setTrustedPackages(new ArrayList<String>(Arrays.asList("java.lang,java.util,com.geolang.ascema".split(","))));
            connectionFactoryInner.setCopyMessageOnSend(false);
            connectionFactoryInner.setOptimizeAcknowledge(true);
            connectionFactoryInner.setUseAsyncSend(true);
            PooledConnectionFactory connectionFactory = new PooledConnectionFactory((ActiveMQConnectionFactory)connectionFactoryInner);
            connectionFactory.setMaxConnections(32);
            this.connection = (PooledConnection)connectionFactory.createConnection();
            this.connection.setExceptionListener(ex -> {
                LOG.log(Level.SEVERE, "Exception in JMS {0}", ex.getMessage());
                LOG.info("Attempt restart");
                if (this.isRunning) {
                    this.stop();
                    this.start();
                }
            });
            this.connection.start();
            this.serverInSession = this.connection.createSession(false, 1);
            this.replySession = this.connection.createSession(false, 1);
            this.pingReplySession = this.connection.createSession(false, 1);
            this.adminQueue = this.serverInSession.createQueue("AscemaServerInQueue");
            this.largeQueue = this.serverInSession.createQueue("AscemaServerLargeInQueue");
            this.replyProducer = this.replySession.createProducer(null);
            this.pingReplyProducer = this.pingReplySession.createProducer(null);
            if (persist) {
                this.replyProducer.setDeliveryMode(2);
            } else {
                this.replyProducer.setDeliveryMode(1);
            }
            this.setupConsumers();
            this.isRunning = true;
            LOG.log(Level.INFO, "broker running is {0}", this.isRunning);
        }
        catch (Exception ex2) {
            LOG.log(Level.SEVERE, null, ex2);
            this.lastMessage = ex2.getMessage();
        }
    }

    protected synchronized void stop() {
        try {
            this.isRunning = false;
            this.serverInSession.close();
            this.replyService.shutdownNow();
            this.pingReplyService.shutdownNow();
            this.replySession.close();
            this.pingReplySession.close();
            this.connection.close();
            this.broker.stop();
        }
        catch (JMSException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    protected Session getServerInSession() {
        return this.serverInSession;
    }

    protected Session getServerLargeInSession() {
        return this.serverInSession;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    protected boolean sendMessageFromAnyThread(Destination replyTo, BaseServerServerMessage ev) {
        if (null != this.replySession) {
            this.replyService.submit(() -> {
                try {
                    MapMessage toSend = this.getServerInSession().createMapMessage();
                    ServerServerMessageJMSFac.toJMSMessage((BaseServerServerMessage)ev, (MapMessage)toSend);
                    this.replyProducer.send(replyTo, (Message)toSend);
                }
                catch (JMSException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            });
            return true;
        }
        return false;
    }

    protected boolean sendMessageFromAnyThreadMasterSlave(Destination replyTo, String deviceId, ServerNotificationBase ev) {
        if (null != this.replySession) {
            this.replyService.submit(() -> {
                try {
                    MapMessage toSend = this.getServerInSession().createMapMessage();
                    toSend.setString("deviceId", deviceId);
                    ServerNotificationJMSFac.toJMSMessage((ServerNotificationBase)ev, (MapMessage)toSend);
                    this.replyProducer.send(replyTo, (Message)toSend);
                }
                catch (JMSException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            });
            return true;
        }
        return false;
    }

    protected boolean sendByteMessage(Destination replyTo, String deviceId, ServerNotificationBase ev, byte[] model) {
        if (null != this.replySession) {
            this.replyService.submit(() -> {
                try {
                    BytesMessage bm = this.getServerInSession().createBytesMessage();
                    bm.setStringProperty("deviceId", deviceId);
                    bm.writeBytes(model);
                    Optional opt = this.kpStore.getKeyPairForDevice(deviceId);
                    if (!opt.isPresent()) {
                        LOG.log(Level.WARNING, "no keys to sign notification to {0}", deviceId);
                        return;
                    }
                    KeyPair kp = (KeyPair)opt.get();
                    ServerNotificationJMSFac.toJMSMessageWithSignatureBytes((ServerNotificationBase)ev, (BytesMessage)bm, (PrivateKey)kp.getPrivate());
                    this.replyProducer.send(replyTo, (Message)bm);
                }
                catch (JMSException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            });
            return true;
        }
        return false;
    }

    protected boolean sendMessageFromAnyThread(Destination replyTo, String deviceId, ServerNotificationBase ev) {
        if (null != this.replySession) {
            this.replyService.submit(() -> {
                try {
                    MapMessage toSend = this.getServerInSession().createMapMessage();
                    toSend.setString("deviceId", deviceId);
                    Optional opt = this.kpStore.getKeyPairForDevice(deviceId);
                    if (!opt.isPresent()) {
                        LOG.log(Level.WARNING, "no keys to sign notification to {0}", deviceId);
                        return;
                    }
                    KeyPair kp = (KeyPair)opt.get();
                    ServerNotificationJMSFac.toJMSMessageWithSignature((ServerNotificationBase)ev, (MapMessage)toSend, (PrivateKey)kp.getPrivate());
                    this.replyProducer.send(replyTo, (Message)toSend);
                }
                catch (JMSException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            });
            return true;
        }
        return false;
    }

    protected Optional<Future<?>> sendReplyAsync(Destination replyTo, String correlationId, String text) {
        if (null != this.replySession) {
            Future<?> f = this.replyService.submit(() -> {
                try {
                    TextMessage message = this.replySession.createTextMessage();
                    message.setJMSCorrelationID(correlationId);
                    message.setStringProperty("mtkey", "mtrp");
                    message.setText(text);
                    this.replyProducer.send(replyTo, (Message)message);
                }
                catch (JMSException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            });
            return Optional.of(f);
        }
        return Optional.empty();
    }

    protected Optional<Future<?>> sendPingReplyAsync(Destination replyTo, String correlationId, String text) {
        if (null != this.pingReplySession) {
            Future<?> f = this.pingReplyService.submit(() -> {
                try {
                    TextMessage message = this.pingReplySession.createTextMessage();
                    message.setJMSCorrelationID(correlationId);
                    message.setStringProperty("mtkey", "mtrp");
                    message.setText(text);
                    this.pingReplyProducer.send(replyTo, (Message)message);
                }
                catch (JMSException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            });
            return Optional.of(f);
        }
        return Optional.empty();
    }
}

