/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.messaging;

import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.domain.ManagerRole;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.web.WebSecondaryConfig;
import com.geolang.ascema.managerevents.ServerNameChangeEvent;
import com.geolang.ascema.managerevents.ServerRoleChangeEvent;
import com.geolang.ascema.managerservice.messaging.JMSManager;
import com.geolang.ascema.managerservice.messaging.LocalJMSServer;
import com.geolang.ascema.managerservice.messaging.SocketUtils;
import com.geolang.ascema.managerservice.messaging.serverserver.ISlave;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import com.geolang.ascema.managerservice.messaging.serverserver.SlaveEnd;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JMSManager {
    private static final Logger LOG = Logger.getLogger(JMSManager.class.getName());
    @Autowired
    private LocalJMSServer server;
    @Autowired
    private MasterEnd master;
    @Autowired
    private SlaveEnd slave;
    private ExecutorService executor;
    private volatile boolean stopping = false;
    private final Object roleLock = new Object();

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
        this.stop();
    }

    private void init() {
        MessageBus.getBus().register((Object)this);
        this.server.setSlaveEnd((ISlave)this.slave);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(() -> this.maintainConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainConnection() {
        while (!this.stopping) {
            Object object = this.roleLock;
            synchronized (object) {
                ManagerRole role = SettingsFile.getInstance().getManagerRole();
                if (role.equals((Object)ManagerRole.PRIMARY)) {
                    if (!this.master.isRunning()) {
                        this.master.start();
                    } else {
                        this.master.checkSlaveConnections();
                    }
                } else if (role.equals((Object)ManagerRole.SECONDARY)) {
                    if (!this.slave.isRunning()) {
                        this.slave.start();
                    } else {
                        this.slave.ping();
                    }
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(JMSManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void stop() {
        this.stopping = true;
        this.executor.shutdownNow();
        this.server.stop();
        if (this.master.isRunning()) {
            this.master.stop();
        }
        if (this.slave.isRunning()) {
            this.slave.stop(false);
        }
    }

    public void setLocalMessageServerPort(int port) {
        LOG.log(Level.INFO, "Set Message Server Port {0}", port);
        SettingsFile.getInstance().setMessageServerPort(port);
        this.server.stop();
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMasterPort(int port) {
        if (!SocketUtils.isTCPPortAvailable((int)port)) {
            LOG.log(Level.INFO, "Port not available {0}", port);
            return false;
        }
        LOG.log(Level.INFO, "Set primary port {0}", port);
        SettingsFile.getInstance().setMasterSlavePort(port);
        Object object = this.roleLock;
        synchronized (object) {
            if (this.master.isRunning()) {
                this.master.stop();
                this.master.start();
            }
            if (this.slave.isRunning()) {
                this.slave.stop(false);
                this.slave.start();
            }
        }
        return true;
    }

    public boolean setManagerRole(ManagerRole role) {
        LOG.log(Level.INFO, "Set manager role {0}", role);
        SettingsFile.getInstance().setManagerRole(role);
        this.onRoleChange(role);
        MessageBus.getBus().post((Object)new ServerRoleChangeEvent(role));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMasterUrl(String url) {
        LOG.log(Level.INFO, "Set primary url {0}", url);
        SettingsFile.getInstance().setMasterHost(url);
        Object object = this.roleLock;
        synchronized (object) {
            if (this.slave.isRunning()) {
                this.slave.stop(true);
                this.slave.start();
                return this.slave.isRunning();
            }
            return this.slave.testConnection();
        }
    }

    public boolean setServerName(String loc) {
        if (this.master.isRunning()) {
            for (WebSecondaryConfig conf : this.master.getAttachedSlaves()) {
                if (!conf.getName().equals(loc)) continue;
                LOG.log(Level.WARNING, "Already have secondary called {0}", loc);
                return false;
            }
        }
        LOG.log(Level.INFO, "Set server name {0}", loc);
        String old = SettingsFile.getInstance().getManagerName();
        SettingsFile.getInstance().setManagerName(loc);
        MessageBus.getBus().post((Object)new ServerNameChangeEvent(loc, old));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRoleChange(ManagerRole newrole) {
        Object object = this.roleLock;
        synchronized (object) {
            switch (1.$SwitchMap$com$geolang$ascema$managercore$domain$ManagerRole[newrole.ordinal()]) {
                case 1: {
                    LOG.info("Changing role to primary");
                    if (this.slave.isRunning()) {
                        this.slave.stop(true);
                    }
                    if (this.master.isRunning()) break;
                    this.master.start();
                    break;
                }
                case 2: {
                    LOG.info("Changing role to secondary");
                    if (this.master.isRunning()) {
                        this.master.stop();
                    }
                    if (this.slave.isRunning()) break;
                    this.slave.start();
                    break;
                }
                case 3: {
                    if (this.slave.isRunning()) {
                        LOG.info("Changing role from secondary->standalone");
                        this.slave.stop(true);
                        this.setServerName("");
                    }
                    if (!this.master.isRunning()) break;
                    LOG.info("Changing role from primary->standalone");
                    this.master.stop();
                    this.setServerName("");
                }
            }
        }
    }

    public List<WebSecondaryConfig> getAttachedSlaves() {
        return this.master.getAttachedSlaves();
    }

    public void updateToUI() {
        if (this.master.isRunning()) {
            this.master.tellSlavesToUseMasterUI();
        }
    }

    public boolean deleteSlave(String name) {
        return this.master.deleteSlaveByName(name);
    }

    public boolean localIsRunning() {
        return this.server != null && this.server.isRunning();
    }

    public String localLastMessage() {
        return this.server.getLastMessage();
    }

    public boolean masterIsRunning() {
        return this.master != null && this.master.isRunning();
    }

    public String masterLastMessage() {
        return this.master.getLastMessage();
    }
}

