/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.license;

import com.geolang.ascema.license.ReadonlyAscemaLicense;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.domain.ManagerRole;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.domain.LicenseAllocation;
import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerdomain.domain.SecondaryConfig;
import com.geolang.ascema.managerevents.LicenseChangeEvent;
import com.geolang.ascema.managerevents.NotificationEvent;
import com.geolang.ascema.managerevents.ServerNameChangeEvent;
import com.geolang.ascema.managerpersistence.ISecondaryConfigRepository;
import com.geolang.ascema.managerpersistence.serviceinterfaces.ILicenseManager;
import com.geolang.ascema.managerservice.license.LicenseProblemException;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.DateUtils;
import org.bouncycastle.openpgp.PGPException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseManager
implements ILicenseManager {
    private static final Logger LOG = Logger.getLogger(LicenseManager.class.getName());
    private final int MONTHS_GRACE_PERIOD = 1;
    private final int MAX_ENDPOINTS_WITHOUT_LICENSE = 3;
    private final int MAX_FILESERVERS_WITHOUT_LICENSE = 1;
    private final int MAX_ALFRESCO_WITHOUT_LICENSE = 1;
    private final int MAX_O365_WITHOUT_LICENSE = 1;
    private final int MAX_GOOGLE_WITHOUT_LICENSE = 1;
    private final int MAX_ATLASSIAN_WITHOUT_LICENSE = 1;
    private final int MAX_SECONDARY_MANAGERS_WITHOUT_LICENSE = 0;
    private final int DAYS_BEFORE_EXPIRY_TO_START_NOTIFICATIONS = 10;
    private File licFile;
    private LicenseAllocation allocatedLicense = null;
    private boolean licenseExists;
    private ReadonlyAscemaLicense license = null;
    private final SettingsFile settings = SettingsFile.getInstance();
    @Autowired
    private ISecondaryConfigRepository allocationsRepo;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
        this.init();
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void onServerNameChange(ServerNameChangeEvent ev) {
        SecondaryConfig conf = this.allocationsRepo.findByName(ev.getOldName());
        if (conf != null) {
            conf.setName(ev.getNewName());
            this.allocationsRepo.save((Object)conf);
        }
    }

    private void init() {
        Path folder = Paths.get(WorkingFolder.getWorkingFolder(), new String[0]);
        String filePath = folder.normalize().toAbsolutePath().toString() + File.separator + "ascemalicense.txt";
        this.licFile = new File(filePath);
        if (this.isRunningAsSecondary()) {
            this.setLocalAllocations();
            LOG.info("Waiting for primary to send license allocation");
            return;
        }
        this.licenseExists = this.licFile.exists();
        if (this.licenseExists) {
            try {
                Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Found license");
                this.license = new ReadonlyAscemaLicense(this.licFile);
                if (this.isExpired()) {
                    Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "License Expired");
                } else {
                    Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Not Expired");
                }
                Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Company {0}", this.license.getCompany());
                Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Plan {0}", this.license.getPlanTitle());
            }
            catch (IOException | PGPException ex) {
                LOG.log(Level.SEVERE, "Failed to load license {0}", ex.getLocalizedMessage());
                this.licenseExists = false;
            }
        } else {
            Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "No license");
        }
        this.setLocalAllocations();
        LOG.log(Level.INFO, "Max Endpoints {0}", this.getMaxEndpointAgents());
        LOG.log(Level.INFO, "Max Fileservers {0}", this.getMaxFileservers());
        LOG.log(Level.INFO, "Max Alfresco {0}", this.getMaxAlfrescoAgents());
        LOG.log(Level.INFO, "Max O365 {0}", this.getMaxO365Agents());
        LOG.log(Level.INFO, "Max Google {0}", this.getMaxGoogleAgents());
        LOG.log(Level.INFO, "Max Atlassian {0}", this.getMaxAtlassianAgents());
        LOG.log(Level.INFO, "Max Secondary {0}", this.getMaxSecondaryManagers());
        this.notifyAdminsIfrequired();
        if (this.licenseExists) {
            Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Expires {0}", this.license.getUntil());
        }
    }

    private void setLocalAllocations() {
        Optional mgrOpt = this.allocationsRepo.findById((Object)this.settings.getUUID());
        if (!mgrOpt.isPresent() || !this.licenseExists) {
            this.setFullAllocation();
            SecondaryConfig config = new SecondaryConfig(this.settings.getUUID(), this.settings.getManagerName(), this.allocatedLicense);
            this.allocationsRepo.save((Object)config);
        } else {
            this.allocatedLicense = ((SecondaryConfig)mgrOpt.get()).getAllocation();
        }
    }

    public void setAllocations(LicenseAllocation allocations) {
        this.allocatedLicense = new LicenseAllocation(allocations.getNumEndpoints(), allocations.getNumFileservers(), allocations.getNumAlfresco(), allocations.getNumO365(), allocations.getNumAtlassian(), allocations.getNumGoogle(), allocations.getMasterLicenseExpires());
        Optional opt = this.allocationsRepo.findById((Object)this.settings.getUUID());
        SecondaryConfig ourConfig = !opt.isPresent() ? new SecondaryConfig(this.settings.getUUID(), this.settings.getManagerName(), allocations) : (SecondaryConfig)opt.get();
        ourConfig.setAllocation(allocations);
        this.allocationsRepo.save((Object)ourConfig);
        LOG.info("License allocations from Primary:");
        LOG.log(Level.INFO, "Max Endpoints {0}", allocations.getNumEndpoints());
        LOG.log(Level.INFO, "Max Fileservers {0}", allocations.getNumFileservers());
        LOG.log(Level.INFO, "Max Alfresco {0}", allocations.getNumAlfresco());
        LOG.log(Level.INFO, "Max O365 {0}", allocations.getNumO365());
        LOG.log(Level.INFO, "Max Google {0}", allocations.getNumGoogle());
        LOG.log(Level.INFO, "Max Atlassian {0}", allocations.getNumAtlassian());
        LOG.log(Level.INFO, "Expires {0}", allocations.getMasterLicenseExpires());
    }

    public LicenseAllocation getAllocatedLicense() {
        return this.allocatedLicense;
    }

    private void setFullAllocation() {
        this.allocatedLicense = new LicenseAllocation(this.licenseGetMaxEndpointAgents(), this.licenseGetMaxFileservers(), this.licenseGetMaxAlfrescoAgents(), this.licenseGetMaxO365Agents(), this.licenseGetMaxAtlassianAgents(), this.licenseGetMaxGoogleAgents(), this.licenseGetExpires());
    }

    public Date getExpireDate() {
        Date expires = this.licenseExists ? this.license.getUntil() : this.allocatedLicense.getMasterLicenseExpires();
        return expires;
    }

    public Optional<Date> getStartDate() {
        if (this.licenseExists) {
            return Optional.of(this.license.getFrom());
        }
        return Optional.empty();
    }

    public boolean isExpired() {
        Date now;
        boolean ret;
        Date startPlusOneMonth;
        Date expires = this.getExpireDate();
        Date withGrace = DateUtils.addMonths((Date)expires, (int)1);
        Optional start = this.getStartDate();
        if (start.isPresent() && !expires.after(startPlusOneMonth = DateUtils.addMonths((Date)((Date)start.get()), (int)1))) {
            withGrace = expires;
        }
        if (ret = withGrace.before(now = new Date())) {
            LOG.log(Level.WARNING, "License expired at {0} it is now {1}. exists={2}", new Object[]{expires, now, this.licenseExists});
        }
        return ret;
    }

    public final boolean setLicense(String licenseStr) throws LicenseProblemException {
        try {
            ReadonlyAscemaLicense oldLicense = null;
            ReadonlyAscemaLicense lic = new ReadonlyAscemaLicense(licenseStr);
            if (this.licenseExists) {
                oldLicense = this.license;
                Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Replacing license {0}", this.license.getId());
            } else {
                Logger.getLogger(LicenseManager.class.getName()).log(Level.INFO, "Install new license");
                try {
                    Files.createFile(this.licFile.toPath(), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    LOG.info("License file already exists - overwrite");
                }
            }
            Files.write(this.licFile.toPath(), licenseStr.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.licenseExists = true;
            this.license = lic;
            if (this.license.getNumSecondaryManager() <= 0) {
                this.settings.setManagerRole(ManagerRole.STANDALONE);
            }
            if (this.isRunningAsStandalone()) {
                this.setFullAllocation();
                SecondaryConfig config = new SecondaryConfig(this.settings.getUUID(), this.settings.getManagerName(), this.allocatedLicense);
                this.allocationsRepo.save((Object)config);
            } else if (this.oldLicenseExceedsNewLicense(oldLicense)) {
                this.adjustAllocations();
            }
            this.notifyLicenseInstalled();
            MessageBus.getBus().post((Object)new LicenseChangeEvent(this.license));
            return true;
        }
        catch (IOException | PGPException ex) {
            throw new LicenseProblemException("Can't set license", ex);
        }
    }

    public final ReadonlyAscemaLicense getLicense() {
        return this.license;
    }

    public final boolean isLicenseExists() {
        return this.licenseExists;
    }

    public final int getMaxEndpointAgents() {
        return this.allocatedLicense.getNumEndpoints();
    }

    public final int getMaxFileservers() {
        return this.allocatedLicense.getNumFileservers();
    }

    public final int getMaxAlfrescoAgents() {
        return this.allocatedLicense.getNumAlfresco();
    }

    public final int getMaxO365Agents() {
        return this.allocatedLicense.getNumO365();
    }

    public Integer getMaxGoogleAgents() {
        return this.allocatedLicense.getNumGoogle();
    }

    public final int getMaxAtlassianAgents() {
        return this.allocatedLicense.getNumAtlassian();
    }

    public int getMaxSecondaryManagers() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumSecondaryManager();
        }
        return 0;
    }

    private int licenseGetMaxEndpointAgents() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumEndpoints();
        }
        return 3;
    }

    private Date licenseGetExpires() {
        if (this.licenseExists) {
            return this.license.getUntil();
        }
        return new Date();
    }

    private int licenseGetMaxFileservers() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumFileserver();
        }
        return 1;
    }

    private int licenseGetMaxAlfrescoAgents() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumAlfresco();
        }
        return 1;
    }

    private int licenseGetMaxO365Agents() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumO365();
        }
        return 1;
    }

    private int licenseGetMaxGoogleAgents() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumGoogle();
        }
        return 1;
    }

    private int licenseGetMaxAtlassianAgents() {
        if (this.licenseExists && !this.isExpired()) {
            return this.license.getNumAtlassian();
        }
        return 1;
    }

    private void notifyLicenseInstalled() {
        if (this.isExpired()) {
            Notification n = new Notification("Expired License installed", "Your License expired on " + this.license.getUntil().toString() + " . Please contact sales to renew it.", NotificationType.WARNING);
            MessageBus.getBus().post((Object)NotificationEvent.createForAdminLicenseMessage((Notification)n));
        } else {
            Notification n = new Notification("License installed", "Your License is successfully installed. You can view Licence details under Administration", NotificationType.SUCCESS);
            MessageBus.getBus().post((Object)NotificationEvent.createForAdminLicenseMessage((Notification)n));
        }
    }

    private void notifyAdminsIfrequired() {
        if (!this.licenseExists) {
            if (!this.isRunningAsSecondary()) {
                Notification n = new Notification("You do not have a licence", "You do not have a licence. Please contact sales.", NotificationType.ERROR);
                MessageBus.getBus().post((Object)NotificationEvent.createForAdminLicenseMessage((Notification)n));
            }
        } else if (!this.isExpired()) {
            Date now = new Date();
            Date tendaysbeforeexpiry = DateUtils.addDays((Date)this.license.getUntil(), (int)-10);
            if (now.after(tendaysbeforeexpiry)) {
                Notification n = new Notification("License expiring soon", "Your License expires on " + this.license.getUntil().toString() + " . Please contact sales to renew it.", NotificationType.WARNING);
                MessageBus.getBus().post((Object)NotificationEvent.createForAdminLicenseMessage((Notification)n));
            }
        } else {
            Notification n = new Notification("License Expired", "Your License expired on " + this.license.getUntil().toString() + " . Please contact sales to renew it.", NotificationType.ERROR);
            MessageBus.getBus().post((Object)NotificationEvent.createForAdminLicenseMessage((Notification)n));
        }
    }

    private boolean isRunningAsSecondary() {
        return this.settings.getManagerRole().equals((Object)ManagerRole.SECONDARY);
    }

    private boolean isRunningAsPrimary() {
        return this.settings.getManagerRole().equals((Object)ManagerRole.PRIMARY);
    }

    private boolean isRunningAsStandalone() {
        return this.settings.getManagerRole().equals((Object)ManagerRole.STANDALONE);
    }

    private void adjustAllocations() {
        SecondaryConfig sc;
        boolean changed;
        LOG.log(Level.INFO, "reduced license allowance");
        ArrayList<SecondaryConfig> slaves = new ArrayList<SecondaryConfig>();
        SecondaryConfig primary = null;
        Integer totalAlfresco = 0;
        Integer totalEndpoint = 0;
        Integer totalFileserver = 0;
        Integer totalO365 = 0;
        Integer totalGoogle = 0;
        Integer totalAtlassian = 0;
        for (SecondaryConfig conf : this.allocationsRepo.findAll()) {
            if (conf.getUuid().equals(this.settings.getUUID())) {
                primary = conf;
            } else {
                slaves.add(conf);
            }
            LicenseAllocation allocation = conf.getAllocation();
            totalAlfresco = totalAlfresco + allocation.getNumAlfresco();
            totalEndpoint = totalEndpoint + allocation.getNumEndpoints();
            totalFileserver = totalFileserver + allocation.getNumFileservers();
            totalO365 = totalO365 + allocation.getNumO365();
            totalGoogle = totalGoogle + allocation.getNumGoogle();
            totalAtlassian = totalAtlassian + allocation.getNumAtlassian();
        }
        if (primary != null) {
            this.changeAllocation(totalEndpoint, totalFileserver, totalAlfresco, totalO365, totalAtlassian, totalGoogle, primary);
        }
        Iterator iterator = slaves.iterator();
        while (iterator.hasNext() && (changed = this.changeAllocation(totalEndpoint, totalFileserver, totalAlfresco, totalO365, totalAtlassian, totalGoogle, sc = (SecondaryConfig)iterator.next()))) {
        }
    }

    private boolean changeAllocation(Integer totalEndpoint, Integer totalFileserver, Integer totalAlfresco, Integer totalO365, Integer totalAtlassian, Integer totalGoogle, SecondaryConfig sc) {
        int countFs;
        int countEp;
        int countAtlassian;
        int countGoogle;
        int countO365;
        int countAlf;
        int allowedAlfreco = this.license.getNumAlfresco();
        int allowedFileserver = this.license.getNumFileserver();
        int allowedEndpoint = this.license.getNumEndpoints();
        int allowedO365 = this.license.getNumO365();
        int allowedAtlassian = this.license.getNumAtlassian();
        int allowedGoogle = this.license.getNumGoogle();
        boolean changed = false;
        LicenseAllocation la = sc.getAllocation();
        for (countAlf = la.getNumAlfresco(); countAlf > 0 && totalAlfresco > allowedAlfreco; --countAlf) {
            Integer n = totalAlfresco;
            totalAlfresco = totalAlfresco - 1;
            changed = true;
        }
        for (countO365 = la.getNumO365(); countO365 > 0 && totalO365 > allowedO365; --countO365) {
            Integer n = totalO365;
            totalO365 = totalO365 - 1;
            changed = true;
        }
        for (countGoogle = la.getNumGoogle(); countGoogle > 0 && totalGoogle > allowedGoogle; --countGoogle) {
            Integer n = totalGoogle;
            totalGoogle = totalGoogle - 1;
            changed = true;
        }
        for (countAtlassian = la.getNumAtlassian(); countAtlassian > 0 && totalAtlassian > allowedAtlassian; --countAtlassian) {
            Integer n = totalAtlassian;
            totalAtlassian = totalAtlassian - 1;
            changed = true;
        }
        for (countEp = la.getNumEndpoints(); countEp > 0 && totalEndpoint > allowedEndpoint; --countEp) {
            Integer n = totalEndpoint;
            totalEndpoint = totalEndpoint - 1;
            changed = true;
        }
        for (countFs = la.getNumFileservers(); countFs > 0 && totalFileserver > allowedFileserver; --countFs) {
            Integer n = totalFileserver;
            totalFileserver = totalFileserver - 1;
            changed = true;
        }
        if (changed) {
            LicenseAllocation newAllocation = new LicenseAllocation(countEp, countFs, countAlf, countO365, countAtlassian, countGoogle, this.licenseGetExpires());
            sc.setAllocation(newAllocation);
            this.allocationsRepo.save((Object)sc);
        }
        return changed;
    }

    private boolean oldLicenseExceedsNewLicense(ReadonlyAscemaLicense old) {
        if (old == null) {
            return false;
        }
        return old.getNumAtlassian() > this.license.getNumAtlassian() || old.getNumO365() > this.license.getNumO365() || old.getNumGoogle() > this.license.getNumGoogle() || old.getNumAlfresco() > this.license.getNumAlfresco() || old.getNumEndpoints() > this.license.getNumEndpoints() || old.getNumFileserver() > this.license.getNumFileserver();
    }
}

