/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks.actions;

import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.domainmodelpublic.ResultStatusReason;
import com.geolang.ascema.endpointcommon.domain.AlertMsg;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.domain.ConfiguredAlertMethods;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.QuarantineAction;
import com.geolang.ascema.endpointcommon.domain.QuarantineResult;
import com.geolang.ascema.endpointcommon.domain.searchconfig.IRouteableSearchConfig;
import com.geolang.ascema.endpointcommon.messages.servernotification.AlertServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.managercore.BrandingStrings;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.actions.InFlightAndDeferredActionsCollection;
import com.geolang.ascema.managerdomain.actions.InFlightName;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.dto.DTOResultIdAndPath;
import com.geolang.ascema.managerdomain.web.QuarantineBulkCommand;
import com.geolang.ascema.managerdomain.web.QuarantinedDataPoint;
import com.geolang.ascema.managerdomain.web.QuarantinedDataSliceRequest;
import com.geolang.ascema.managerdomain.web.QuarantinedResultsPage;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerdomain.web.actions.DeviceWithActionableTasks;
import com.geolang.ascema.managerevents.NotificationEvent;
import com.geolang.ascema.managerevents.QuarantineJobDoneEvent;
import com.geolang.ascema.managerpersistence.EventHistoryStore;
import com.geolang.ascema.managerpersistence.results.MatchesManager;
import com.geolang.ascema.managerpersistence.serviceinterfaces.ITaskManager;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.controllers.tasks.actions.ActionsTaskCreator;
import com.geolang.ascema.managerservice.controllers.tasks.actions.QuarantineController;
import com.google.common.collect.Lists;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class QuarantineController {
    private static final Logger LOG = Logger.getLogger(QuarantineController.class.getName());
    @Autowired
    @Lazy
    private ResultsManager resultsManager;
    @Lazy
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private MatchesManager matchesManager;
    @Autowired
    DeviceService endpointService;
    @Autowired
    AlertingController alertingController;
    @Autowired
    EventHistoryStore eventHistoryStore;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private ActionsTaskCreator actionsCreator;
    @Autowired
    private InFlightAndDeferredActionsCollection inFlight;
    private final AtomicInteger counter = new AtomicInteger(1);
    private Map<String, List<String>> messages = new HashMap();

    public String runQuarantine(String user, String deviceId, String filePath, String quarantinePath, boolean alertWhenDone) {
        return this.run(QuarantineAction.QUARANTINE, user, deviceId, filePath, quarantinePath, alertWhenDone);
    }

    public String runRevert(String user, String deviceId, String filePath, String quarantinePath, boolean alertWhenDone) {
        return this.run(QuarantineAction.UNQUARANTINE, user, deviceId, filePath, quarantinePath, alertWhenDone);
    }

    public String runDelete(String user, String deviceId, String filePath, String quarantinePath, boolean alertWhenDone) {
        return this.run(QuarantineAction.DELETE, user, deviceId, filePath, quarantinePath, alertWhenDone);
    }

    private String run(QuarantineAction action, String user, String deviceId, String filePath, String quarantinePath, boolean alertWhenDone) {
        TaskInstance ret = this.jobRunner.runQuarantineCommand(user, deviceId, action, filePath, quarantinePath, alertWhenDone, "", Long.valueOf(-1L));
        return ret.getUid();
    }

    public boolean requestRevert(String deviceId, String filePath, String quarantinePath, boolean alertWhenDone) {
        Optional opt = this.endpointService.getDeviceFromId(deviceId, true);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Can't find device to process revert request {0}", deviceId);
            return false;
        }
        DeviceRegistration reg = (DeviceRegistration)opt.get();
        List srs = this.resultsManager.getResultsForDeviceAndFilePath(deviceId, filePath, BaseResult.searchAndRealtimeTypes());
        for (SearchResultStored sr : srs) {
            String taskInstanceId = sr.getTaskInstanceId();
            Optional tiOpt = this.taskManager.getTaskInstanceFromId(taskInstanceId);
            if (!tiOpt.isPresent()) continue;
            ServerUIDetails uidetails = this.getUIDetails(deviceId, ResultStatus.QUARANTINED);
            Object url = uidetails.getIndividualReportsUrl();
            url = "<a href=" + (String)url + ">Click Here To View Device Report</a>";
            String filename = Paths.get(filePath, new String[0]).getFileName().toString();
            Notification n = new Notification("Request to revert file", "Please revert file " + filename + "<br/>On " + reg.getDeviceDescription() + "<br/>Found by " + ((TaskInstance)tiOpt.get()).getDisplayName() + "<br/>" + (String)url, NotificationType.INFO);
            NotificationEvent ev = NotificationEvent.createForUserAndAllAdmins((String)((TaskInstance)tiOpt.get()).getCreatedBy(), (Notification)n);
            MessageBus.getBus().post((Object)ev);
        }
        return true;
    }

    public synchronized void updateResult(QuarantineResult result) {
        boolean alldone = false;
        List<Object> srs = new ArrayList<SearchResultStored>();
        if (result.getSearchResultId() > 0L) {
            Optional opt = this.resultsManager.getResultById(result.getSearchResultId());
            if (opt.isPresent()) {
                srs.add((SearchResultStored)opt.get());
            }
            for (SearchResultStored sr : srs) {
                this.inFlight.doneInFlightQuarantine(sr, result);
                if (!this.inFlight.allJobsCompleteForQuarantine(sr.getTaskInstanceId())) continue;
                alldone = true;
            }
        } else {
            alldone = true;
            srs = this.resultsManager.getResultsForDeviceAndFilePath(result.getDeviceId(), result.getFilePath(), BaseResult.searchAndRealtimeTypes());
        }
        if (result.isSuccess()) {
            if (result.getType().equals((Object)QuarantineResult.TYPE.QUARANTINED)) {
                this.markResultsInQuarantine(result, srs, alldone);
            }
            if (result.getType().equals((Object)QuarantineResult.TYPE.DELETED)) {
                this.markResultsDeleted(result, srs, alldone);
            }
            if (result.getType().equals((Object)QuarantineResult.TYPE.REVERTED)) {
                this.markResultReverted(result, srs, alldone);
            }
        }
        this.auditLog.quarantineEvent(this.taskManager, result);
        MessageBus.getBus().post((Object)new QuarantineJobDoneEvent(result));
    }

    private void markResultsInQuarantine(QuarantineResult result, List<SearchResultStored> srs, boolean alldone) {
        for (SearchResultStored sr : srs) {
            sr.setQuarantined(true);
            sr.setQuarantinePath(result.getQuarantinePath());
            sr.setQuarantined(true);
            this.matchesManager.setStatus(sr, ResultStatus.QUARANTINED, ResultStatusReason.NONE, "");
            this.resultsManager.update(sr);
            this.eventHistoryStore.setStatus((ITaskManager)this.taskManager, sr, ResultStatus.QUARANTINED, ResultStatusReason.NONE, "");
        }
        String deviceId = result.getDeviceId();
        ServerUIDetails uidetails = this.getUIDetails(deviceId, ResultStatus.QUARANTINED);
        String title = BrandingStrings.PRODUCT_NAME + " Quarantine";
        String body = result.getFilePath() + " has been quarantined";
        this.alertEndpoint(deviceId, title, body, uidetails, alldone, result.getGroupName());
    }

    private void markResultsDeleted(QuarantineResult result, List<SearchResultStored> srs, boolean alldone) {
        for (SearchResultStored sr : srs) {
            sr.setQuarantined(false);
            sr.setQuarantinePath("#DELETED#");
            sr.setQuarantined(false);
            this.matchesManager.setStatus(sr, ResultStatus.CONFIRMED_RESOLVED, ResultStatusReason.DELETED_FROM_QUARANTINE, "");
            this.resultsManager.update(sr);
            this.eventHistoryStore.setStatus((ITaskManager)this.taskManager, sr, ResultStatus.CONFIRMED_RESOLVED, ResultStatusReason.DELETED_FROM_QUARANTINE, "");
        }
        String deviceId = result.getDeviceId();
        ServerUIDetails uidetails = this.getUIDetails(deviceId, ResultStatus.QUARANTINED);
        String title = BrandingStrings.PRODUCT_NAME + " Quarantine";
        String body = result.getFilePath() + " has been deleted from quarantine";
        this.alertEndpoint(deviceId, title, body, uidetails, alldone, result.getGroupName());
    }

    private void markResultReverted(QuarantineResult result, List<SearchResultStored> srs, boolean alldone) {
        for (SearchResultStored sr : srs) {
            sr.setQuarantined(false);
            sr.setQuarantinePath("");
            sr.setQuarantined(false);
            this.matchesManager.setStatus(sr, ResultStatus.CONFIRMED_RESOLVED, ResultStatusReason.REVERTED_FROM_QUARANTINE, "");
            this.resultsManager.update(sr);
            this.eventHistoryStore.setStatus((ITaskManager)this.taskManager, sr, ResultStatus.CONFIRMED_RESOLVED, ResultStatusReason.REVERTED_FROM_QUARANTINE, "");
        }
        String deviceId = result.getDeviceId();
        ServerUIDetails uidetails = this.getUIDetails(deviceId, ResultStatus.CONFIRMED_RESOLVED);
        String title = BrandingStrings.PRODUCT_NAME + " Quarantine";
        String body = result.getFilePath() + " has been released from quarantine";
        this.alertEndpoint(deviceId, title, body, uidetails, alldone, result.getGroupName());
    }

    private void addToMessages(String groupname, String msg) {
        if (groupname.isEmpty()) {
            LOG.warning("Empty groupname in addMessage?");
            return;
        }
        if (!this.messages.containsKey(groupname)) {
            this.messages.put(groupname, new ArrayList());
        }
        ((List)this.messages.get(groupname)).add(msg);
    }

    private String getMessages(String groupname, String lastMsg) {
        if (groupname.isEmpty()) {
            return lastMsg;
        }
        if (!this.messages.containsKey(groupname)) {
            return lastMsg;
        }
        List parts = (List)this.messages.get(groupname);
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(part).append("\n");
        }
        builder.append(lastMsg);
        this.messages.remove(groupname);
        return builder.toString();
    }

    private void alertEndpoint(String deviceId, String title, String body, ServerUIDetails uidetails, boolean alldone, String groupname) {
        AlertServerMessage msg;
        ConfiguredAlertMethods alertingMethods = this.alertingController.getConfigSettings();
        if (alertingMethods.hasAnyEmail()) {
            if (alldone) {
                ConfiguredAlertMethods justEmail = this.alertingController.getConfigSettings();
                justEmail.setAlertByPopup(false);
                msg = new AlertServerMessage(justEmail, new AlertMsg(title, this.getMessages(groupname, body)), uidetails);
                this.alertingController.alertEndpoint(deviceId, msg);
            } else {
                this.addToMessages(groupname, body);
            }
        }
        if (alertingMethods.isAlertByPopup()) {
            ConfiguredAlertMethods justEndpoint = new ConfiguredAlertMethods();
            justEndpoint.setAlertByPopup(true);
            msg = new AlertServerMessage(justEndpoint, new AlertMsg(title, body), uidetails);
            this.alertingController.alertEndpoint(deviceId, msg);
        }
    }

    private ServerUIDetails getUIDetails(String deviceId, ResultStatus rs) {
        ArrayList<ResultStatus> status = new ArrayList<ResultStatus>();
        status.add(rs);
        ServerUIDetails uidetails = ProxySettings.getUIDetails(null);
        return new ServerUIDetails(uidetails, deviceId, status);
    }

    private List<String> getTaskIdsForBulkQuarantined(String taskId) {
        List<String> taskIds = new ArrayList<String>();
        if (taskId != null && !taskId.isEmpty()) {
            TaskTemplate tt = this.taskManager.getTemplateFromId(taskId);
            if (tt == null) {
                tt = this.taskManager.getRealTimeProtectTemplate();
                List rtInstances = tt.getInstanceIds();
                if (rtInstances.contains(taskId)) {
                    taskIds = Collections.singletonList(taskId);
                }
            } else if (tt.getCommandType().equals((Object)BaseCommand.CommandType.UNIFIED_SEARCH)) {
                taskIds = this.taskManager.getLatestUnifiedSearchTasksWithPartial(taskId);
            }
        }
        return taskIds;
    }

    public QuarantinedResultsPage getPageOfQuarantineResults(QuarantinedDataSliceRequest req) {
        QuarantinedResultsPage ret = new QuarantinedResultsPage();
        List taskIds = this.getTaskIdsForBulkQuarantined(req.getTaskTemplateId());
        if (taskIds.isEmpty()) {
            ret.fail("no tasks found ");
            return ret;
        }
        String filter = req.getFilter() == null ? null : req.getFilter();
        PageRequest pageable = PageRequest.of((int)req.getPage(), (int)req.getSize());
        Page srs = this.resultsManager.getPagedResultsIdForDeviceAndTaskIds(req.getDeviceId(), taskIds, filter, req.isShowQuarantined(), (Pageable)pageable);
        ret.setPageParts(srs);
        for (DTOResultIdAndPath dto : srs.toList()) {
            QuarantinedDataPoint dp = new QuarantinedDataPoint(dto);
            if (this.inFlight.hasInFlightQuarantine(dto.getId(), dto.getTaskId())) {
                dp.setHasInFlight(true);
            }
            ret.getData().add(dp);
        }
        return ret;
    }

    public InFlightName runBulkActions(String name, QuarantineBulkCommand com) {
        String deviceId = com.getDeviceId();
        Optional regOpt = this.endpointService.getDeviceFromId(deviceId, false);
        if (regOpt.isEmpty()) {
            LOG.log(Level.WARNING, "device not found for quarantine action {0}", deviceId);
            return null;
        }
        QuarantineAction act = com.getAction();
        int count = this.counter.getAndIncrement();
        InFlightName groupName = switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$QuarantineAction[act.ordinal()]) {
            case 1 -> new InFlightName(count + ": Delete Quarantined files on " + ((DeviceRegistration)regOpt.get()).hostNameOrCloudHost());
            case 2 -> new InFlightName(count + ": Quarantine files on " + ((DeviceRegistration)regOpt.get()).hostNameOrCloudHost());
            case 3 -> new InFlightName(count + ": Revert Quarantined files on " + ((DeviceRegistration)regOpt.get()).hostNameOrCloudHost());
            default -> null;
        };
        ArrayList<TaskInstance> instances = new ArrayList<TaskInstance>();
        for (QuarantinedDataPoint dp : com.getDatapoints()) {
            Optional srOpt = this.resultsManager.getResult(dp.getSearchResultId());
            if (srOpt.isEmpty()) {
                LOG.log(Level.WARNING, "no search result for quarantine action? {0}", dp.getSearchResultId());
                return null;
            }
            TaskInstance inst = this.actionsCreator.createQuarantineTask(name, dp.getTaskId(), act, dp.getFilePath(), dp.getQuarantinedPath(), groupName.getName(), dp.getSearchResultId());
            instances.add(inst);
            this.inFlight.addInFlightQuarantine(groupName, (SearchResultStored)srOpt.get());
        }
        List chunks = Lists.partition(instances, (int)10);
        for (List chunk : chunks) {
            this.jobRunner.runMultipleTasksOnDevice((DeviceRegistration)regOpt.get(), this.taskManager.getPerformActionsTemplate(), chunk);
        }
        return groupName;
    }

    public List<DeviceWithActionableTasks> getActionableDevices() {
        ArrayList<DeviceWithActionableTasks> ret = new ArrayList<DeviceWithActionableTasks>();
        List devices = this.deviceService.getDevicesOfTypes(DeviceType.getEndpointAndFileserverTypes());
        for (DeviceRegistration dr : devices) {
            ArrayList<SmallDetails> search = new ArrayList<SmallDetails>();
            ArrayList<SmallDetails> rt = new ArrayList<SmallDetails>();
            List tasks = this.taskManager.getLatestInstancesSearchAndRealtimeForDeviceWithPartial(dr.getDeviceId());
            for (String instanceId : tasks) {
                TaskInstance ti;
                Optional routeable;
                Optional tiOpt = this.taskManager.getTaskInstanceFromId(instanceId);
                if (!tiOpt.isPresent() || !(routeable = (ti = (TaskInstance)tiOpt.get()).getCommand().getRoutableConfig()).isPresent() || !((IRouteableSearchConfig)routeable.get()).hasAnyEndpointSearch()) continue;
                if (ti.getCommandType().equals((Object)BaseCommand.CommandType.PROTECT)) {
                    rt.add(new SmallDetails(ti.getUid(), ti.getDisplayName(), ti.getCreated(), "", false));
                    continue;
                }
                TaskTemplate templ = this.taskManager.getTemplateFromId(ti.getParentTemplateId());
                search.add(new SmallDetails(templ.getUid(), templ.getDisplayName(), templ.getCreated(), "", false));
            }
            if (search.isEmpty() && rt.isEmpty()) continue;
            DeviceWithActionableTasks dat = new DeviceWithActionableTasks();
            dat.setDeviceId(dr.getDeviceId());
            dat.setDeviceName(dr.hostNameOrCloudHost());
            dat.setRtTasks(rt);
            dat.setSearchTasks(search);
            ret.add(dat);
        }
        Collections.sort(ret);
        return ret;
    }
}

