/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks.actions;

import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.ConfirmCommand;
import com.geolang.ascema.endpointcommon.domain.DeferredTime;
import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.actions.ActionCollection;
import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionVerb;
import com.geolang.ascema.endpointcommon.domain.actions.command.DeferredActionCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.actions.InFlightAndDeferredActionsCollection;
import com.geolang.ascema.managerdomain.actions.InFlightName;
import com.geolang.ascema.managerdomain.domain.DeferredAction;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.MatchStored;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.WebHostAndPath;
import com.geolang.ascema.managerdomain.web.actions.ActionableDataPoint;
import com.geolang.ascema.managerdomain.web.actions.BulkActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.DeferredBulkActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.DeferredHostAndPathActionsCommand;
import com.geolang.ascema.managerpersistence.DeferredActionStore;
import com.geolang.ascema.managerpersistence.DeferredActionSummary;
import com.geolang.ascema.managerpersistence.EventHistoryStore;
import com.geolang.ascema.managerpersistence.StoredResultStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.actions.ActionsController;
import com.geolang.ascema.managerservice.controllers.tasks.actions.DeferredActionsController;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeferredActionsController {
    private static final Logger LOG = Logger.getLogger(DeferredActionsController.class.getName());
    private static final int MAX_TIMES_WE_ALLOW_TASK_ALREADY_RUNNING = 5;
    @Autowired
    private EventHistoryStore eventHistoryStore;
    @Autowired
    @Lazy
    private StoredResultStore resultsStore;
    @Autowired
    private TaskStore taskStore;
    @Autowired
    JobRunner jobRunner;
    @Autowired
    DeviceService deviceService;
    @Autowired
    private DeferredActionStore deferredActionstore;
    @Autowired
    private InFlightAndDeferredActionsCollection inFlight;
    @Autowired
    private PatternService patternService;

    public void update(DeferredAction da) {
        this.deferredActionstore.update(da);
    }

    public Optional<DeferredAction> getById(Long deferredId) {
        return this.deferredActionstore.getById(deferredId);
    }

    public void remove(DeferredAction da) {
        this.deferredActionstore.remove(da);
    }

    public long deleteDeferredActionsForTask(TaskInstance instance) {
        String groupName = this.generateGroupNameForInstance(instance);
        return this.deferredActionstore.removeByGroupname(groupName);
    }

    @Transactional
    public void createDeferredActionsFromResult(SearchResultStored sr) {
        Optional taskOpt = this.taskStore.getTaskInstanceFromId(sr.getTaskInstanceId());
        if (taskOpt.isEmpty()) {
            LOG.log(Level.WARNING, "No task instance? {0}", sr.getTaskInstanceId());
            return;
        }
        TaskInstance instance = (TaskInstance)taskOpt.get();
        if (!instance.getCommand().hasDeferredActions()) {
            return;
        }
        Optional opt = instance.getCommand().getCommonFilter();
        if (opt.isEmpty()) {
            LOG.log(Level.WARNING, "no config in instance?? {0}", instance.getDisplayName());
            return;
        }
        ActionCollection actions = ((SearchFilterCommon)opt.get()).getActions();
        if (actions.hasActions(sr.getNamedArea())) {
            String groupname = this.generateGroupNameForInstance(instance);
            DeferredTime defTime = actions.getDeferredTime();
            if (null != defTime) {
                Date when = defTime.toDateDueFromNow();
                DeferredHostAndPathActionsCommand com = new DeferredHostAndPathActionsCommand();
                com.setHostAndPath(new WebHostAndPath(sr.getDeviceName(), sr.getFilePath()));
                com.setIsPerform(true);
                com.setTimeValue(defTime.getValue());
                com.setUnit(defTime.getUnit());
                DeferredAction da = new DeferredAction(sr, when, ActionVerb.PERFORM_DEFERED, instance.getCreatedBy(), com.encodeToString(), groupname);
                this.deferredActionstore.save(da);
                LOG.log(Level.INFO, "created deferred action for {0} due {1}", new Object[]{sr.getFilePath(), when});
            }
        }
    }

    @Transactional
    public boolean createDeferredBulkActions(String name, DeferredBulkActionsCommand command) {
        Map taskToActionIds;
        if (command.isSelectAll()) {
            taskToActionIds = ActionsController.getActionIdsFromTaskId((BulkActionsCommand)command, (TaskStore)this.taskStore, (StoredResultStore)this.resultsStore);
        } else {
            taskToActionIds = new HashMap();
            for (ActionableDataPoint dp : command.getDatapoints()) {
                if (!taskToActionIds.containsKey(dp.getTaskId())) {
                    taskToActionIds.put(dp.getTaskId(), new HashSet());
                }
                ((Set)taskToActionIds.get(dp.getTaskId())).add(dp.getActionableId());
            }
        }
        for (String taskId : taskToActionIds.keySet()) {
            for (String actId : (Set)taskToActionIds.get(taskId)) {
                Optional optTask = this.taskStore.getTaskInstanceFromId(taskId);
                if (!optTask.isPresent()) continue;
                for (SearchResultStored sr : this.resultsStore.getResultsForActionableIdAndTaskId(actId, taskId)) {
                    TaskInstance task = (TaskInstance)optTask.get();
                    BaseCommand bcom = task.getCommand();
                    Optional opt = bcom.getCommonFilter();
                    if (opt.isEmpty()) {
                        LOG.log(Level.WARNING, "in runHostAndPathActions -no config in instance {0}", task.getDisplayName());
                        continue;
                    }
                    ActionCollection actions = ((SearchFilterCommon)opt.get()).getActions();
                    String groupname = this.generateGroupNameForInstance(task);
                    if (!actions.hasActions(sr.getNamedArea())) continue;
                    DeferredTime defTime = new DeferredTime(command.getUnit(), command.getTimeValue());
                    Date when = defTime.toDateDueFromNow();
                    DeferredHostAndPathActionsCommand com = new DeferredHostAndPathActionsCommand();
                    com.setHostAndPath(new WebHostAndPath(sr.getDeviceName(), sr.getFilePath()));
                    com.setIsPerform(command.isIsPerform());
                    com.setTimeValue(defTime.getValue());
                    com.setUnit(defTime.getUnit());
                    ActionVerb method = com.isIsPerform() ? ActionVerb.PERFORM_DEFERED : ActionVerb.UNDO_DEFERED;
                    DeferredAction da = new DeferredAction(sr, when, method, task.getCreatedBy(), com.encodeToString(), groupname);
                    this.deferredActionstore.save(da);
                    LOG.log(Level.INFO, "created deferred action for {0} due {1}", new Object[]{sr.getFilePath(), when});
                }
            }
        }
        return true;
    }

    public Iterable<DeferredAction> getAllDeferredActions() {
        return this.deferredActionstore.getAll();
    }

    public List<DeferredActionSummary> getAllDeferredActionSummary() {
        return this.deferredActionstore.getAllSummaries();
    }

    public boolean deleteDeferred(String name, Long id) {
        LOG.log(Level.INFO, "delete deferred action {0} by {1}", new Object[]{id, name});
        Optional opt = this.deferredActionstore.getById(id);
        if (opt.isPresent()) {
            this.deferredActionstore.remove((DeferredAction)opt.get());
            return true;
        }
        return false;
    }

    public Iterable<DeferredAction> getAllDeferredActionsFromName(String name) {
        return this.deferredActionstore.getAllFromGroupName(name);
    }

    public long deleteDeferredByName(String principle, String name) {
        LOG.log(Level.INFO, "delete deferred actions with groupname {0} by {1}", new Object[]{name, principle});
        return this.deferredActionstore.removeByGroupname(name);
    }

    @Transactional
    public boolean runMultipleDeferredActions(List<DeferredAction> actions) {
        HashMap groupedActions = new HashMap();
        for (DeferredAction deferredAction : actions) {
            if (!groupedActions.containsKey(deferredAction.getGroupname())) {
                groupedActions.put(deferredAction.getGroupname(), new ArrayList());
            }
            ((List)groupedActions.get(deferredAction.getGroupname())).add(deferredAction);
        }
        for (Map.Entry entry : groupedActions.entrySet()) {
            InFlightName name = new InFlightName((String)entry.getKey());
            HashMap deviceIdToAction = new HashMap();
            for (DeferredAction deferredAction : (List)entry.getValue()) {
                Optional srOpt;
                int countOfTimesWeHaveAsked = this.inFlight.getDeferredActionCounter().hasDeferredActionRunning(deferredAction.getId());
                if (countOfTimesWeHaveAsked > 0) {
                    LOG.log(Level.INFO, "Deferred action seems to be still running {0} count is {1}", new Object[]{deferredAction.getDisplayPath(), countOfTimesWeHaveAsked});
                    if (countOfTimesWeHaveAsked < 5) {
                        LOG.info("Skipping this time");
                        continue;
                    }
                    LOG.info("Seen this too many times - assume that the task never returned and run again");
                    this.inFlight.getDeferredActionCounter().doneDeferredAction(deferredAction.getId());
                }
                if ((srOpt = this.resultsStore.getResult(deferredAction.getSearchResultStoredId())).isEmpty()) {
                    LOG.log(Level.WARNING, "no result to apply deferred action {0}", deferredAction.getSearchResultStoredId());
                    continue;
                }
                SearchResultStored sr = (SearchResultStored)srOpt.get();
                if (deviceIdToAction.containsKey(sr.getDeviceId())) {
                    ((List)deviceIdToAction.get(sr.getDeviceId())).add(new DeferredActionSearchResultPair(deferredAction, sr));
                    continue;
                }
                ArrayList<DeferredActionSearchResultPair> pairs = new ArrayList<DeferredActionSearchResultPair>();
                pairs.add(new DeferredActionSearchResultPair(deferredAction, sr));
                deviceIdToAction.put(sr.getDeviceId(), pairs);
            }
            for (Map.Entry entry2 : deviceIdToAction.entrySet()) {
                String deviceId = (String)entry2.getKey();
                Optional regOpt = this.deviceService.getDeviceFromId(deviceId, false);
                if (regOpt.isPresent()) {
                    List toRun = this.createDeferredActionTasks((List)entry2.getValue(), name);
                    this.runDeferredBatch((DeviceRegistration)regOpt.get(), toRun);
                    continue;
                }
                LOG.log(Level.WARNING, "no device found for id {0}", deviceId);
            }
        }
        return true;
    }

    private List<TaskInstance> createDeferredActionTasks(List<DeferredActionSearchResultPair> pairs, InFlightName name) {
        ArrayList<TaskInstance> ret = new ArrayList<TaskInstance>();
        for (DeferredActionSearchResultPair pair : pairs) {
            Optional ti;
            SearchResultStored sr = pair.searchResult();
            DeferredAction act = pair.action();
            List allmatches = this.resultsStore.getMatchesForResult(act.getSearchResultStoredId());
            Optional instOpt = this.taskStore.getTaskInstanceFromId(sr.getTaskInstanceId());
            if (instOpt.isEmpty()) {
                LOG.log(Level.WARNING, "no instance to apply deferred action {0}", sr.getTaskInstanceId());
            }
            TaskInstance inst = (TaskInstance)instOpt.get();
            BaseCommand com = inst.getCommand();
            ArrayList<MatchStored> matches = new ArrayList<MatchStored>();
            boolean isPerform = act.getMethod().equals((Object)ActionVerb.PERFORM_DEFERED);
            if (isPerform) {
                for (MatchStored ms : allmatches) {
                    ResultStatus status = ms.getStatus();
                    if (!status.equals((Object)ResultStatus.FOUND) && !status.equals((Object)ResultStatus.ALERTED)) continue;
                    matches.add(ms);
                }
            } else {
                matches.addAll(allmatches);
            }
            if (matches.isEmpty()) {
                LOG.log(Level.INFO, "Nothing to perform in runDeferredAction - all matches resolved for {0}", sr.getFilePath());
                this.deferredActionstore.remove(act);
                continue;
            }
            Optional commonOpt = com.getCommonFilter();
            if (!commonOpt.isPresent()) continue;
            ActionCollection actions = ((SearchFilterCommon)commonOpt.get()).getActions();
            ConfirmCommand confirm = new ConfirmCommand(inst.getUid(), new String[0], sr.getDeviceId(), this.patternService.expandPatternMatches(matches), sr.getFilePath(), sr.getSubPath(), sr.getConfirmPath(), sr.getNamedArea());
            if (!actions.hasActions(sr.getNamedArea()) || !(ti = this.createDeferredTask(act, sr, confirm, actions, name)).isPresent()) continue;
            ret.add((TaskInstance)ti.get());
        }
        return ret;
    }

    private Optional<TaskInstance> createDeferredTask(DeferredAction act, SearchResultStored sr, ConfirmCommand confirm, ActionCollection actions, InFlightName name) {
        boolean isPerform = act.getMethod().equals((Object)ActionVerb.PERFORM_DEFERED);
        if (isPerform) {
            this.eventHistoryStore.addActions(sr, actions.getActionsForArea(sr.getNamedArea()));
        } else {
            this.eventHistoryStore.addUndo(sr, actions.getActionsForArea(sr.getNamedArea()));
        }
        ActionIgnorePaths ignorePaths = null;
        String origTaskTemplId = "";
        Optional origInst = this.taskStore.getTaskInstanceFromId(sr.getTaskInstanceId());
        if (origInst.isPresent()) {
            origTaskTemplId = ((TaskInstance)origInst.get()).getTaskIdForActions();
            ignorePaths = ((TaskInstance)origInst.get()).getIgnorePaths();
        }
        DeferredActionCommand defCom = new DeferredActionCommand(sr.toActionData(), actions, confirm, act.getId(), act.getMethod(), origTaskTemplId, Collections.singletonList(sr.getId()), sr.getDeviceId());
        return this.createDeferredTaskForBatching(act.getId(), sr, ignorePaths, act.getCreatedBy(), (BaseCommand)defCom, name);
    }

    private Optional<TaskInstance> createDeferredTaskForBatching(Long deferredId, SearchResultStored sr, ActionIgnorePaths ignorePaths, String userName, BaseCommand actcom, InFlightName inFlightName) {
        TaskTemplate templ = this.taskStore.getDeferredActionsTemplate();
        TaskInstance plan = TaskInstance.createTransientTask((ActionIgnorePaths)ignorePaths, (String)userName, (BaseCommand)actcom, (String)inFlightName.getName(), (JobPriority)JobPriority.MEDIUM, (TaskTemplate)templ);
        Optional regOpt = this.deviceService.getDeviceFromId(sr.getDeviceId(), false);
        if (regOpt.isEmpty()) {
            LOG.log(Level.WARNING, "no device to create deferred task {0}", sr.getDeviceName());
            return Optional.empty();
        }
        this.inFlight.addInFlight(inFlightName, sr);
        this.inFlight.getDeferredActionCounter().startDeferredAction(deferredId);
        return Optional.of(plan);
    }

    private boolean runDeferredBatch(DeviceRegistration dev, List<TaskInstance> instances) {
        TaskTemplate templ = this.taskStore.getDeferredActionsTemplate();
        List chunks = Lists.partition(instances, (int)10);
        for (List chunk : chunks) {
            this.jobRunner.runMultipleTasksOnDevice(dev, templ, chunk);
        }
        return true;
    }

    private String generateGroupNameForInstance(TaskInstance instance) {
        return "From Task Instance " + instance.getDisplayName();
    }

    private boolean shouldIgnore(String taskId, String host, SearchResultStored sr) {
        ActionIgnorePaths ignorePaths;
        Optional origInst = this.taskStore.getTaskInstanceFromId(taskId);
        if (origInst.isPresent() && (ignorePaths = ((TaskInstance)origInst.get()).getIgnorePaths()) != null) {
            return ignorePaths.isIgnore(host, sr.getFilePath());
        }
        return false;
    }
}

