/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks.actions;

import com.geolang.ascema.managerpersistence.DeferredActionStore;
import com.geolang.ascema.managerservice.controllers.tasks.actions.DeferredActionsController;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class DeferredActionScheduler {
    private static final Logger LOG = Logger.getLogger(DeferredActionScheduler.class.getName());
    @Autowired
    private DeferredActionStore store;
    @Autowired
    @Qualifier(value="transactionManager")
    protected PlatformTransactionManager txManager;
    @Autowired
    private DeferredActionsController actionRunner;
    private final Object mutex = new Object();

    @Scheduled(cron="0 */5 * * * ?")
    void process() {
        TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
        tmpl.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeferredActions() {
        Object object = this.mutex;
        synchronized (object) {
            List due = this.store.getDue();
            if (due.isEmpty()) {
                LOG.log(Level.FINE, "no deferred actions due");
            } else {
                LOG.log(Level.INFO, "{0} deferred actions due", due.size());
                this.actionRunner.runMultipleDeferredActions(due);
            }
        }
    }
}

