/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks.actions;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.QuarantineAction;
import com.geolang.ascema.endpointcommon.domain.QuarantineCommand;
import com.geolang.ascema.endpointcommon.domain.actions.ActionCollection;
import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionVerb;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionsCommand;
import com.geolang.ascema.managerdomain.actions.TaskAndSrs;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerpersistence.EventHistoryStore;
import com.geolang.ascema.managerpersistence.StoredResultStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ActionsTaskCreator {
    private static final Logger LOG = Logger.getLogger(ActionsTaskCreator.class.getName());
    @Autowired
    private EventHistoryStore eventHistoryStore;
    @Autowired
    @Lazy
    private StoredResultStore resultsStore;
    @Autowired
    private TaskStore taskStore;
    private TaskTemplate performActionsTemplate;

    @PostConstruct
    public void init() {
        this.performActionsTemplate = this.taskStore.getPerformActionsTemplate();
    }

    public List<TaskAndSrs> createSimpleActions(DeviceType deviceType, boolean isPerform, String createdBy, String instanceId, JobPriority priority, String deviceId, String[] paths, ActionCollection actions) {
        String taskName;
        ActionVerb method;
        if (isPerform) {
            method = ActionVerb.PERFORM;
            taskName = "perform action for" + deviceType.getDisplayName() + LocalDateTime.now().toString();
        } else {
            method = ActionVerb.UNDO;
            taskName = "undo action for " + deviceType.getDisplayName() + LocalDateTime.now().toString();
        }
        String origTaskTemplId = "";
        ActionIgnorePaths ignorePaths = null;
        Optional origInst = this.taskStore.getTaskInstanceFromId(instanceId);
        if (origInst.isPresent()) {
            origTaskTemplId = ((TaskInstance)origInst.get()).getTaskIdForActions();
            ignorePaths = ((TaskInstance)origInst.get()).getIgnorePaths();
        }
        ArrayList<TaskAndSrs> ret = new ArrayList<TaskAndSrs>();
        for (String fp : paths) {
            List list = this.resultsStore.getResultsForTaskInstanceAndDeviceAndFile(instanceId, deviceId, fp);
            if (!list.isEmpty()) {
                for (SearchResultStored srs : list) {
                    if (isPerform) {
                        this.eventHistoryStore.addActions(srs, actions.getActionsForArea(srs.getNamedArea()));
                    } else {
                        this.eventHistoryStore.addUndo(srs, actions.getActionsForArea(srs.getNamedArea()));
                    }
                    ActionsCommand com = new ActionsCommand(srs.toActionData(), actions, method, origTaskTemplId, Collections.singletonList(srs.getId()), deviceId);
                    TaskInstance plan = TaskInstance.createTransientTask((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)com, (String)taskName, (JobPriority)JobPriority.MEDIUM, (TaskTemplate)this.performActionsTemplate);
                    ret.add(new TaskAndSrs(plan, srs));
                }
                continue;
            }
            LOG.log(Level.WARNING, "No result found for action  {0}", fp);
        }
        return ret;
    }

    public TaskInstance createQuarantineTask(String createdBy, String origTaskId, QuarantineAction action, String filePath, String qPath, String groupName, Long searchResultId) {
        ActionIgnorePaths ignorePaths = null;
        QuarantineCommand com = new QuarantineCommand(searchResultId, action, filePath, qPath, groupName);
        Optional origInst = this.taskStore.getTaskInstanceFromId(origTaskId);
        if (origInst.isPresent()) {
            ignorePaths = ((TaskInstance)origInst.get()).getIgnorePaths();
        }
        return TaskInstance.createTransientTask((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)com, (String)(action.name() + Instant.now().toString()), (JobPriority)JobPriority.MEDIUM, (TaskTemplate)this.performActionsTemplate);
    }

    public TaskInstance createActionsTask(boolean isPerform, String name, List<SearchResultStored> srs, ActionCollection actions) {
        String taskName;
        ActionVerb actionMethod;
        if (srs.isEmpty()) {
            LOG.warning("no search results in createActionTasks");
            return null;
        }
        SearchResultStored sr = srs.get(0);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (isPerform) {
            actionMethod = ActionVerb.PERFORM;
            taskName = "perform action " + LocalDateTime.now().toString();
            for (SearchResultStored a : srs) {
                ids.add(a.getId());
                this.eventHistoryStore.addActions(a, actions.getActionsForArea(a.getNamedArea()));
            }
        } else {
            actionMethod = ActionVerb.UNDO;
            taskName = "undo action " + LocalDateTime.now().toString();
            for (SearchResultStored a : srs) {
                ids.add(a.getId());
                this.eventHistoryStore.addUndo(a, actions.getActionsForArea(a.getNamedArea()));
            }
        }
        ActionIgnorePaths ignorePaths = null;
        String origTaskTemplId = "";
        Optional origInst = this.taskStore.getTaskInstanceFromId(sr.getTaskInstanceId());
        if (origInst.isPresent()) {
            origTaskTemplId = ((TaskInstance)origInst.get()).getTaskIdForActions();
            ignorePaths = ((TaskInstance)origInst.get()).getIgnorePaths();
        }
        ActionsCommand actcom = new ActionsCommand(sr.toActionData(), actions, actionMethod, origTaskTemplId, ids, sr.getDeviceId());
        return TaskInstance.createTransientTask((ActionIgnorePaths)ignorePaths, (String)name, (BaseCommand)actcom, (String)taskName, (JobPriority)JobPriority.MEDIUM, (TaskTemplate)this.performActionsTemplate);
    }
}

