/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks.actions;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.actions.ActionCollection;
import com.geolang.ascema.endpointcommon.domain.searchconfig.IRouteableSearchConfig;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.actions.InFlightAndDeferredActionsCollection;
import com.geolang.ascema.managerdomain.actions.InFlightName;
import com.geolang.ascema.managerdomain.actions.TaskAndSrs;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerdomain.web.actions.ActionableDataPoint;
import com.geolang.ascema.managerdomain.web.actions.ActionableDataPointDetails;
import com.geolang.ascema.managerdomain.web.actions.ActionableResultsDataSliceRequest;
import com.geolang.ascema.managerdomain.web.actions.ActionableResultsPage;
import com.geolang.ascema.managerdomain.web.actions.BulkActionsCommand;
import com.geolang.ascema.managerdomain.web.actions.DeviceWithActionableTasks;
import com.geolang.ascema.managerdomain.web.actions.SimpleActionsCommand;
import com.geolang.ascema.managerpersistence.StoredResultStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerpersistence.tasks.LatestTaskInstanceCollection;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.actions.ActionsTaskCreator;
import com.google.common.collect.Lists;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ActionsController {
    private static final Logger LOG = Logger.getLogger(ActionsController.class.getName());
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    @Lazy
    private StoredResultStore resultsStore;
    @Autowired
    private ActionsTaskCreator actionsCreator;
    @Autowired
    private InFlightAndDeferredActionsCollection inFlight;
    @Autowired
    private JobRunner jobRunner;
    private TaskTemplate performActionsTemplate;

    @PostConstruct
    public void init() {
        this.performActionsTemplate = this.taskStore.getPerformActionsTemplate();
    }

    @Transactional
    public void runAutomaticUndo(String user, SearchResultStored sr, TaskInstance inst) {
        BaseCommand com = inst.getCommand();
        Optional commonOpt = com.getCommonFilter();
        if (commonOpt.isEmpty()) {
            LOG.warning("No config in runAutomaticUndo");
            return;
        }
        ArrayList toRun = new ArrayList();
        ActionCollection actions = ((SearchFilterCommon)commonOpt.get()).getActions();
        if (actions.hasActions(sr.getNamedArea())) {
            String[] paths = new String[]{sr.getFilePath()};
            List tasks = this.actionsCreator.createSimpleActions(sr.getDeviceType(), false, user, inst.getUid(), JobPriority.MEDIUM, sr.getDeviceId(), paths, actions);
            toRun.addAll(tasks);
        }
        this.runBatch(sr.getDeviceId(), "Automatic Undo for " + inst.getDisplayName(), toRun);
    }

    @Transactional
    public List<String> runSimpleActions(String username, SimpleActionsCommand command) {
        Optional opt = this.taskStore.getTaskInstanceFromId(command.getInstanceId());
        if (opt.isEmpty()) {
            LOG.warning("no instance found to run actions");
            return null;
        }
        TaskInstance inst = (TaskInstance)opt.get();
        BaseCommand com = inst.getCommand();
        Optional commonOpt = com.getCommonFilter();
        if (commonOpt.isEmpty()) {
            LOG.warning("No config in runSimpleActions");
            return null;
        }
        Optional deviceOpt = this.deviceService.getDeviceFromId(command.getDeviceId(), false);
        if (deviceOpt.isEmpty()) {
            LOG.log(Level.WARNING, "in runSimpleActions - device not found {0}", command.getDeviceId());
            return null;
        }
        ActionCollection actions = ((SearchFilterCommon)commonOpt.get()).getActions();
        DeviceType deviceType = ((DeviceRegistration)deviceOpt.get()).getDeviceType();
        ArrayList toRun = new ArrayList();
        if (actions.hasActions(deviceType)) {
            List tasks = this.actionsCreator.createSimpleActions(deviceType, command.isIsPerform(), username, command.getInstanceId(), JobPriority.MEDIUM, command.getDeviceId(), command.getFilepaths(), actions);
            toRun.addAll(tasks);
        } else {
            LOG.log(Level.WARNING, "no actions configured in search task for devicetype{0}", ((DeviceRegistration)deviceOpt.get()).getDeviceType());
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (TaskAndSrs t : toRun) {
            ret.add(t.instance().getUid());
        }
        this.runBatch(((DeviceRegistration)deviceOpt.get()).getDeviceId(), "Instance " + inst.getDisplayName() + " on device " + ((DeviceRegistration)deviceOpt.get()).hostNameOrCloudHost(), toRun);
        return ret;
    }

    @Transactional
    public InFlightName runBulkActions(String name, BulkActionsCommand com) {
        Map taskToActionIds;
        if (com.isSelectAll()) {
            taskToActionIds = ActionsController.getActionIdsFromTaskId((BulkActionsCommand)com, (TaskStore)this.taskStore, (StoredResultStore)this.resultsStore);
        } else {
            taskToActionIds = new HashMap();
            for (ActionableDataPoint dp : com.getDatapoints()) {
                if (!taskToActionIds.containsKey(dp.getTaskId())) {
                    taskToActionIds.put(dp.getTaskId(), new HashSet());
                }
                ((Set)taskToActionIds.get(dp.getTaskId())).add(dp.getActionableId());
            }
        }
        String displayName = this.getTaskDisplayName(com.getTaskId());
        return this.performForBulkIds(displayName, com.getDeviceId(), name, taskToActionIds, com.isIsPerform());
    }

    public static Map<String, Set<String>> getActionIdsFromTaskId(BulkActionsCommand com, TaskStore taskStore, StoredResultStore resultsStore) {
        HashMap<String, Set<String>> toAct = new HashMap<String, Set<String>>();
        if (com.isSelectAll()) {
            List taskIds = ActionsController.getTaskIdsForBulkActions((String)com.getTaskId(), (TaskStore)taskStore);
            for (String taskId : taskIds) {
                Page actionableIds;
                PageRequest pageable = PageRequest.of((int)0, (int)100);
                do {
                    actionableIds = resultsStore.getUniqueActionableIds(taskId, com.getDeviceId(), com.getFilter(), !com.isIsPerform(), !com.isIsPerform(), (Pageable)pageable);
                    pageable = actionableIds.getPageable().next();
                    for (String actId : actionableIds.getContent()) {
                        if (!toAct.containsKey(taskId)) {
                            toAct.put(taskId, new HashSet());
                        }
                        ((Set)toAct.get(taskId)).add(actId);
                    }
                } while (actionableIds.hasContent());
            }
        }
        return toAct;
    }

    private String getTaskDisplayName(String taskId) {
        Optional opt;
        TaskTemplate tt = this.taskStore.getTemplateFromId(taskId);
        if (tt != null) {
            return tt.getDisplayName();
        }
        tt = this.taskStore.getRealTimeProtectTemplate();
        List rtInstances = tt.getInstanceIds();
        if (rtInstances.contains(taskId) && (opt = this.taskStore.getTaskInstanceFromId(taskId)).isPresent()) {
            return ((TaskInstance)opt.get()).getDisplayName();
        }
        return "Unknown";
    }

    static List<String> getTaskIdsForBulkActions(String taskId, TaskStore taskStore) {
        List<String> taskIds = new ArrayList<String>();
        if (taskId != null && !taskId.isEmpty()) {
            TaskTemplate tt = taskStore.getTemplateFromId(taskId);
            if (tt == null) {
                tt = taskStore.getRealTimeProtectTemplate();
                List rtInstances = tt.getInstanceIds();
                if (rtInstances.contains(taskId)) {
                    taskIds = Collections.singletonList(taskId);
                }
            } else if (tt.getCommandType().equals((Object)BaseCommand.CommandType.UNIFIED_SEARCH)) {
                taskIds = taskStore.getLatestInstances().getLatestSearchTasksWithPartial(taskId).stream().map(t -> t.getUid()).collect(Collectors.toList());
            }
        }
        return taskIds;
    }

    private InFlightName performForBulkIds(String taskDisplayName, String deviceId, String username, Map<String, Set<String>> taskToActionIds, boolean isPerform) {
        ArrayList<TaskAndSrs> toRun = new ArrayList<TaskAndSrs>();
        String deviceName = "";
        for (String taskId : taskToActionIds.keySet()) {
            Optional optTask = this.taskStore.getTaskInstanceFromId(taskId);
            if (!optTask.isPresent()) continue;
            for (String actId : taskToActionIds.get(taskId)) {
                List list = this.resultsStore.getResultsForActionableIdAndTaskId(actId, taskId);
                if (list.isEmpty()) continue;
                SearchResultStored srs = (SearchResultStored)list.get(0);
                deviceName = srs.getDeviceName();
                TaskInstance task = (TaskInstance)optTask.get();
                BaseCommand com = task.getCommand();
                Optional commonOpt = com.getCommonFilter();
                if (commonOpt.isEmpty()) {
                    LOG.warning("No config in performForActionIds");
                    continue;
                }
                ActionCollection actions = ((SearchFilterCommon)commonOpt.get()).getActions();
                if (!actions.hasActions(srs.getNamedArea())) continue;
                TaskInstance ti = this.actionsCreator.createActionsTask(isPerform, username, list, actions);
                toRun.add(new TaskAndSrs(ti, srs));
            }
        }
        String name = isPerform ? "Bulk Action for task " + taskDisplayName + " on " + deviceName : "Bulk Undo Action for task " + taskDisplayName + " on " + deviceName;
        return this.runBatch(deviceId, name, toRun);
    }

    private InFlightName runBatch(String deviceId, String name, List<TaskAndSrs> list) {
        InFlightName groupName = new InFlightName(name);
        HashMap byDevice = new HashMap();
        for (TaskAndSrs t : list) {
            String devId = t.searchResultStored().getDeviceId();
            if (!byDevice.containsKey(devId)) {
                byDevice.put(devId, new ArrayList());
            }
            ((List)byDevice.get(devId)).add(t);
        }
        Optional regOpt = this.deviceService.getDeviceFromId(deviceId, false);
        if (regOpt.isPresent()) {
            List tasksForDevice = (List)byDevice.get(deviceId);
            if (tasksForDevice != null) {
                List chunks = Lists.partition((List)tasksForDevice, (int)10);
                for (List chunk : chunks) {
                    for (TaskAndSrs ts : chunk) {
                        this.inFlight.addInFlight(groupName, ts.searchResultStored());
                    }
                    List instances = chunk.stream().map(c -> c.instance()).collect(Collectors.toList());
                    this.jobRunner.runMultipleTasksOnDevice((DeviceRegistration)regOpt.get(), this.performActionsTemplate, instances);
                }
            } else {
                LOG.log(Level.WARNING, "no tasks for device {0} Has the deviceId changed?", ((DeviceRegistration)regOpt.get()).deviceDescriptionOrCloudName());
            }
        }
        return groupName;
    }

    public ActionableResultsPage getPageOfActionableResults(ActionableResultsDataSliceRequest req) {
        ActionableResultsPage ret = new ActionableResultsPage();
        List taskIds = ActionsController.getTaskIdsForBulkActions((String)req.getTaskTemplateId(), (TaskStore)this.taskStore);
        if (taskIds.isEmpty()) {
            ret.fail("no tasks found ");
            return ret;
        }
        String filter = req.getFilter() == null ? null : req.getFilter();
        for (String taskId : taskIds) {
            Optional optTask = this.taskStore.getTaskInstanceFromId(taskId);
            if (!optTask.isPresent()) {
                ret.fail("No task found");
                return ret;
            }
            TaskInstance task = (TaskInstance)optTask.get();
            Optional optCommon = task.getCommand().getCommonFilter();
            if (!optCommon.isPresent()) {
                ret.fail("malformed task, not a search task or database corruption");
                return ret;
            }
            ActionCollection ac = ((SearchFilterCommon)optCommon.get()).getActions();
            if (!ac.hasActions()) continue;
            PageRequest pageable = PageRequest.of((int)req.getPage(), (int)req.getSize());
            Page actionableIds = this.resultsStore.getUniqueActionableIds(taskId, req.getDeviceId(), filter, req.isShowActioned(), req.isShowIgnored(), (Pageable)pageable);
            ret.setPageParts(actionableIds);
            for (String actId : actionableIds.toList()) {
                List searchResults = this.resultsStore.getResultsForTaskInstanceAndDeviceAndActionableId(taskId, req.getDeviceId(), actId);
                boolean isForUndo = req.isShowActioned();
                ActionableDataPoint dp = new ActionableDataPoint();
                dp.setActionableId(actId);
                dp.setTaskId(taskId);
                dp.setDeviceId(req.getDeviceId());
                boolean add = false;
                String subPathOfCurrentPath = "";
                for (SearchResultStored sr : searchResults) {
                    List displayActions = ac.getActionDisplayNameForArea(sr.getNamedArea());
                    if (displayActions.isEmpty() || (!isForUndo || !sr.isHasPerformedAction()) && (isForUndo || sr.isHasPerformedAction())) continue;
                    if (sr.isHasIgnoredAction()) {
                        ret.incrementNumIgnored();
                    }
                    if (!req.isShowIgnored() && sr.isHasIgnoredAction()) continue;
                    dp.setDisplayActions(displayActions);
                    if (dp.getFilePath().isEmpty()) {
                        dp.setFilePath(sr.getFilePath());
                        subPathOfCurrentPath = sr.getSubPath();
                    } else if (dp.getFilePath().startsWith(sr.getFilePath())) {
                        dp.getSubPaths().add(subPathOfCurrentPath);
                        dp.setFilePath(sr.getFilePath());
                        subPathOfCurrentPath = sr.getSubPath();
                    } else if (sr.getFilePath().startsWith(dp.getFilePath())) {
                        dp.getSubPaths().add(sr.getSubPath());
                    } else {
                        dp.getSubPaths().add(this.removeCommonPath(dp.getFilePath(), sr.getFilePath()));
                    }
                    dp.setIsIgnored(sr.isHasIgnoredAction());
                    if (this.inFlight.hasDeferredForSearchResult(sr.getId())) {
                        dp.setHasDeferredActions(true);
                    }
                    if (this.inFlight.hasInFlight(sr.getId(), sr.getTaskInstanceId())) {
                        dp.setHasInFlight(true);
                    }
                    add = true;
                }
                if (!add) continue;
                ret.getData().add(dp);
            }
        }
        return ret;
    }

    private String removeCommonPath(String p, String otherPath) {
        String[] parts = p.split("/");
        String[] otherParts = otherPath.split("/");
        int maxParts = Integer.min(parts.length, otherParts.length);
        for (int i = 0; i < maxParts; ++i) {
            if (parts[i].equals(otherParts[i])) continue;
            StringBuilder ret = new StringBuilder();
            for (int j = i; j < otherParts.length; ++j) {
                ret.append("/").append(otherParts[j]);
            }
            return ret.toString();
        }
        return otherPath;
    }

    public List<ActionableDataPointDetails> getDatapointDetails(String deviceId, String taskId, String actionableId) {
        ArrayList<ActionableDataPointDetails> ret = new ArrayList<ActionableDataPointDetails>();
        Optional optTask = this.taskStore.getTaskInstanceFromId(taskId);
        Optional regOpt = this.deviceService.getDeviceFromId(deviceId, false);
        if (optTask.isPresent() && regOpt.isPresent()) {
            List searchResults = this.resultsStore.getResultsForTaskInstanceAndDeviceAndActionableId(taskId, deviceId, actionableId);
            for (SearchResultStored sr : searchResults) {
                ret.add(new ActionableDataPointDetails((TaskInstance)optTask.get(), (DeviceRegistration)regOpt.get(), sr));
            }
        }
        return ret;
    }

    public List<DeviceWithActionableTasks> getActionableDevices() {
        ArrayList<DeviceWithActionableTasks> ret = new ArrayList<DeviceWithActionableTasks>();
        List<DeviceType> types = Arrays.asList(DeviceType.ALFRESCO, DeviceType.ATLASSIAN, DeviceType.GOOGLE, DeviceType.O365);
        List devices = this.deviceService.getDevicesOfTypes(types);
        for (DeviceRegistration dr : devices) {
            ArrayList<SmallDetails> search = new ArrayList<SmallDetails>();
            ArrayList<SmallDetails> rt = new ArrayList<SmallDetails>();
            LatestTaskInstanceCollection tasks = this.taskStore.getLatestInstancesForDevice(dr.getDeviceId());
            for (String templateId : tasks.getUnifiedSearchTemplateIds()) {
                ActionCollection actions;
                Optional commonOpt;
                TaskTemplate templ = this.taskStore.getTemplateFromId(templateId);
                BaseCommand com = templ.getBaseCommand();
                boolean hasConfigForDeviceType = this.hasConfigForDeviceType(dr, com);
                if (!hasConfigForDeviceType || (commonOpt = com.getCommonFilter()).isEmpty() || !(actions = ((SearchFilterCommon)commonOpt.get()).getActions()).hasActions()) continue;
                search.add(new SmallDetails(templateId, templ.getDisplayName(), templ.getCreated(), actions.getActionDisplayName(), false));
            }
            for (TaskInstance inst : tasks.getRealTime()) {
                ActionCollection actions;
                Optional commonOpt;
                BaseCommand com = inst.getCommand();
                boolean hasConfigForDeviceType = true;
                if (com.getRoutableConfig().isPresent()) {
                    hasConfigForDeviceType = this.hasConfigForDeviceType(dr, com);
                }
                if (!hasConfigForDeviceType || (commonOpt = com.getCommonFilter()).isEmpty() || !(actions = ((SearchFilterCommon)commonOpt.get()).getActions()).hasActions()) continue;
                rt.add(new SmallDetails(inst.getUid(), inst.getDisplayName(), inst.getCreated(), actions.getActionDisplayName(), false));
            }
            if (search.isEmpty() && rt.isEmpty()) continue;
            DeviceWithActionableTasks dat = new DeviceWithActionableTasks();
            dat.setDeviceId(dr.getDeviceId());
            dat.setDeviceName(dr.hostNameOrCloudHost());
            dat.setRtTasks(rt);
            dat.setSearchTasks(search);
            ret.add(dat);
        }
        Collections.sort(ret);
        return ret;
    }

    private boolean hasConfigForDeviceType(DeviceRegistration dr, BaseCommand com) {
        DeviceType currentType = dr.getDeviceType();
        boolean hasConfigForDeviceType = true;
        if (com.getRoutableConfig().isPresent()) {
            hasConfigForDeviceType = ((IRouteableSearchConfig)com.getRoutableConfig().get()).hasConfigForDeviceType(currentType);
            if (currentType.equals((Object)DeviceType.ATLASSIAN) && hasConfigForDeviceType) {
                hasConfigForDeviceType = ((IRouteableSearchConfig)com.getRoutableConfig().get()).hasAtlassian(dr.getDeviceSubTypesCollection());
            }
        }
        return hasConfigForDeviceType;
    }
}

