/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks;

import com.geolang.ascema.domainmodelpublic.pattern.PatternContextWords;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchCommand;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.Job;
import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.PatternConfig;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DatabaseSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.IRouteableSearchConfig;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.endpointcommon.messages.servernotification.CancelJobServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.PauseJobServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.DatabaseCredentialStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.SearchStateSummary;
import com.geolang.ascema.managerdomain.web.SearchStateSummaryCollection;
import com.geolang.ascema.managerdomain.web.WebDbQuery;
import com.geolang.ascema.managerdomain.web.WebSavedDatabaseCredentials;
import com.geolang.ascema.managerevents.ProgressEvent;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerpersistence.serviceinterfaces.ITaskManager;
import com.geolang.ascema.managerpersistence.tasks.LatestTaskInstanceCollection;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateManager;
import com.geolang.ascema.managerservice.controllers.tasks.ResultsDeleterService;
import com.geolang.ascema.managerservice.controllers.tasks.actions.DeferredActionsController;
import com.geolang.ascema.managerservice.rest.DataValidation;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TaskManager
implements ITaskManager {
    private static final Logger LOG = Logger.getLogger(TaskManager.class.getName());
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private ResultsDeleterService resultsDeleteHelper;
    @Autowired
    @Lazy
    private DeviceService endpointService;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    @Lazy
    JobStateManager jobStateManager;
    @Autowired
    private SchedulingService scheduler;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private DeferredActionsController deferredActionsController;
    private final ExecutorService cleanupExecutor = Executors.newSingleThreadExecutor();

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
        this.cleanupExecutor.submit(() -> this.removeDeadTasks());
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
        this.cleanupExecutor.shutdown();
    }

    private void removeDeadTasks() {
        try {
            Optional opt;
            LOG.info("check for old actions tasks");
            LocalDateTime ld = LocalDateTime.now().minusDays(7L);
            Date lastWeek = Date.from(ld.atZone(ZoneId.systemDefault()).toInstant());
            ArrayList<TaskInstance> toDelete = new ArrayList<TaskInstance>();
            for (TaskInstance ti : this.getAllInstances(BaseCommand.CommandType.PERFORM_ACTIONS)) {
                if (ti.getCreated().before(lastWeek)) {
                    LOG.log(Level.INFO, "Remove old action created {0} {1}", new Object[]{ti.getCreated(), ti.getDisplayName()});
                    continue;
                }
                for (String deviceId : ti.getDeviceIds()) {
                    opt = this.endpointService.getDeviceFromId(deviceId, false);
                    if (!opt.isEmpty()) continue;
                    LOG.log(Level.INFO, "remove actions task for deleted agent {0}", ti.getDisplayName());
                    toDelete.add(ti);
                }
            }
            for (TaskInstance ti : this.getAllInstances(BaseCommand.CommandType.PERFORM_DEFERRED_ACTION)) {
                if (ti.getCreated().before(lastWeek)) {
                    LOG.log(Level.INFO, "Remove old deferred action created {0} {1}", new Object[]{ti.getCreated(), ti.getDisplayName()});
                    toDelete.add(ti);
                    continue;
                }
                for (String deviceId : ti.getDeviceIds()) {
                    opt = this.endpointService.getDeviceFromId(deviceId, false);
                    if (!opt.isEmpty()) continue;
                    LOG.log(Level.INFO, "remove deferred actions task for deleted agent {0}", ti.getDisplayName());
                    toDelete.add(ti);
                }
            }
            for (TaskInstance ti : toDelete) {
                this.deleteTaskInstance("db cleaner", ti.getUid());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TaskManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public TaskTemplate addTemplate(String createdBy, BaseCommand command, String templateName, JobPriority priority, boolean alertWhenJobIsDone, String actionIgnorePath) {
        TaskTemplate t = new TaskTemplate(command, templateName, priority, alertWhenJobIsDone);
        t.setActionIgnorePathsName(actionIgnorePath);
        this.taskStore.addTemplate(t);
        this.auditLog.templateCreated(createdBy, t);
        return t;
    }

    public boolean renameTemplate(String templateId, String newName) {
        if (this.searchOrRTNameExists(newName)) {
            LOG.log(Level.WARNING, "Not reanaming, new name already exists {0}", newName);
            return false;
        }
        if (!TaskManager.isValidTemplateName((String)newName)) {
            LOG.log(Level.WARNING, "Not reanaming, new name not valid {0}", newName);
            return false;
        }
        TaskTemplate existing = this.getTemplateFromId(templateId);
        if (existing == null) {
            LOG.log(Level.WARNING, "template not found to rename {0}", templateId);
            return false;
        }
        String oldName = existing.getDisplayName();
        existing.setDisplayName(newName);
        this.taskStore.update(existing);
        for (TaskInstance ti : this.getAllInstancesForTemplate(existing.getUid())) {
            String displayName = ti.getDisplayName();
            if (!displayName.contains(oldName)) continue;
            displayName = displayName.replaceAll(oldName, newName);
            ti.setDisplayName(displayName);
            this.taskStore.update(ti);
        }
        return true;
    }

    public boolean deleteTemplate(String deletedBy, String id) {
        TaskTemplate jpt = this.taskStore.getTemplateFromId(id);
        if (jpt != null) {
            this.auditLog.templateDeleted(deletedBy, jpt);
            for (String instId : new ArrayList(jpt.getInstanceIds())) {
                this.deleteTaskInstance(deletedBy, instId);
            }
            if (this.scheduler.getScheduleForTemplate(id).isPresent()) {
                LOG.log(Level.INFO, "Remove schedule for task {0}", jpt.getDisplayName());
                this.scheduler.removeSchedule(id);
            }
            this.taskStore.deleteTemplate(this.taskStore.getTemplateFromId(id));
            return true;
        }
        return false;
    }

    public void updateTemplate(TaskTemplate template) {
        this.taskStore.update(template);
    }

    public void updateInstance(TaskInstance inst) {
        this.taskStore.update(inst);
    }

    public boolean searchOrRTNameExists(String name) {
        boolean ret = this.templateExists(name);
        if (ret) {
            return true;
        }
        List tis = this.getAllRTInstances();
        for (TaskInstance ti : tis) {
            if (!ti.getDisplayName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean templateExists(String templatename) {
        return null != this.taskStore.getTemplateByName(templatename);
    }

    public TaskTemplate getTemplateFromId(String instanceId) {
        return this.taskStore.getTemplateFromId(instanceId);
    }

    public List<TaskInstance> getAllInstancesForTemplate(String templateId) {
        return this.taskStore.getAllInstancesForTemplate(templateId);
    }

    public Optional<TaskInstance> getTaskInstanceFromId(String instanceId) {
        return this.taskStore.getTaskInstanceFromId(instanceId);
    }

    public String getTaskInstanceNameFromId(String instanceId) {
        Optional inst = this.getTaskInstanceFromId(instanceId);
        if (inst.isPresent()) {
            return ((TaskInstance)inst.get()).getDisplayName();
        }
        return "";
    }

    public Optional<TaskInstance> getTaskInstanceFromIdWithoutCache(String instanceId) {
        return this.taskStore.getTaskInstanceFromIdWithoutCache(instanceId);
    }

    public TaskTemplate getRealTimeProtectTemplate() {
        return this.taskStore.getRealTimeProtectTemplate();
    }

    public TaskTemplate getPerformActionsTemplate() {
        return this.taskStore.getPerformActionsTemplate();
    }

    public List<TaskInstance> getAllRTInstances() {
        return this.taskStore.getAllRTInstances();
    }

    public boolean deleteTaskInstance(String deletedBy, String instanceId) {
        Optional instanceOpt = this.taskStore.getTaskInstanceFromId(instanceId);
        if (instanceOpt.isPresent()) {
            TaskInstance instance = (TaskInstance)instanceOpt.get();
            for (JobDeviceState state : instance.getDeviceStates()) {
                if (!state.getState().equals((Object)JobState.RUNNING)) continue;
                try {
                    this.endpointService.getOutQueue().sendMessage(state.getDeviceId(), (ServerNotificationBase)new CancelJobServerMessage(instanceId), false).get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    Logger.getLogger(TaskManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            TaskTemplate templ = this.taskStore.getTemplateFromId(instance.getParentTemplateId());
            templ.removeInstance(instanceId);
            this.taskStore.update(templ);
            this.auditLog.instanceDeleted(deletedBy, instance);
            this.deferredActionsController.deleteDeferredActionsForTask(instance);
            this.taskStore.deleteInstance(instance);
            this.resultsDeleteHelper.deleteAllResultsForTaskInstance(instance);
            this.jobStateManager.removeAllJobStateForInstance(instance);
            LOG.log(Level.INFO, "Deleted instance {0}", instance.getDisplayName());
            return true;
        }
        return false;
    }

    public Iterable<TaskInstance> getAllInstances(BaseCommand.CommandType type) {
        ArrayList<TaskInstance> ret = new ArrayList<TaskInstance>();
        for (TaskInstance t : this.taskStore.getAllInstances()) {
            if (!t.getCommandType().equals((Object)type)) continue;
            ret.add(t);
        }
        return ret;
    }

    public List<String> getLatestUnifiedSearchTasksWithPartialAndRealtime() {
        ArrayList<String> ret = new ArrayList<String>();
        LatestTaskInstanceCollection coll = this.taskStore.getLatestInstances();
        List lists = coll.getLatestSearchsTasksWithPartial();
        for (List list : lists) {
            for (TaskInstance ti : list) {
                ret.add(ti.getUid());
            }
        }
        ret.addAll(coll.getRealTime().stream().map(e -> e.getUid()).collect(Collectors.toList()));
        return ret;
    }

    public List<String> getLatestUnifiedSearchTasksWithPartial(String templateId) {
        ArrayList<String> ret = new ArrayList<String>();
        LatestTaskInstanceCollection coll = this.taskStore.getLatestInstances();
        List list = coll.getLatestSearchTasksWithPartial(templateId);
        for (TaskInstance ti : list) {
            ret.add(ti.getUid());
        }
        return ret;
    }

    public List<String> getLatestInstancesSearchAndRealtimeForDeviceWithPartial(String deviceId) {
        return this.taskStore.getLatestInstancesSearchAndRealtimeForDeviceWithPartial(deviceId);
    }

    public List<String> getLatestInstancesForDeviceWhereJobRanToCompletion(String deviceId, List<BaseCommand.CommandType> commandTypes) {
        LatestTaskInstanceCollection coll = this.taskStore.getLatestInstances();
        ArrayList<String> ret = new ArrayList<String>();
        block0: for (TaskInstance inst : coll.getLatestTasksIncludingPartial(commandTypes)) {
            Optional jobOpt = inst.getStateForDevice(deviceId);
            if (!jobOpt.isPresent()) continue;
            if (((JobDeviceState)jobOpt.get()).getState().ranToCompletion() || commandTypes.contains(BaseCommand.CommandType.PROTECT) && inst.getCommandType().equals((Object)BaseCommand.CommandType.PROTECT)) {
                ret.add(inst.getUid());
                continue;
            }
            List all = this.getAllInstancesForTemplate(inst.getParentTemplateId());
            Comparator compareByDate = (o1, o2) -> o1.getCreated().compareTo(o2.getCreated());
            Collections.sort(all, compareByDate);
            for (TaskInstance ti : all) {
                Optional opt = ti.getStateForDevice(deviceId);
                if (!opt.isPresent() || !((JobDeviceState)opt.get()).getState().ranToCompletion()) continue;
                ret.add(ti.getUid());
                continue block0;
            }
        }
        return ret;
    }

    public Optional<TaskInstance> getLatestInstanceForTemplateWhereOneCompleted(TaskTemplate tt) {
        TaskInstance ret = null;
        for (String uid : tt.getInstanceIds()) {
            TaskInstance ti;
            Optional opt = this.taskStore.getTaskInstanceFromId(uid);
            if (!opt.isPresent() || !(ti = (TaskInstance)opt.get()).atLeastOneCompleted() || ret != null && !ti.getCreated().after(ret.getCreated())) continue;
            ret = ti;
        }
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public ArrayList<TaskTemplate> getAllTemplatesOfType(BaseCommand.CommandType type) {
        ArrayList<TaskTemplate> ret = new ArrayList<TaskTemplate>();
        for (TaskTemplate t : this.taskStore.getAllNonEphemeralTemplates()) {
            if (!t.getCommandType().equals((Object)type)) continue;
            ret.add(t);
        }
        return ret;
    }

    public List<ImmutableTriple<String, String, Date>> getAllSearchTemplatesIdsOfType(BaseCommand.CommandType type) {
        ArrayList<ImmutableTriple<String, String, Date>> ret = new ArrayList<ImmutableTriple<String, String, Date>>();
        for (TaskTemplate t : this.getAllTemplatesOfType(type)) {
            ret.add((ImmutableTriple<String, String, Date>)ImmutableTriple.of((Object)t.getUid(), (Object)t.getDisplayName(), (Object)t.getCreated()));
        }
        return ret;
    }

    public Date getLastRanOrNull(String taskUuid) {
        Date ret = null;
        for (TaskInstance inst : this.taskStore.getAllInstances()) {
            if (!inst.getParentTemplateId().equals(taskUuid) || ret != null && !ret.before(inst.getCreated())) continue;
            ret = inst.getCreated();
        }
        return ret;
    }

    public List<SearchStateSummaryCollection> getAllSummaries(BaseCommand.CommandType type) {
        ArrayList<SearchStateSummaryCollection> ret = new ArrayList<SearchStateSummaryCollection>();
        ArrayList jps = this.getAllTemplatesOfType(type);
        for (TaskTemplate jp : jps) {
            List sum = this.getStateSummariesForTemplate(jp.getUid());
            ret.add(new SearchStateSummaryCollection(sum, jp.getUid()));
        }
        return ret;
    }

    public List<SearchStateSummary> getStateSummariesForTemplate(String templateId) {
        ArrayList<SearchStateSummary> ret = new ArrayList<SearchStateSummary>();
        TaskTemplate tt = this.getTemplateFromId(templateId);
        if (tt != null) {
            for (String uid : tt.getInstanceIds()) {
                Optional opt = this.taskStore.getTaskInstanceFromId(uid);
                if (!opt.isPresent()) continue;
                ret.add(new SearchStateSummary(((TaskInstance)opt.get()).getUid(), ((TaskInstance)opt.get()).getDeviceStates()));
            }
        }
        return ret;
    }

    public boolean cancelJob(String instanceId, String deviceId) {
        boolean ret = false;
        try {
            Optional opt;
            ret = ServerMessagesOutQueue.Status.SENT.equals(this.endpointService.getOutQueue().sendMessage(deviceId, (ServerNotificationBase)new CancelJobServerMessage(instanceId), false).get());
            if (!ret) {
                LOG.log(Level.WARNING, "failed to send cancel message to agent {0}", deviceId);
            }
            if (!(opt = this.getTaskInstanceFromId(instanceId)).isPresent()) {
                LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
                return false;
            }
            TaskInstance instance = (TaskInstance)opt.get();
            Optional stateOpt = instance.getStateForDevice(deviceId);
            if (!stateOpt.isPresent()) {
                LOG.log(Level.WARNING, "device not on task {0} can't mark as cancelled", deviceId);
                return false;
            }
            this.jobStateManager.updateJobState(this.taskStore, instance, deviceId, ((JobDeviceState)stateOpt.get()).getState(), JobState.CANCELLED, Optional.empty());
            ret = true;
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(TaskManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    public boolean resumeAllJobs(String instanceId) {
        Optional opt = this.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
            return false;
        }
        for (String id : ((TaskInstance)opt.get()).getDeviceIds()) {
            this.resumeJob(instanceId, id);
        }
        return true;
    }

    public boolean pauseAllJobs(String instanceId) {
        Optional opt = this.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
            return false;
        }
        for (String id : ((TaskInstance)opt.get()).getDeviceIds()) {
            this.pauseJob(instanceId, id, false);
        }
        return true;
    }

    public boolean resumeJob(String instanceId, String deviceId) {
        Optional opt = this.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
            return false;
        }
        Optional reg = this.endpointService.getDeviceFromId(deviceId, false);
        if (reg.isEmpty()) {
            LOG.log(Level.WARNING, "no device to resume job? {0}", deviceId);
            return false;
        }
        Job j = this.jobRunner.createJobForDevice((TaskInstance)opt.get(), (DeviceRegistration)reg.get());
        if (j != null) {
            this.endpointService.informJobAvailable(deviceId, Collections.singletonList(j), ProxySettings.getUIDetails((String)deviceId));
        }
        return j != null;
    }

    public boolean pauseJob(String instanceId, String deviceId, boolean isForQuietTime) {
        boolean ret = false;
        JobState newState = isForQuietTime ? JobState.PAUSED_QUIET_TIME : JobState.PAUSED;
        try {
            ret = ServerMessagesOutQueue.Status.SENT.equals(this.endpointService.getOutQueue().sendMessage(deviceId, (ServerNotificationBase)new PauseJobServerMessage(instanceId, isForQuietTime), false).get());
            if (!ret) {
                Optional opt = this.getTaskInstanceFromId(instanceId);
                if (!opt.isPresent()) {
                    LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
                    return false;
                }
                TaskInstance instance = (TaskInstance)opt.get();
                Optional stateOpt = instance.getStateForDevice(deviceId);
                if (!stateOpt.isPresent()) {
                    LOG.log(Level.WARNING, "device not on task {0} can't mark as paused", deviceId);
                    return false;
                }
                this.jobStateManager.updateJobState(this.taskStore, instance, deviceId, ((JobDeviceState)stateOpt.get()).getState(), newState, Optional.empty());
                ret = true;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(TaskManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    public ArrayList<Job> getJobsForDevice(String deviceId) {
        ArrayList<Job> ret = new ArrayList<Job>();
        Optional devOpt = this.endpointService.getDeviceFromId(deviceId, false);
        if (!devOpt.isPresent()) {
            LOG.warning("No device found");
            return ret;
        }
        DeviceRegistration devReg = (DeviceRegistration)devOpt.get();
        DeviceType type = devReg.getDeviceType();
        Set subs = devReg.getDeviceSubTypesCollection();
        LatestTaskInstanceCollection latest = this.taskStore.getLatestInstances();
        for (TaskInstance instance : latest.getLatestRunnableTasks(Arrays.asList(BaseCommand.CommandType.values()))) {
            if (instance.getCommand().getRoutableConfig().isPresent() ? !((IRouteableSearchConfig)instance.getCommand().getRoutableConfig().get()).jobIsForDeviceType(type, subs) : !JobRunner.jobTypeCanRunOnDeviceType((TaskInstance)instance, (DeviceType)type)) continue;
            boolean found = false;
            Optional jobOpt = instance.getStateForDevice(deviceId);
            if (jobOpt.isPresent()) {
                found = true;
                JobState state = ((JobDeviceState)jobOpt.get()).getState();
                if (!state.isFinished() && !state.isPaused()) {
                    ret.add((Job)instance.getExistingJob(deviceId).get());
                }
            }
            if (found || !instance.isRunOnallDevices()) continue;
            Job j = this.jobRunner.createJobForDevice(instance, devReg);
            this.taskStore.update(instance);
            ret.add(j);
        }
        return ret;
    }

    @Subscribe
    void handleProgressEvent(ProgressEvent ev) {
        Optional opt = this.taskStore.getTaskInstanceFromId(ev.getTaskId());
        if (opt.isPresent()) {
            this.jobStateManager.updateJobProgress((TaskInstance)opt.get(), ev.getDeviceId(), ev.getProgress());
        }
    }

    public void markUnfinishedJobsAsCancelled(String deviceId) {
        for (TaskInstance instance : this.taskStore.getAllInstances()) {
            if (!instance.hasExistingJobForDevice(deviceId)) continue;
            Optional state = this.jobStateManager.markUnfinishedTaskAsCancelled(instance, deviceId);
            if (state.isPresent()) {
                instance.updateState((JobDeviceState)state.get());
            }
            this.taskStore.update(instance);
        }
    }

    public static boolean isValidTemplateName(String name) {
        return DataValidation.isValidNameForFilesystem((String)name) && !DataValidation.containsCSVInjectionPayload((String)name);
    }

    void pauseRunningTasksForQuietTime(DeviceRegistration dr) {
        LatestTaskInstanceCollection latest = this.taskStore.getLatestInstancesForDevice(dr.getDeviceId());
        List instances = latest.getLatestRunnableTasks(BaseCommand.getSearchAndRetrievalCommandTypes());
        for (TaskInstance ti : instances) {
            JobDeviceState jd;
            Optional jobOpt = ti.getStateForDevice(dr.getDeviceId());
            if (!jobOpt.isPresent() || !(jd = (JobDeviceState)jobOpt.get()).getState().isRunning() || ti.isOverrideQuietTime()) continue;
            this.pauseJob(ti.getUid(), dr.getDeviceId(), true);
        }
    }

    void resumeTasksPausedForQuietTime(DeviceRegistration dr) {
        LatestTaskInstanceCollection latest = this.taskStore.getLatestInstancesForDevice(dr.getDeviceId());
        List instances = latest.getLatestRunnableTasks(BaseCommand.getSearchAndRetrievalCommandTypes());
        for (TaskInstance ti : instances) {
            JobDeviceState jd;
            Optional jobOpt = ti.getStateForDevice(dr.getDeviceId());
            if (!jobOpt.isPresent() || !(jd = (JobDeviceState)jobOpt.get()).getState().equals((Object)JobState.PAUSED_QUIET_TIME)) continue;
            this.resumeJob(ti.getUid(), dr.getDeviceId());
        }
    }

    public void updateClassificationLabelsOnTasks(String patternDisplayName, Set<String> tags) {
        boolean changed;
        BaseCommand bc;
        ArrayList tasks = this.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH);
        tasks.addAll(this.getAllTemplatesOfType(BaseCommand.CommandType.UNIFIED_SEARCH));
        tasks.addAll(this.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL));
        for (TaskTemplate tt : tasks) {
            bc = tt.getBaseCommand();
            changed = this.updateCommandForContextWords(bc, patternDisplayName, tags);
            if (!changed) continue;
            tt.replaceCommand(bc);
            this.taskStore.update(tt);
        }
        for (TaskInstance ti : this.taskStore.getAllRTInstances()) {
            bc = ti.getCommand();
            changed = this.updateCommandForContextWords(bc, patternDisplayName, tags);
            if (!changed) continue;
            ti.replaceCommand(bc);
            this.taskStore.update(ti);
        }
    }

    public void updateContextWordsOnTasks(String patternDisplayName, Set<String> words) {
        boolean changed;
        BaseCommand bc;
        ArrayList tasks = this.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH);
        tasks.addAll(this.getAllTemplatesOfType(BaseCommand.CommandType.UNIFIED_SEARCH));
        tasks.addAll(this.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL));
        for (TaskTemplate tt : tasks) {
            bc = tt.getBaseCommand();
            changed = this.updateCommandForContextWords(bc, patternDisplayName, words);
            if (!changed) continue;
            tt.replaceCommand(bc);
            this.taskStore.update(tt);
        }
        for (TaskInstance ti : this.taskStore.getAllRTInstances()) {
            bc = ti.getCommand();
            changed = this.updateCommandForContextWords(bc, patternDisplayName, words);
            if (!changed) continue;
            ti.replaceCommand(bc);
            this.taskStore.update(ti);
        }
    }

    private boolean updateCommandForContextWords(BaseCommand bc, String patternDisplayName, Set<String> words) {
        boolean changed = false;
        Optional opt = bc.getCommonFilter();
        if (opt.isPresent()) {
            Collection patterns = ((SearchFilterCommon)opt.get()).getPatterns();
            for (PatternConfig pc : patterns) {
                if (!pc.getPatternDisplayName().equals(patternDisplayName)) continue;
                pc.setContextWords(PatternContextWords.fromWords(words));
                changed = true;
                break;
            }
            if (changed) {
                ((SearchFilterCommon)opt.get()).setPatterns(new HashSet(patterns));
            }
        }
        return changed;
    }

    public void updateDbCredentialsOnTasks(String oldisplayname, String displayname, DatabaseCredentials creds) {
        ArrayList tasks = this.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH);
        for (TaskTemplate t : tasks) {
            DatabaseSearchCommand oldcommand = (DatabaseSearchCommand)t.getBaseCommand();
            DatabaseSearchConfiguration oldConfig = oldcommand.getConfig();
            if (!oldConfig.getCredentialsDisplayName().equals(oldisplayname)) continue;
            DatabaseSearchConfiguration newConfig = new DatabaseSearchConfiguration(displayname, creds.toJSON(), oldConfig.getQuery(), oldConfig.getCommonFilter());
            DatabaseSearchCommand newCommand = new DatabaseSearchCommand(newConfig);
            t.replaceCommand((BaseCommand)newCommand);
            LOG.log(Level.INFO, "update template {0}", t.getDisplayName());
            this.updateTemplate(t);
            for (TaskInstance inst : this.getAllInstancesForTemplate(t.getUid())) {
                inst.replaceCommand((BaseCommand)newCommand);
                this.updateInstance(inst);
                LOG.log(Level.INFO, "update instance {0}", inst.getDisplayName());
            }
        }
    }

    public WebSavedDatabaseCredentials decorateDBCredentialsWithInUse(DatabaseCredentialStored stored) {
        WebSavedDatabaseCredentials ret = new WebSavedDatabaseCredentials(stored);
        Optional opt = stored.getCredentials();
        if (opt.isPresent()) {
            String credsNameIn = ((DatabaseCredentials)opt.get()).getDisplayName();
            ArrayList list = this.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH);
            block0: for (TaskTemplate t : list) {
                DatabaseSearchCommand command = (DatabaseSearchCommand)t.getBaseCommand();
                if (!command.getConfig().getCredentialsDisplayName().equals(credsNameIn)) continue;
                ret.setInUse(true);
                String inUseQuery = command.getConfig().getQuery().getDisplayName();
                for (WebDbQuery q : ret.getQueries()) {
                    if (!inUseQuery.equals(q.getDisplayName())) continue;
                    q.setInUse(true);
                    continue block0;
                }
            }
        }
        return ret;
    }
}

