/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerpersistence.DatabaseResultsStore;
import com.geolang.ascema.managerpersistence.StoredResultStore;
import com.geolang.ascema.managerservice.controllers.results.UnprocessableResultsManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ResultsDeleterService {
    @Autowired
    @Lazy
    private StoredResultStore resultsStore;
    @Autowired
    @Lazy
    private DatabaseResultsStore dbResultsStore;
    @Autowired
    @Lazy
    private UnprocessableResultsManager unprocessableManager;

    public void deleteAllResultsForTaskInstance(TaskInstance inst) {
        if (inst.getCommandType().equals((Object)BaseCommand.CommandType.DATABASE_SEARCH)) {
            this.dbResultsStore.deleteAllResultsForTaskInstance(inst.getUid());
        } else {
            this.resultsStore.deleteAllResultsForTaskInstance(inst.getUid());
            this.unprocessableManager.deleteByTaskInstanceId(inst.getUid());
        }
    }

    public void deleteAllResultsForTaskInstanceAndDeviceId(TaskInstance inst, String deviceId) {
        if (inst.getCommandType().equals((Object)BaseCommand.CommandType.DATABASE_SEARCH)) {
            this.dbResultsStore.deleteAllResultsForTaskInstance(inst.getUid());
        } else {
            this.resultsStore.deleteAllResultsForTaskInstanceAndDeviceId(inst.getUid(), deviceId);
        }
    }
}

