/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks;

import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.QuietTimeConfiguration;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class QuietTimeScheduler {
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    @Qualifier(value="transactionManager")
    protected PlatformTransactionManager txManager;

    @Scheduled(cron="0 * * * * ?")
    void process() {
        TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
        tmpl.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void processQuietTimes() {
        LocalDateTime now = LocalDateTime.now();
        DayOfWeek day = now.getDayOfWeek();
        LocalTime time = now.toLocalTime();
        for (DeviceRegistration dr : this.deviceService.getAllDevices(false)) {
            QuietTimeConfiguration quiettimes = dr.getExpandedQuietTime();
            if (quiettimes.isInQuietTime(day, time)) {
                this.taskManager.pauseRunningTasksForQuietTime(dr);
                continue;
            }
            this.taskManager.resumeTasksPausedForQuietTime(dr);
        }
    }
}

