/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks;

import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.endpointcommon.domain.CloudPlatformAreaType;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.Progress;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionVerb;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionsCommand;
import com.geolang.ascema.endpointcommon.domain.actions.command.DeferredActionCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.IRouteableSearchConfig;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.actions.InFlightAndDeferredActionsCollection;
import com.geolang.ascema.managerdomain.domain.BaseResultStored;
import com.geolang.ascema.managerdomain.domain.DeferredAction;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerevents.JobStateChangeEvent;
import com.geolang.ascema.managerevents.ResultsAvailableEvent;
import com.geolang.ascema.managerpersistence.EventHistoryStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerpersistence.results.MatchesManager;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateManager;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateUpdater;
import com.geolang.ascema.managerservice.controllers.tasks.ResultsDeleterService;
import com.geolang.ascema.managerservice.controllers.tasks.actions.DeferredActionsController;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class JobStateUpdater {
    private static final Logger LOG = Logger.getLogger(JobStateUpdater.class.getName());
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private ResultsManager resultManager;
    @Autowired
    private ResultsDeleterService resultsDeleteHelper;
    @Autowired
    private EventHistoryStore eventHistoryStore;
    @Autowired
    MatchesManager matchesManager;
    @Autowired
    AlertingController alertingController;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private JobStateManager jobStateManager;
    @Autowired
    private DeferredActionsController deferredController;
    @Autowired
    private InFlightAndDeferredActionsCollection inFlightController;
    @Autowired
    private AuditLogService auditLog;

    /*
     * Enabled aggressive block sorting
     */
    @Transactional
    public synchronized boolean updateJobState(String instanceId, String deviceId, JobState state, Optional<Progress> progress, String reason, ActionResult actionResult) {
        Optional stateOpt;
        Optional opt = this.taskStore.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.FINE, "Job not found in update for device {0} probably confirm job", deviceId);
            return false;
        }
        TaskInstance instance = (TaskInstance)opt.get();
        Optional actionopt = instance.performActionMethod();
        if (actionopt.isPresent()) {
            ActionVerb method = (ActionVerb)actionopt.get();
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$actions$command$ActionVerb[method.ordinal()]) {
                case 1: 
                case 2: {
                    this.updateForDeferredPerformOrUndoAction(deviceId, method, instance, state, actionResult);
                    break;
                }
                case 3: 
                case 4: {
                    this.updateForPerformOrUndoAction(deviceId, method, instance, state, actionResult);
                    break;
                }
            }
        }
        if (!(stateOpt = instance.getStateForDevice(deviceId)).isPresent()) return false;
        JobDeviceState oldState = (JobDeviceState)stateOpt.get();
        if (state.isCancelled()) {
            if (oldState.getState().isCancelled() && !instance.isRealTimeTask()) {
                LOG.info("Confirm Cancel");
            } else {
                this.jobStateManager.updateJobState(this.taskStore, instance, deviceId, oldState.getState(), state, progress);
                JobStateChangeEvent ev = new JobStateChangeEvent(instanceId, deviceId, instance.isAlertAutomatically(), state, false);
                MessageBus.getBus().post((Object)ev);
            }
            this.resultsDeleteHelper.deleteAllResultsForTaskInstanceAndDeviceId(instance, deviceId);
            return false;
        }
        if (oldState.getState().equals((Object)state)) {
            LOG.log(Level.INFO, "Job already at state {0} For device {1}", new Object[]{state, deviceId});
            return true;
        }
        this.jobStateManager.updateJobState(this.taskStore, instance, deviceId, oldState.getState(), state, progress);
        boolean allDone = instance.allDone();
        JobStateChangeEvent ev = new JobStateChangeEvent(instanceId, deviceId, instance.isAlertAutomatically(), state, allDone);
        MessageBus.getBus().post((Object)ev);
        if (ev.getState().equals((Object)JobState.DONE) && ev.isAlertAutomatically()) {
            this.sendAlerts(ev, instance);
        }
        if (allDone && TaskStore.isEphemeral((String)instance.getParentTemplateId())) {
            LOG.info("removing finished task instance");
            this.taskStore.deleteInstance(instance);
            this.jobStateManager.removeAllJobStateForInstance(instance);
            return true;
        }
        LOG.log(Level.INFO, "Set job state to {0} For device {1}", new Object[]{state, deviceId});
        return true;
    }

    private void sendAlerts(JobStateChangeEvent ev, TaskInstance inst) {
        Optional comOpt = Optional.empty();
        if (inst.getCommand().getRoutableConfig().isPresent()) {
            comOpt = ((IRouteableSearchConfig)inst.getCommand().getRoutableConfig().get()).getAtlassianConfig();
        }
        SettingsFile settings = SettingsFile.getInstance();
        boolean continueAlerting = settings.getContinueToAlert();
        ArrayList forAltassian = new ArrayList();
        try (Stream srs = this.resultManager.getStoredResultsForTaskInstanceAndDevice(ev.getTaskInstanceId(), ev.getDeviceId());){
            AtomicBoolean alertO365 = new AtomicBoolean(false);
            AtomicBoolean alertGoogle = new AtomicBoolean(false);
            AtomicBoolean alertAtlassian = new AtomicBoolean(false);
            AtomicBoolean alertEndpoints = new AtomicBoolean(false);
            AtomicBoolean alertAlfresco = new AtomicBoolean(false);
            AtomicBoolean changed = new AtomicBoolean(false);
            HashSet userIds = new HashSet();
            srs.forEach(stored -> {
                boolean alertAnyway = false;
                boolean oneSetToAlertedFromFound = this.matchesManager.setStatusFoundToAlertedAuto(stored);
                if (!oneSetToAlertedFromFound && continueAlerting) {
                    alertAnyway = this.matchesManager.hasMatchesWithStatus(stored, ResultStatus.ALERTED);
                }
                if (oneSetToAlertedFromFound || alertAnyway) {
                    CloudPlatformAreaType area;
                    changed.set(true);
                    if (stored.getUserId() != null) {
                        userIds.add(stored.getUserId());
                    }
                    if (CloudPlatformAreaType.isO365((CloudPlatformAreaType)(area = stored.getNamedArea().getCloudAreaType()))) {
                        alertO365.set(true);
                    } else if (CloudPlatformAreaType.isGoogle((CloudPlatformAreaType)area)) {
                        alertGoogle.set(true);
                    } else if (CloudPlatformAreaType.isAtlassian((CloudPlatformAreaType)area)) {
                        alertAtlassian.set(true);
                        forAltassian.add(stored);
                    } else if (CloudPlatformAreaType.isAlfresco((CloudPlatformAreaType)area)) {
                        alertAlfresco.set(true);
                    } else {
                        alertEndpoints.set(true);
                    }
                    this.eventHistoryStore.autoAlerted(inst.getDisplayName(), (BaseResultStored)stored);
                }
                this.entityManager.detach(stored);
            });
            if (changed.get()) {
                MessageBus.getBus().post((Object)new ResultsAvailableEvent(ev.getTaskInstanceId(), ev.getDeviceId()));
            }
            if (alertO365.get()) {
                this.alertingController.sendAutomatedAlertForCloud(ev.getDeviceId(), userIds, DeviceType.O365);
                LOG.log(Level.INFO, "sent automated O365 alerts to {0}", ev.getDeviceId());
            }
            if (alertGoogle.get()) {
                this.alertingController.sendAutomatedAlertForCloud(ev.getDeviceId(), userIds, DeviceType.GOOGLE);
                LOG.log(Level.INFO, "sent automated google alerts to {0}", ev.getDeviceId());
            }
            if (alertAtlassian.get()) {
                this.alertingController.sendAutomatedAlertForAtlassian(inst.getUid(), ev.getDeviceId(), forAltassian, comOpt);
                LOG.log(Level.INFO, "sent automated atlassian alerts to {0}", ev.getDeviceId());
            }
            if (alertAlfresco.get()) {
                this.alertingController.sendAutomatedAlertForAlfresco(ev.getTaskInstanceId(), ev.getDeviceId());
                LOG.log(Level.INFO, "sent automated alfresco alerts to {0}", ev.getDeviceId());
            }
            if (alertEndpoints.get()) {
                this.alertingController.sendAutomatedAlertToEndpoint(ev.getTaskInstanceId(), ev.getDeviceId());
                LOG.log(Level.INFO, "sent automated endpoint alerts to {0}", ev.getDeviceId());
            }
        }
    }

    private void updateForDeferredPerformOrUndoAction(String deviceId, ActionVerb method, TaskInstance instance, JobState state, ActionResult actionResult) {
        if (state.equals((Object)JobState.DONE) || state.equals((Object)JobState.FAILED)) {
            DeferredActionCommand command = (DeferredActionCommand)instance.getCommand();
            Long deferredId = command.getDeferredId();
            Optional opt = this.deferredController.getById(deferredId);
            if (opt.isPresent()) {
                DeferredAction da = (DeferredAction)opt.get();
                boolean OK = state.equals((Object)JobState.DONE);
                if (OK) {
                    LOG.info("done deferred action");
                    this.deferredController.remove(da);
                } else {
                    int max;
                    int times = da.getAttempt();
                    if (times > (max = SettingsFile.getInstance().getDeferredActionAttempts())) {
                        LOG.log(Level.INFO, "Attempted deferred action {0} times for result {1}, not trying again", new Object[]{times, da.getSearchResultStoredId()});
                        this.deferredController.remove(da);
                        return;
                    }
                    LOG.log(Level.INFO, "Failed deferred action {0} times for result {1}, will try again", new Object[]{times, da.getSearchResultStoredId()});
                    da.setAttempt(times + 1);
                    this.deferredController.update(da);
                }
            }
            this.inFlightController.getDeferredActionCounter().doneDeferredAction(deferredId);
            this.updateForPerformOrUndoAction(deviceId, method, instance, state, actionResult);
        }
    }

    private boolean updateForPerformOrUndoAction(String deviceId, ActionVerb method, TaskInstance instance, JobState state, ActionResult actionResult) {
        boolean isPerform;
        boolean bl = isPerform = method.equals((Object)ActionVerb.PERFORM) || method.equals((Object)ActionVerb.PERFORM_DEFERED);
        if (state.equals((Object)JobState.DONE) || state.equals((Object)JobState.FAILED)) {
            ActionsCommand command = (ActionsCommand)instance.getCommand();
            boolean success = state.equals((Object)JobState.DONE);
            if (null != command.getResultIds()) {
                for (Long id : command.getResultIds()) {
                    String logmsg;
                    Optional opt = this.resultManager.getResultById(id);
                    if (opt.isEmpty()) {
                        LOG.log(Level.WARNING, "Failed to find result to update in updateForPerformAction {0}", id);
                        return false;
                    }
                    SearchResultStored srs = (SearchResultStored)opt.get();
                    if (isPerform) {
                        srs.setHasIgnoredAction(actionResult.getStatus().equals((Object)ActionResult.ActionResultType.IGNORED));
                        srs.setHasPerformedAction(success && !actionResult.getStatus().equals((Object)ActionResult.ActionResultType.IGNORED));
                        logmsg = "update result for perform actions " + success;
                    } else {
                        srs.setHasPerformedAction(!success);
                        logmsg = "update result for undo actions " + success;
                    }
                    this.inFlightController.doneInFlight(srs, actionResult);
                    this.resultManager.update(srs);
                    this.auditLog.logActionStatus(this.taskStore, actionResult, deviceId, instance.getUid());
                    LOG.log(Level.INFO, logmsg);
                }
            }
        }
        return true;
    }
}

