/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.Progress;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerpersistence.IJobDeviceStateRepository;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateManager;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobStateManager {
    private static final Logger LOG = Logger.getLogger(JobStateManager.class.getName());
    @Autowired
    IJobDeviceStateRepository jobDeviceStateRepo;

    public void removeAllJobStateForInstance(TaskInstance inst) {
        List all = this.jobDeviceStateRepo.findAllByTaskInstanceId(inst.getUid());
        for (JobDeviceState d : all) {
            this.jobDeviceStateRepo.delete((Object)d);
        }
    }

    public void updateJobProgress(TaskInstance inst, String deviceId, Progress progress) {
        Optional opt = this.jobDeviceStateRepo.findByTaskInstanceIdAndDeviceId(inst.getUid(), deviceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "No state? {0}{1}", new Object[]{inst.getDisplayName(), deviceId});
            return;
        }
        JobDeviceState state = (JobDeviceState)opt.get();
        state.setFilesSearched(progress.getTotalFiles());
        state.setBytesSearched(progress.getTotalSize());
        this.jobDeviceStateRepo.save((Object)state);
        inst.updateState(state);
    }

    public Optional<JobDeviceState> markUnfinishedTaskAsCancelled(TaskInstance inst, String deviceId) {
        Optional opt = this.jobDeviceStateRepo.findByTaskInstanceIdAndDeviceId(inst.getUid(), deviceId);
        if (opt.isPresent() && !((JobDeviceState)opt.get()).getState().ranToCompletion()) {
            JobDeviceState state = (JobDeviceState)opt.get();
            state.setState(JobState.CANCELLED);
            this.jobDeviceStateRepo.save((Object)state);
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public boolean removeUnfinishedStateForDevice(TaskInstance inst, String deviceId) {
        Optional opt = this.jobDeviceStateRepo.findByTaskInstanceIdAndDeviceId(inst.getUid(), deviceId);
        if (opt.isPresent()) {
            if (!((JobDeviceState)opt.get()).getState().ranToCompletion()) {
                this.jobDeviceStateRepo.delete((Object)((JobDeviceState)opt.get()));
            }
            return true;
        }
        return false;
    }

    public void updateJobState(TaskStore taskStore, TaskInstance inst, String deviceId, JobState oldState, JobState newState, Optional<Progress> progress) {
        if (oldState.isFinished() && !inst.getCommandType().equals((Object)BaseCommand.CommandType.PROTECT)) {
            return;
        }
        Optional opt = this.jobDeviceStateRepo.findByTaskInstanceIdAndDeviceId(inst.getUid(), deviceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "No state? {0}{1}", new Object[]{inst.getDisplayName(), deviceId});
            return;
        }
        JobDeviceState state = (JobDeviceState)opt.get();
        state.setState(newState);
        if (progress.isPresent()) {
            state.setFilesSearched(progress.get().getTotalFiles());
            state.setBytesSearched(progress.get().getTotalSize());
        }
        Date now = new Date();
        if (newState.isRunning()) {
            state.setStartedRunningDate(now);
        } else if (newState.isFinished()) {
            state.setDoneDate(now);
        }
        if ((newState.isFinished() || newState.isCloudConnectionLost() || newState.isPaused()) && state.getStartedRunningDate() != null) {
            long diffInMillies = Math.abs(now.getTime() - state.getStartedRunningDate().getTime());
            if (diffInMillies < 1000L) {
                diffInMillies = 1000L;
            }
            int inSeconds = Math.toIntExact(diffInMillies / 1000L);
            state.setSearchDurationSeconds(state.getSearchDurationSeconds() + inSeconds);
            LOG.log(Level.INFO, "search duration for {0} on {1} {2}s", new Object[]{inst.getDisplayName(), deviceId, state.getSearchDurationSeconds()});
        }
        this.jobDeviceStateRepo.save((Object)state);
        inst.updateState(state);
        if (inst.allDone()) {
            TaskTemplate template = taskStore.getTemplateFromId(inst.getParentTemplateId());
            if (template != null) {
                template.setLastDurationSeconds(inst.maxDurationSeconds());
                for (TaskInstance ti : taskStore.getAllInstancesForTemplate(inst.getParentTemplateId())) {
                    if (ti.maxDurationSeconds() <= template.getMaxDurationSeconds()) continue;
                    template.setMaxDurationSeconds(ti.maxDurationSeconds());
                }
                taskStore.update(template);
            } else {
                LOG.log(Level.WARNING, "null template for instance?? {0}", inst);
            }
        }
    }

    public void createJobState(TaskInstance inst, DeviceRegistration reg) {
        JobDeviceState state;
        String deviceId = reg.getDeviceId();
        Optional opt = this.jobDeviceStateRepo.findByTaskInstanceIdAndDeviceId(inst.getUid(), deviceId);
        if (!opt.isPresent()) {
            state = new JobDeviceState(deviceId, JobState.NOT_STARTED, inst.getUid());
            if (reg.getExpandedQuietTime().isInQuietTimeNow() && !inst.isOverrideQuietTime()) {
                state.setState(JobState.PAUSED_QUIET_TIME);
            }
        } else {
            state = (JobDeviceState)opt.get();
            JobState existingJobState = state.getState();
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$JobState[existingJobState.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    LOG.log(Level.WARNING, "State of existing job is {0} this should not have been restarted, however... we somehow got here so start again", existingJobState);
                    state.setState(JobState.NOT_STARTED);
                    break;
                }
                case 4: 
                case 5: {
                    state.setState(JobState.RESUMING);
                    break;
                }
                default: {
                    state.setState(JobState.NOT_STARTED);
                }
            }
        }
        inst.updateState(state);
        this.jobDeviceStateRepo.save((Object)state);
    }
}

