/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.tasks;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.ConfirmCommand;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.Job;
import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.NamedArea;
import com.geolang.ascema.endpointcommon.domain.QuarantineAction;
import com.geolang.ascema.endpointcommon.domain.QuarantineCommand;
import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.searchconfig.IRouteableSearchConfig;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.MatchStored;
import com.geolang.ascema.managerdomain.domain.PathCollection;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerpersistence.StoredResultStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.PathCollectionController;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateManager;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JobRunner
implements DisposableBean {
    private static final Logger LOG = Logger.getLogger(JobRunner.class.getName());
    @Autowired
    @Lazy
    private StoredResultStore resultsStore;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private JobStateManager jobStateManager;
    @Autowired
    private PathCollectionController pathCollectionController;
    @Autowired
    private PatternService patternService;
    @Autowired
    @Lazy
    private DeviceService endpointService;
    @Autowired
    private LicenseManager licenseManager;
    private final ExecutorService exService = Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("jobrunner-"));

    public void destroy() throws Exception {
        this.exService.shutdownNow();
    }

    public void run(TaskTemplate template, TaskInstance instance, boolean ignoreQuietTimes) {
        if (this.licenseManager.isExpired()) {
            LOG.log(Level.WARNING, "License is expired not running task {0}", instance.getDisplayName());
            return;
        }
        this.exService.submit(() -> {
            Logger.getLogger(TaskManager.class.getName()).log(Level.INFO, "Add instance {0}", instance);
            this.taskStore.add(instance);
            template.addInstance(instance.getUid());
            this.taskStore.update(template);
            for (String deviceId : instance.getDeviceIds()) {
                Job job = (Job)instance.getExistingJob(deviceId).get();
                if (((JobDeviceState)instance.getStateForDevice(deviceId).get()).getState().equals((Object)JobState.PAUSED_QUIET_TIME) && !ignoreQuietTimes) continue;
                this.endpointService.informJobAvailable(deviceId, Collections.singletonList(job), ProxySettings.getUIDetails((String)deviceId));
            }
            this.auditLog.instanceCreated(instance);
        });
    }

    public void runMultipleTasksOnDevice(DeviceRegistration dev, TaskTemplate template, List<TaskInstance> instances) {
        this.exService.submit(() -> {
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (TaskInstance instance : instances) {
                Job j = this.createJobForDevice(instance, dev);
                Logger.getLogger(TaskManager.class.getName()).log(Level.INFO, "Add instance {0}", instance);
                this.taskStore.add(instance);
                template.addInstance(instance.getUid());
                this.taskStore.update(template);
                this.auditLog.instanceCreated(instance);
                jobs.add(j);
            }
            this.endpointService.informJobAvailable(dev.getDeviceId(), jobs, ProxySettings.getUIDetails((String)dev.getDeviceId()));
        });
    }

    boolean runWithoutSavingInstance(Job job, TaskInstance instance, String deviceId) {
        boolean ret = this.endpointService.informJobAvailable(deviceId, Collections.singletonList(job), ProxySettings.getUIDetails((String)deviceId));
        if (ret) {
            this.auditLog.instanceCreated(instance);
        }
        return ret;
    }

    public Optional<TaskInstance> runConfirmCommand(String createdBy, String searchInstanceId, String[] otherTaskIds, JobPriority priority, String deviceId, List<MatchStored> res, String filePath, String subPath) {
        List list = this.resultsStore.getResultsForTaskInstanceAndDeviceAndFile(searchInstanceId, deviceId, filePath);
        NamedArea area = null;
        String confirmPath = filePath;
        if (!list.isEmpty()) {
            SearchResultStored br = (SearchResultStored)list.get(0);
            area = br.getNamedArea();
            confirmPath = br.getConfirmPath();
        }
        ConfirmCommand com = new ConfirmCommand(searchInstanceId, otherTaskIds, deviceId, this.patternService.expandPatternMatches(res), filePath, subPath, confirmPath, area);
        TaskTemplate templ = this.taskStore.getConfirmJobsTemplate();
        TaskInstance plan = TaskInstance.createTransientTask(null, (String)createdBy, (BaseCommand)com, (String)("confirm " + searchInstanceId), (JobPriority)priority, (TaskTemplate)templ);
        Job job = plan.createJobForDevice(deviceId);
        boolean ret = this.runWithoutSavingInstance(job, plan, deviceId);
        if (ret) {
            return Optional.of(plan);
        }
        return Optional.empty();
    }

    public TaskInstance runQuarantineCommand(String createdBy, String deviceId, QuarantineAction action, String filePath, String qPath, boolean alertWhenDone, String groupName, Long searchResultId) {
        QuarantineCommand com = new QuarantineCommand(searchResultId, action, filePath, qPath, groupName);
        TaskTemplate templ = this.taskStore.getPerformActionsTemplate();
        TaskInstance plan = TaskInstance.create(null, (String)createdBy, (BaseCommand)com, (String)("quarantine-" + deviceId + filePath), (JobPriority)JobPriority.HIGH, (boolean)false, (TaskTemplate)templ, (boolean)alertWhenDone, (boolean)true);
        Optional reg = this.endpointService.getDeviceFromId(deviceId, false);
        this.createJobForDevice(plan, (DeviceRegistration)reg.get());
        this.run(templ, plan, true);
        return plan;
    }

    public TaskInstance runCommandOnDevices(String createdBy, TaskTemplate template, String planName, JobPriority priority, List<String> deviceIds, boolean alertWhenJobIsDone, boolean partial, boolean ignoreQuietTime) {
        Optional opt = this.pathCollectionController.getIgnorePathsForTemplate(template);
        ActionIgnorePaths ignorePaths = null;
        if (opt.isPresent()) {
            ignorePaths = ((PathCollection)opt.get()).toActionIgnorePaths();
        }
        TaskInstance plan = partial ? TaskInstance.createPartial((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)template.getBaseCommand(), (String)planName, (JobPriority)priority, (boolean)false, (TaskTemplate)template, (boolean)alertWhenJobIsDone, (boolean)ignoreQuietTime) : TaskInstance.create((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)template.getBaseCommand(), (String)planName, (JobPriority)priority, (boolean)false, (TaskTemplate)template, (boolean)alertWhenJobIsDone, (boolean)ignoreQuietTime);
        for (String id : deviceIds) {
            Optional reg = this.endpointService.getDeviceFromId(id, false);
            if (reg.isEmpty()) {
                LOG.log(Level.WARNING, "device not found on run on deviceId {0}", id);
                continue;
            }
            this.createJobForDevice(plan, (DeviceRegistration)reg.get());
        }
        this.run(template, plan, ignoreQuietTime);
        return plan;
    }

    public TaskInstance runCommandOnAllDevices(String createdBy, TaskTemplate template, String planName, JobPriority priority, boolean alertWhenJobIsDone, boolean partial, boolean ignoreQuietTime) {
        Optional opt = this.pathCollectionController.getIgnorePathsForTemplate(template);
        ActionIgnorePaths ignorePaths = null;
        if (opt.isPresent()) {
            ignorePaths = ((PathCollection)opt.get()).toActionIgnorePaths();
        }
        TaskInstance plan = partial ? TaskInstance.createPartial((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)template.getBaseCommand(), (String)planName, (JobPriority)priority, (boolean)true, (TaskTemplate)template, (boolean)alertWhenJobIsDone, (boolean)ignoreQuietTime) : TaskInstance.create((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)template.getBaseCommand(), (String)planName, (JobPriority)priority, (boolean)true, (TaskTemplate)template, (boolean)alertWhenJobIsDone, (boolean)ignoreQuietTime);
        List all = this.endpointService.getAllDevices(false);
        for (DeviceRegistration reg : all) {
            DeviceType type = reg.getDeviceType();
            Set subs = reg.getDeviceSubTypesCollection();
            boolean jobTypeMatchesDeviceType = template.getBaseCommand().getRoutableConfig().isPresent() ? ((IRouteableSearchConfig)template.getBaseCommand().getRoutableConfig().get()).jobIsForDeviceType(type, subs) : JobRunner.jobTypeCanRunOnDeviceType((TaskInstance)plan, (DeviceType)type);
            if (!reg.isValidated() || !jobTypeMatchesDeviceType) continue;
            this.createJobForDevice(plan, reg);
        }
        this.run(template, plan, ignoreQuietTime);
        return plan;
    }

    public Job createJobForDevice(TaskInstance inst, DeviceRegistration reg) {
        Job ret = inst.createJobForDevice(reg.getDeviceId());
        this.jobStateManager.createJobState(inst, reg);
        return ret;
    }

    public static boolean jobTypeCanRunOnDeviceType(TaskInstance inst, DeviceType deviceType) {
        BaseCommand.CommandType jobType = inst.getCommandType();
        boolean alf = false;
        boolean endpoint = false;
        boolean o365 = false;
        boolean google = false;
        boolean atlassian = false;
        if (jobType.equals((Object)BaseCommand.CommandType.DATABASE_SEARCH)) {
            return true;
        }
        if (inst.getCommand().getRoutableConfig().isPresent()) {
            IRouteableSearchConfig config = (IRouteableSearchConfig)inst.getCommand().getRoutableConfig().get();
            alf = config.getAlfrescoConfig().isPresent();
            endpoint = config.getEndpointRTConfig().isPresent() || config.getEndpointSearchConfig().isPresent();
            o365 = config.getO365Config().isPresent();
            atlassian = config.getAtlassianConfig().isPresent();
            google = config.getGoogleConfig().isPresent();
        }
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[deviceType.ordinal()]) {
            case 1: {
                return alf || jobType.equals((Object)BaseCommand.CommandType.PERFORM_ACTIONS) || jobType.equals((Object)BaseCommand.CommandType.CONFIRM) || jobType.equals((Object)BaseCommand.CommandType.PROTECT);
            }
            case 2: {
                return atlassian || jobType.equals((Object)BaseCommand.CommandType.PERFORM_ACTIONS) || jobType.equals((Object)BaseCommand.CommandType.CONFIRM) || jobType.equals((Object)BaseCommand.CommandType.PROTECT);
            }
            case 3: {
                return o365 || jobType.equals((Object)BaseCommand.CommandType.PERFORM_ACTIONS) || jobType.equals((Object)BaseCommand.CommandType.CONFIRM) || jobType.equals((Object)BaseCommand.CommandType.PROTECT);
            }
            case 4: {
                return google || jobType.equals((Object)BaseCommand.CommandType.PERFORM_ACTIONS) || jobType.equals((Object)BaseCommand.CommandType.CONFIRM) || jobType.equals((Object)BaseCommand.CommandType.PROTECT);
            }
            case 5: 
            case 6: {
                return endpoint || jobType.equals((Object)BaseCommand.CommandType.CONFIRM) || jobType.equals((Object)BaseCommand.CommandType.PROTECT) || jobType.equals((Object)BaseCommand.CommandType.QUARANTINE);
            }
        }
        LOG.log(Level.SEVERE, "unknown devicetype in jobTypeMatchesDeviceType {0}", deviceType);
        return false;
    }
}

