/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.RetrievalSearchCommand;
import com.geolang.ascema.managerdomain.domain.SubRepoTask;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRepositoryDetails;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipHelper {
    private static final Logger LOG = Logger.getLogger(ZipHelper.class.getName());
    private final TaskManager taskManager;

    ZipHelper(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    Optional<File> getRepoFolder(String instanceId, String subSearchId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to get task instance in downloadZip {0}", instanceId);
            return Optional.empty();
        }
        TaskInstance inst = (TaskInstance)opt.get();
        TaskTemplate template = this.taskManager.getTemplateFromId(inst.getParentTemplateId());
        if (template == null) {
            LOG.log(Level.WARNING, "Failed to get task template {0}", inst.getParentTemplateId());
            return Optional.empty();
        }
        BaseCommand base = inst.getCommand();
        if (!base.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
            LOG.log(Level.WARNING, "Not a retrieval command? {0}", base.getCommandType());
            return Optional.empty();
        }
        RetrievalSearchCommand rcom = (RetrievalSearchCommand)base;
        if (subSearchId == null || subSearchId.isEmpty()) {
            String path = FileRepositoryDetails.getFolderPathForInstance((String)rcom.getDataFolder(), (String)template.getDisplayName(), (Date)inst.getCreated());
            return Optional.of(new File(path));
        }
        for (SubRepoTask task : inst.getsubRepoTasks()) {
            if (!task.getUid().equals(subSearchId)) continue;
            String path = FileRepositoryDetails.getFolderPathForSubRepo((String)rcom.getDataFolder(), (String)template.getDisplayName(), (Date)inst.getCreated(), (String)task.getDisplayName());
            return Optional.of(new File(path));
        }
        LOG.log(Level.WARNING, "Failed to find sub search {0}", subSearchId);
        return Optional.empty();
    }

    void zipFileFromListOfFiles(ByteArrayOutputStream out, Path root, List<File> files, String pass, boolean encrypt) throws IOException {
        byte[] buff = new byte[4096];
        ZipParameters zipParameters = this.buildZipParameters(encrypt);
        try (ZipOutputStream zos = this.initializeZipOutputStream(out, encrypt, pass);){
            for (File fileToAdd : files) {
                Path relativePath = root.relativize(fileToAdd.toPath());
                zipParameters.setFileNameInZip(relativePath.toString());
                zos.putNextEntry(zipParameters);
                try (FileInputStream inputStream = new FileInputStream(fileToAdd);){
                    int readLen;
                    while ((readLen = ((InputStream)inputStream).read(buff)) != -1) {
                        zos.write(buff, 0, readLen);
                    }
                }
                zos.closeEntry();
            }
        }
    }

    private ZipOutputStream initializeZipOutputStream(ByteArrayOutputStream out, boolean encrypt, String password) throws IOException {
        if (encrypt) {
            return new ZipOutputStream((OutputStream)out, password.toCharArray());
        }
        return new ZipOutputStream((OutputStream)out);
    }

    private ZipParameters buildZipParameters(boolean encrypt) {
        ZipParameters zipParameters = new ZipParameters();
        if (encrypt) {
            zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            zipParameters.setEncryptFiles(encrypt);
        }
        zipParameters.setIncludeRootFolder(true);
        return zipParameters;
    }
}

