/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.managercore.settings.Platform;
import com.geolang.ascema.managerservice.controllers.retrieval.SystemFolders;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemFolders {
    private final Set<String> sysfolders = new HashSet();
    private static final Logger LOG = Logger.getLogger(SystemFolders.class.getName());

    public static SystemFolders getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private SystemFolders() {
        Platform platform = Platform.getPlatform();
        switch (1.$SwitchMap$com$geolang$ascema$managercore$settings$Platform[platform.ordinal()]) {
            case 1: {
                this.populateWindows();
                break;
            }
            case 2: {
                this.populateOSX();
                break;
            }
            case 3: 
            case 4: {
                this.populateLinux();
                break;
            }
            default: {
                Logger.getLogger(SystemFolders.class.getName()).log(Level.SEVERE, "Platform not supported! {0}", platform);
                throw new RuntimeException("Unsupported platform");
            }
        }
    }

    public boolean isHidden(Path p) {
        Path root = p.getRoot();
        for (int i = 1; i <= p.getNameCount(); ++i) {
            Path part = root.resolve(p.subpath(0, i));
            if (!this.partIsHidden(part)) continue;
            return true;
        }
        return false;
    }

    private boolean partIsHidden(Path p) {
        if (p == null) {
            return false;
        }
        boolean isHidden = p.toFile().isHidden();
        if (isHidden && this.isRoot(p.toFile())) {
            isHidden = false;
        }
        if (!isHidden) {
            Path dir = p.getName(p.getNameCount() - 1);
            isHidden = dir.toString().startsWith(".");
        }
        return isHidden;
    }

    private boolean isRoot(File file) {
        File[] roots;
        for (File root : roots = File.listRoots()) {
            if (!file.equals(root)) continue;
            return true;
        }
        return false;
    }

    public boolean isSystemFolder(Path p) {
        return this.isSystemFolder(p.toString());
    }

    public boolean isSystemFolder(String p) {
        String tocheck = p.toLowerCase();
        return this.sysfolders.stream().anyMatch(s -> tocheck.startsWith((String)s));
    }

    private void populateWindows() {
        Object sysdrive;
        String progfiles2;
        String progfiles;
        String windir = System.getenv("windir");
        if (windir != null) {
            this.sysfolders.add(windir.toLowerCase());
        }
        if ((progfiles = System.getenv("ProgramFiles")) != null) {
            this.sysfolders.add(progfiles.toLowerCase());
        }
        if ((progfiles2 = System.getenv("ProgramFiles(x86)")) != null) {
            this.sysfolders.add(progfiles2.toLowerCase());
        }
        if ((sysdrive = System.getenv("SystemDrive")) == null) {
            LOG.warning("SystemDrive not set");
            return;
        }
        sysdrive = ((String)sysdrive).toLowerCase() + File.separator;
        this.sysfolders.add((String)sysdrive + "windows.old");
        this.sysfolders.add((String)sysdrive + "config.msi");
        this.sysfolders.add((String)sysdrive + "$recycle.bin");
        this.sysfolders.add((String)sysdrive + "intel");
        this.sysfolders.add((String)sysdrive + "drivers");
        this.sysfolders.add((String)sysdrive + "recovery");
        this.sysfolders.add((String)sysdrive + "system volume information");
    }

    private void populateOSX() {
        this.sysfolders.add("/system");
        this.sysfolders.add("/applications");
        this.sysfolders.add("/developer");
        this.sysfolders.add("/network");
        this.sysfolders.add("/bin");
        this.sysfolders.add("/etc");
        this.sysfolders.add("/dev");
        this.sysfolders.add("/usr");
        this.sysfolders.add("/sbin");
        this.sysfolders.add("/private");
        this.sysfolders.add("/library");
    }

    private void populateLinux() {
        this.sysfolders.add("/bin");
        this.sysfolders.add("/boot");
        this.sysfolders.add("/etc");
        this.sysfolders.add("/dev");
        this.sysfolders.add("/lib");
        this.sysfolders.add("/lib64");
        this.sysfolders.add("/opt");
        this.sysfolders.add("/proc");
        this.sysfolders.add("/run");
        this.sysfolders.add("/sbin");
        this.sysfolders.add("/svr");
        this.sysfolders.add("/sys");
        this.sysfolders.add("/tmp");
        this.sysfolders.add("/usr");
        this.sysfolders.add("/var");
    }
}

