/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.RetrievalSearchCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.EndpointSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.domain.SubRepoTask;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.retrieval.CreateSubRepoCommand;
import com.geolang.ascema.managerdomain.retrieval.SubSearchCommand;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRepositoryDetails;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubTaskCreator {
    private static final Logger LOG = Logger.getLogger(SubTaskCreator.class.getName());
    @Autowired
    private TaskManager taskManager;

    public Optional<SubRepoTask> addSubSearchToInstance(String createdBy, EndpointSearchConfiguration config, SearchFilterCommon common, String subtaskName, String retrievaltaskInstanceId) {
        Optional opt = this.taskManager.getTaskInstanceFromIdWithoutCache(retrievaltaskInstanceId);
        if (!opt.isPresent()) {
            LOG.warning("No retrieval task to add sub search task");
            return Optional.empty();
        }
        TaskInstance inst = (TaskInstance)opt.get();
        TaskTemplate template = this.taskManager.getTemplateFromId(inst.getParentTemplateId());
        if (template == null) {
            LOG.log(Level.WARNING, "Failed to get task template {0}", inst.getParentTemplateId());
            return Optional.empty();
        }
        BaseCommand bc = inst.getCommand();
        if (!bc.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
            LOG.warning("Not a retrieval task");
            return Optional.empty();
        }
        RetrievalSearchCommand rc = (RetrievalSearchCommand)bc;
        String folder = FileRepositoryDetails.getFolderPathForSubRepo((String)rc.getDataFolder(), (String)template.getDisplayName(), (Date)inst.getCreated(), (String)subtaskName);
        SubSearchCommand ssc = new SubSearchCommand(config, common, folder);
        SubRepoTask task = new SubRepoTask(retrievaltaskInstanceId, ssc, subtaskName);
        inst.addsubRepoTask(task);
        this.taskManager.updateInstance(inst);
        return Optional.of(task);
    }

    public Optional<SubRepoTask> addSubSearchToSubSearch(String createdBy, EndpointSearchConfiguration config, SearchFilterCommon common, String subTaskName, String retrievaltaskInstanceId, String parentSubSearchId) {
        Optional opt = this.taskManager.getTaskInstanceFromIdWithoutCache(retrievaltaskInstanceId);
        if (!opt.isPresent()) {
            LOG.warning("No retrieval task to add sub search task");
            return Optional.empty();
        }
        TaskInstance inst = (TaskInstance)opt.get();
        TaskTemplate template = this.taskManager.getTemplateFromId(inst.getParentTemplateId());
        if (template == null) {
            LOG.log(Level.WARNING, "Failed to get task template {0}", inst.getParentTemplateId());
            return Optional.empty();
        }
        BaseCommand bc = inst.getCommand();
        if (!bc.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
            LOG.warning("Not a retrieval task");
            return Optional.empty();
        }
        RetrievalSearchCommand rc = (RetrievalSearchCommand)bc;
        String folder = FileRepositoryDetails.getFolderPathForSubRepo((String)rc.getDataFolder(), (String)template.getDisplayName(), (Date)inst.getCreated(), (String)subTaskName);
        SubSearchCommand ssc = new SubSearchCommand(config, common, folder);
        SubRepoTask task = new SubRepoTask(retrievaltaskInstanceId, parentSubSearchId, ssc, subTaskName);
        inst.addsubRepoTask(task);
        this.taskManager.updateInstance(inst);
        return Optional.of(task);
    }

    public Optional<SubRepoTask> addCreateRepoTaskToInstance(String createdBy, String[] paths, boolean selectAll, String subTaskName, String retrievaltaskInstanceId) {
        Optional opt = this.taskManager.getTaskInstanceFromIdWithoutCache(retrievaltaskInstanceId);
        if (!opt.isPresent()) {
            LOG.warning("No retrieval task to add sub search task");
            return Optional.empty();
        }
        TaskInstance inst = (TaskInstance)opt.get();
        TaskTemplate template = this.taskManager.getTemplateFromId(inst.getParentTemplateId());
        if (template == null) {
            LOG.log(Level.WARNING, "Failed to get task template {0}", inst.getParentTemplateId());
            return Optional.empty();
        }
        BaseCommand bc = inst.getCommand();
        if (!bc.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
            LOG.warning("Not a retrieval task");
            return Optional.empty();
        }
        RetrievalSearchCommand rc = (RetrievalSearchCommand)bc;
        String folder = FileRepositoryDetails.getFolderPathForSubRepo((String)rc.getDataFolder(), (String)template.getDisplayName(), (Date)inst.getCreated(), (String)subTaskName);
        CreateSubRepoCommand ssc = new CreateSubRepoCommand(folder, paths, selectAll);
        SubRepoTask task = new SubRepoTask(retrievaltaskInstanceId, ssc, subTaskName);
        inst.addsubRepoTask(task);
        this.taskManager.updateInstance(inst);
        return Optional.of(task);
    }

    public Optional<SubRepoTask> addCreateRepoTaskToSubSearch(String createdBy, String[] paths, boolean selectAll, String subtaskName, String retrievaltaskInstanceId, String parentSubSearchId) {
        Optional opt = this.taskManager.getTaskInstanceFromIdWithoutCache(retrievaltaskInstanceId);
        if (!opt.isPresent()) {
            LOG.warning("No retrieval task to add sub search task");
            return Optional.empty();
        }
        TaskInstance inst = (TaskInstance)opt.get();
        TaskTemplate template = this.taskManager.getTemplateFromId(inst.getParentTemplateId());
        if (template == null) {
            LOG.log(Level.WARNING, "Failed to get task template {0}", inst.getParentTemplateId());
            return Optional.empty();
        }
        BaseCommand bc = inst.getCommand();
        if (!bc.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
            LOG.warning("Not a retrieval task");
            return Optional.empty();
        }
        RetrievalSearchCommand rc = (RetrievalSearchCommand)bc;
        String folder = FileRepositoryDetails.getFolderPathForSubRepo((String)rc.getDataFolder(), (String)template.getDisplayName(), (Date)inst.getCreated(), (String)subtaskName);
        CreateSubRepoCommand ssc = new CreateSubRepoCommand(folder, paths, selectAll);
        SubRepoTask task = new SubRepoTask(retrievaltaskInstanceId, parentSubSearchId, ssc, subtaskName);
        inst.addsubRepoTask(task);
        this.taskManager.updateInstance(inst);
        return Optional.of(task);
    }
}

