/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.endpointcommon.domain.PatternConfig;
import com.geolang.ascema.managerservice.controllers.retrieval.SubSearchManager;
import com.geolang.ascema.patternmatching.Matcher;
import com.geolang.ascema.patternmatching.internal.PatternCheckCollection;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;

public class SubSearchRunner {
    private final Tika tika = new Tika();
    private final Map<Path, List<PatternMatchResult>> resultCache = new HashMap();

    List<PatternMatchResult> getMatching(Path path, String filename, Collection<PatternConfig> patternConfigs) throws IOException {
        if (this.resultCache.containsKey(path)) {
            return (List)this.resultCache.get(path);
        }
        String parsedText = this.readFileContents(path);
        List raw = Matcher.getResult((String)filename, (String)"", (String)parsedText, (PatternCheckCollection)new PatternCheckCollection(patternConfigs, false));
        if (raw == null) {
            return Collections.emptyList();
        }
        Map matchTotals = this.getNumMatchesPerPattern(raw);
        ArrayList<PatternMatchResult> filtered = new ArrayList<PatternMatchResult>();
        for (PatternMatchResult pmr : raw) {
            PatternConfig patConfig = this.getPatternConfigFromName(pmr.getName(), patternConfigs);
            int minMatches = patConfig.getMinMatches();
            if ((Integer)matchTotals.get(pmr.getName()) < minMatches || pmr.getConfidence().ordinal() < patConfig.getConfidence().ordinal()) continue;
            filtered.add(pmr);
        }
        this.resultCache.put(path, filtered);
        return filtered;
    }

    private String readFileContents(Path path) throws IOException {
        try {
            return this.tika.parseToString(path.toFile());
        }
        catch (TikaException ex) {
            Logger.getLogger(SubSearchManager.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    private Map<String, Integer> getNumMatchesPerPattern(List<PatternMatchResult> pats) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (PatternMatchResult res : pats) {
            Integer i;
            Integer n = i = ret.getOrDefault(res.getName(), 0);
            i = i + 1;
            ret.put(res.getName(), i);
        }
        return ret;
    }

    private PatternConfig getPatternConfigFromName(String patternName, Collection<PatternConfig> patternConfigs) {
        for (PatternConfig pc : patternConfigs) {
            if (!pc.getName().equals(patternName)) continue;
            return pc;
        }
        return null;
    }
}

