/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.domainmodelpublic.IPatternMatchResult;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.endpointcommon.domain.FileDates;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.RetrievalMatchStored;
import com.geolang.ascema.managerdomain.domain.RetrievalResultStored;
import com.geolang.ascema.managerdomain.domain.SubRepoTask;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.dto.GroupBy;
import com.geolang.ascema.managerdomain.retrieval.CreateSubRepoCommand;
import com.geolang.ascema.managerdomain.retrieval.SubSearchCommand;
import com.geolang.ascema.managerdomain.web.results.DataRequest;
import com.geolang.ascema.managerdomain.web.results.DataRequestFilter;
import com.geolang.ascema.managerevents.ResultsAvailableEvent;
import com.geolang.ascema.managerpersistence.StoredRetrievalResultStore;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.DataPointSlice;
import com.geolang.ascema.managerpersistence.results.MatchesManager;
import com.geolang.ascema.managerpersistence.results.datapoint.DataPointManager;
import com.geolang.ascema.managerservice.controllers.retrieval.SubSearchRunner;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SubSearchManager {
    private static final Logger LOG = Logger.getLogger(SubSearchManager.class.getName());
    @Autowired
    private StoredRetrievalResultStore resultsStore;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private MatchesManager matchManager;
    @Autowired
    private DataPointManager pageCache;

    public Optional<TaskInstance> getSubSearchTasksParentForInstance(String retrievalTaskInstanceId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(retrievalTaskInstanceId);
        if (!opt.isPresent()) {
            LOG.warning("No retrieval task to get sub search task");
        }
        return opt;
    }

    public boolean templateExists(String parentTaskId, String name) {
        Optional opt = this.taskManager.getTaskInstanceFromId(parentTaskId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "No retrieval task to get template exists {0}", parentTaskId);
            return true;
        }
        for (SubRepoTask ss : ((TaskInstance)opt.get()).getsubRepoTasks()) {
            if (!ss.getDisplayName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Transactional(readOnly=true)
    public Optional<DataPointSlice> getResultsSlice(boolean forceRefresh, String taskId, String subSearchTaskId, String filterString, GroupBy groupby, int start, int rows) {
        DataRequestFilter filter = new DataRequestFilter(filterString, Collections.singletonList(ResultStatus.FOUND.toString()), false, true);
        DataRequest dr = DataRequest.buildForInstances(Collections.singletonList(subSearchTaskId), (DataRequestFilter)filter, (GroupBy)groupby, (int)start, (int)rows);
        return this.pageCache.getResultsSlice(dr);
    }

    @Transactional(readOnly=true)
    public List<DataPoint> getSubSlice(String taskId, String subSearchTaskId, String key, String filterString, GroupBy groupBy, int subStart, int subRows) {
        DataRequestFilter filter = new DataRequestFilter(filterString, Collections.singletonList(ResultStatus.FOUND.toString()), false, true);
        DataRequest dr = DataRequest.buildForSubSlice(Collections.singletonList(subSearchTaskId), (String)key, (DataRequestFilter)filter, (GroupBy)groupBy, (int)subStart, (int)subRows);
        return this.pageCache.getSubSlice(dr);
    }

    @Async
    @Transactional(readOnly=false)
    public void createRepoFromRepo(SubRepoTask ssTask) {
        if (!ssTask.isRepoFromSelected()) {
            LOG.severe("Not a repo from repo task!");
            return;
        }
        Optional topt = ssTask.getCreateSubRepoCommand();
        if (!topt.isPresent()) {
            LOG.severe("no command in task?");
            return;
        }
        CreateSubRepoCommand command = (CreateSubRepoCommand)topt.get();
        LOG.log(Level.INFO, "Start create repo from selected files {0}", ssTask.getDisplayName());
        String parentObjectId = ssTask.getParentSubRepoTaskId() != null && !ssTask.getParentSubRepoTaskId().isEmpty() ? ssTask.getParentSubRepoTaskId() : ssTask.getParentInstanceId();
        AtomicInteger count = new AtomicInteger();
        AtomicInteger added = new AtomicInteger();
        List list = this.resultsStore.getResultsForTaskInstance(parentObjectId);
        for (RetrievalResultStored rr : list) {
            count.incrementAndGet();
            try {
                if (!command.isSelectAll() && !command.getPaths().contains(rr.getRepoPath())) continue;
                ArrayList matches = new ArrayList();
                this.matchManager.getAllRetrievalResultsStream(rr.getId()).forEach(match -> matches.add(new RetrievalMatchStored((IPatternMatchResult)match)));
                RetrievalResultStored newResult = new RetrievalResultStored(rr, ssTask.getUid());
                this.resultsStore.updateResult(newResult, matches);
                this.createLinkToFile(rr.getRepoPath(), command.getDataFolder());
                MessageBus.getBus().post((Object)new ResultsAvailableEvent(newResult.getJobId(), newResult.getDeviceId()));
                added.incrementAndGet();
            }
            catch (IOException ex) {
                Logger.getLogger(SubSearchManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        LOG.log(Level.INFO, "Finished sub search task {0}.  Processed {1} Added {2}", new Object[]{ssTask.getDisplayName(), count.toString(), added.toString()});
    }

    @Async
    @Transactional(readOnly=false)
    public void createRepoFromSearch(SubRepoTask ssTask) {
        try {
            if (!ssTask.isRepoFromSubSearch()) {
                LOG.severe("Not a sub search task!");
                return;
            }
            Optional topt = ssTask.getSubSearchCommand();
            if (!topt.isPresent()) {
                LOG.severe("no command in task?");
                return;
            }
            LOG.log(Level.INFO, "Start sub search {0}", ssTask.getDisplayName());
            String parentObjectId = ssTask.getParentSubRepoTaskId() != null && !ssTask.getParentSubRepoTaskId().isEmpty() ? ssTask.getParentSubRepoTaskId() : ssTask.getParentInstanceId();
            SubSearchCommand command = (SubSearchCommand)topt.get();
            Collection patternConfig = command.getSearchCommon().getPatterns();
            AtomicInteger count = new AtomicInteger();
            AtomicInteger added = new AtomicInteger();
            SubSearchRunner runner = new SubSearchRunner();
            List list = this.resultsStore.getResultsForTaskInstance(parentObjectId);
            for (RetrievalResultStored rr : list) {
                count.incrementAndGet();
                if (!this.shouldProcess(rr, (SubSearchCommand)topt.get())) continue;
                try {
                    List newMatches = runner.getMatching(Paths.get(rr.getStoredPath(), new String[0]), rr.getStoredFilename(), patternConfig);
                    if (newMatches.isEmpty()) continue;
                    RetrievalResultStored newResult = new RetrievalResultStored(rr, ssTask.getUid());
                    String newRepoPath = this.createLinkToFile(rr.getStoredPath(), command.getDataFolder());
                    newResult.setStoredPath(newRepoPath);
                    this.resultsStore.updateNewResult(newResult, newMatches);
                    MessageBus.getBus().post((Object)new ResultsAvailableEvent(newResult.getJobId(), newResult.getDeviceId()));
                    added.incrementAndGet();
                }
                catch (IOException ex) {
                    Logger.getLogger(SubSearchManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            LOG.log(Level.INFO, "Finished sub search task {0}.  Processed {1} Added {2}", new Object[]{ssTask.getDisplayName(), count.toString(), added.toString()});
        }
        catch (Exception ex) {
            Logger.getLogger(SubSearchManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean shouldProcess(RetrievalResultStored sr, SubSearchCommand command) {
        FileDates dates = sr.getFileDates();
        Optional optCreate = dates.getCreated();
        Instant created = optCreate.isPresent() ? (Instant)optCreate.get() : null;
        Instant modified = dates.getModified();
        boolean datesOk = this.datesOK(command.getSearchCommon(), modified, created);
        if (!datesOk) {
            LOG.log(Level.INFO, "ignore {0} for dates", sr.getStoredPath());
            return false;
        }
        if (!command.getSearchCommon().isAllFileExtensions()) {
            String name = sr.getStoredFilename();
            try {
                String ext = FilenameUtils.getExtension((String)name);
                Set fileExts = command.getSearchCommon().getExtensions();
                if (!fileExts.contains(ext)) {
                    LOG.log(Level.INFO, "ignore {0} for file extension", sr.getStoredPath());
                    return false;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "{0} {1}", new Object[]{name, e.getMessage()});
                return false;
            }
        }
        return true;
    }

    private boolean datesOK(SearchFilterCommon searchCommon, Instant ftModify, Instant ftCreate) {
        Optional endday;
        Optional startday;
        Optional endcreateday;
        Instant startModify = null;
        Instant endModify = null;
        Instant startCreate = null;
        Instant endCreate = null;
        Optional startcreateday = searchCommon.getStartCreateDate();
        ZoneOffset offset = OffsetDateTime.now().getOffset();
        if (startcreateday.isPresent()) {
            startCreate = ((LocalDate)startcreateday.get()).atStartOfDay().toInstant(offset);
        }
        if ((endcreateday = searchCommon.getEndCreateDate()).isPresent()) {
            endCreate = ((LocalDate)endcreateday.get()).atStartOfDay().plusDays(1L).toInstant(offset);
        }
        if ((startday = searchCommon.getStartModifyDate()).isPresent()) {
            startModify = ((LocalDate)startday.get()).atStartOfDay().toInstant(offset);
        }
        if ((endday = searchCommon.getEndModifyDate()).isPresent()) {
            endModify = ((LocalDate)endday.get()).atStartOfDay().plusDays(1L).toInstant(offset);
        }
        if (ftModify != null) {
            if (startModify != null && startModify.isAfter(ftModify)) {
                return false;
            }
            if (endModify != null && endModify.isBefore(ftModify)) {
                return false;
            }
        }
        if (ftCreate != null) {
            if (startCreate != null && startCreate.isAfter(ftCreate)) {
                return false;
            }
            return endCreate == null || !endCreate.isBefore(ftCreate);
        }
        return true;
    }

    private String createLinkToFile(String storedPath, String dataFolder) throws IOException {
        boolean OK;
        File folder = new File(dataFolder);
        if (!folder.exists() && !(OK = folder.mkdirs())) {
            LOG.log(Level.WARNING, "Failed to create folder {0}", dataFolder);
            throw new IOException("Failed to create folder " + dataFolder);
        }
        Path target = Paths.get(storedPath, new String[0]);
        Path link = Paths.get(folder.getAbsolutePath(), target.getFileName().toString());
        Path ret = null;
        if (!link.toFile().exists()) {
            try {
                ret = Files.createSymbolicLink(link, target, new FileAttribute[0]);
            }
            catch (IOException | SecurityException ex) {
                LOG.log(Level.INFO, "Failed to create symlink {0} - copying the file instead", ex.getLocalizedMessage());
                ret = Files.copy(target, link, new CopyOption[0]);
            }
        } else {
            ret = link.toAbsolutePath();
        }
        if (ret != null) {
            return ret.toString();
        }
        return "";
    }
}

