/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.endpointcommon.discovery.encrypt.MatchingTextEncryptor;
import com.geolang.ascema.managerdomain.domain.FileExtension;
import com.geolang.ascema.managerdomain.domain.RetrievalMatchStored;
import com.geolang.ascema.managerdomain.domain.RetrievalResultStored;
import com.geolang.ascema.managerdomain.dto.GroupBy;
import com.geolang.ascema.managerdomain.web.results.DataRequest;
import com.geolang.ascema.managerdomain.web.results.DataRequestFilter;
import com.geolang.ascema.managerpersistence.IRetrievalMatchRepository;
import com.geolang.ascema.managerpersistence.StoredRetrievalResultStore;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.DataPointSlice;
import com.geolang.ascema.managerpersistence.results.datapoint.DataPointManager;
import com.geolang.ascema.managerservice.rest.requests.retrieval.FileExtensionCount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RetrievalResultsManager {
    @Autowired
    private StoredRetrievalResultStore resultsStore;
    @Autowired
    private DataPointManager pageCache;
    @Autowired
    IRetrievalMatchRepository retrievalMatchRepo;

    @Transactional(readOnly=true)
    public List<DataPoint> getSubSlice(List<String> taskIds, String key, DataRequestFilter filter, GroupBy groupBy, int subStart, int subRows) {
        DataRequest dr = DataRequest.buildForSubSlice(taskIds, (String)key, (DataRequestFilter)filter, (GroupBy)groupBy, (int)subStart, (int)subRows);
        return this.pageCache.getSubSlice(dr);
    }

    @Transactional(readOnly=true)
    public Optional<DataPointSlice> getResultsSlice(boolean forceRefresh, List<String> taskIds, DataRequestFilter filter, GroupBy groupby, int start, int rows) {
        DataRequest dr = DataRequest.buildForInstances(taskIds, (DataRequestFilter)filter, (GroupBy)groupby, (int)start, (int)rows);
        return this.pageCache.getResultsSlice(dr);
    }

    @Transactional(readOnly=true)
    public List<FileExtensionCount> getExtensionCountsForRepo(String taskId) {
        HashMap map = new HashMap();
        try (Stream stream = this.resultsStore.stream(taskId);){
            stream.forEach(rr -> {
                String name = rr.getRepoPath();
                Object ext = FilenameUtils.getExtension((String)name);
                Object displayName = ext;
                if (((String)displayName).isEmpty()) {
                    displayName = "Files with no extension";
                }
                if (map.containsKey(displayName)) {
                    ((FileExtensionCount)map.get(displayName)).incrementCount();
                } else {
                    if (!((String)ext).isEmpty()) {
                        ext = "." + (String)ext;
                    }
                    map.put(displayName, new FileExtensionCount(new FileExtension((String)displayName, Collections.singleton(ext))));
                }
            });
        }
        return new ArrayList<FileExtensionCount>(map.values());
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public Optional<RetrievalResultStored> getResultById(Long id) {
        return this.resultsStore.getStoredResultById(id);
    }

    public Long getResultsCountForTaskInstance(String jobPlanId) {
        return this.resultsStore.getResultsCountForTaskInstance(jobPlanId);
    }

    public Optional<String> unRedactMatch(Long matchId) {
        Optional storedMatchOpt = this.retrievalMatchRepo.findById((Object)matchId);
        if (storedMatchOpt.isEmpty()) {
            return Optional.empty();
        }
        RetrievalMatchStored match = (RetrievalMatchStored)storedMatchOpt.get();
        Optional srOpt = this.getResultById(match.getSearchResultStoredId());
        if (srOpt.isEmpty()) {
            return Optional.empty();
        }
        RetrievalResultStored sr = (RetrievalResultStored)srOpt.get();
        MatchingTextEncryptor enc = new MatchingTextEncryptor(sr.getDeviceId());
        return Optional.of(enc.dec(match.getMatchingText()));
    }
}

