/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.RetrievalResult;
import com.geolang.ascema.endpointcommon.domain.RetrievalSearchCommand;
import com.geolang.ascema.endpointcommon.domain.SearchResult;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.SubRepoTask;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerevents.JobStateChangeEvent;
import com.geolang.ascema.managerevents.ResultsAvailableEvent;
import com.geolang.ascema.managerpersistence.EventHistoryStore;
import com.geolang.ascema.managerpersistence.StoredRetrievalResultStore;
import com.geolang.ascema.managerpersistence.serviceinterfaces.ITaskManager;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRepositoryDetails;
import com.geolang.ascema.managerservice.controllers.retrieval.SystemFolders;
import com.geolang.ascema.managerservice.controllers.retrieval.ZipHelper;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.rest.requests.retrieval.DownloadZipCommand;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileRetrievalManager {
    private static final Logger LOG = Logger.getLogger(FileRetrievalManager.class.getName());
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private StoredRetrievalResultStore resultsStore;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private EventHistoryStore eventHistoryStore;
    private final Map<String, FileRepositoryDetails> taskInstanceIdToRepositoryDetails = new HashMap();
    ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
        this.executor.shutdown();
    }

    @Subscribe
    public void handleJobChange(JobStateChangeEvent ev) {
        JobState state = ev.getState();
        String instanceId = ev.getTaskInstanceId();
        boolean isAllDone = ev.isAllDone();
        this.executor.schedule(() -> {
            if (state.equals((Object)JobState.DONE) && this.taskInstanceIdToRepositoryDetails.containsKey(instanceId)) {
                ((FileRepositoryDetails)this.taskInstanceIdToRepositoryDetails.get(instanceId)).setFinished();
                if (isAllDone) {
                    this.executor.schedule(() -> this.taskInstanceIdToRepositoryDetails.remove(instanceId), 30L, TimeUnit.SECONDS);
                }
            }
        }, 2L, TimeUnit.SECONDS);
    }

    public boolean addResult(RetrievalResult result) {
        String taskInstanceId = result.getJobId();
        FileRepositoryDetails details = this.getReposistoryDetailsforInstance(taskInstanceId);
        if (details == null) {
            return false;
        }
        boolean OK = details.writeFile(result);
        if (OK) {
            this.resultsStore.storeResultForTaskInstance(result);
            this.eventHistoryStore.addNewResults((ITaskManager)this.taskManager, (SearchResult)result);
            this.auditLog.retrievalAdded(this.taskManager, result);
            MessageBus.getBus().post((Object)new ResultsAvailableEvent((SearchResult)result));
        }
        return OK;
    }

    private synchronized FileRepositoryDetails getReposistoryDetailsforInstance(String instanceId) {
        FileRepositoryDetails details = (FileRepositoryDetails)this.taskInstanceIdToRepositoryDetails.get(instanceId);
        if (details == null) {
            Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
            if (!opt.isPresent()) {
                LOG.log(Level.WARNING, "Failed to get task instance {0}", instanceId);
                return null;
            }
            TaskTemplate template = this.taskManager.getTemplateFromId(((TaskInstance)opt.get()).getParentTemplateId());
            if (template == null) {
                LOG.log(Level.WARNING, "Failed to get task template {0}", ((TaskInstance)opt.get()).getParentTemplateId());
                return null;
            }
            BaseCommand base = template.getBaseCommand();
            if (!base.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
                LOG.log(Level.WARNING, "Not a retrieval command? {0}", base.getCommandType());
                return null;
            }
            RetrievalSearchCommand rcom = (RetrievalSearchCommand)base;
            try {
                details = new FileRepositoryDetails(rcom.getDataFolder(), template.getDisplayName(), ((TaskInstance)opt.get()).getCreated());
            }
            catch (FileRepositoryDetails.FileRepositoryDetailsException ex) {
                Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            this.taskInstanceIdToRepositoryDetails.put(instanceId, details);
            LOG.log(Level.INFO, "Data Folder Path {0}", details.getInstanceFolderPath());
        }
        return details;
    }

    public void openFile(ByteArrayOutputStream out, String path) {
        if (!this.isOnRepoPath(path)) {
            LOG.log(Level.WARNING, "Path is not in repo {0}", path);
            return;
        }
        if (SystemFolders.getInstance().isSystemFolder(path)) {
            LOG.log(Level.WARNING, "Path is system folder - not opening {0}", path);
            return;
        }
        File f = new File(path);
        if (!f.exists()) {
            LOG.log(Level.WARNING, "File not found {0}", path);
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
            int bytes;
            byte[] buffer = new byte[4096];
            while ((bytes = ((InputStream)in).read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, bytes);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void getZipFile(ByteArrayOutputStream out, DownloadZipCommand command) {
        ZipHelper helper = new ZipHelper(this.taskManager);
        LOG.log(Level.INFO, "Get Zip");
        ArrayList<File> files = new ArrayList<File>();
        Optional root = helper.getRepoFolder(command.getInstanceId(), command.getSubSearchId());
        if (!root.isPresent()) {
            LOG.warning("No root folder found");
            return;
        }
        if (command.isSelectAll()) {
            try {
                Files.walk(Paths.get(((File)root.get()).getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> files.add(f.toFile()));
            }
            catch (IOException ex) {
                Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        } else {
            for (String s : command.getRepoPaths()) {
                files.add(new File(s));
            }
        }
        try {
            helper.zipFileFromListOfFiles(out, ((File)root.get()).toPath(), files, command.getPassword(), command.isUsePassword());
        }
        catch (IOException ex) {
            Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean deleteTemplate(String name, String searchJobTemplateId, boolean deleteInstances, boolean deleteRepos) {
        TaskTemplate template = this.taskManager.getTemplateFromId(searchJobTemplateId);
        if (template == null) {
            LOG.log(Level.WARNING, "Failed to get task template for delete {0}", searchJobTemplateId);
            return false;
        }
        BaseCommand bc = template.getBaseCommand();
        if (!bc.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) {
            LOG.warning("Not a retrieval task");
            return false;
        }
        RetrievalSearchCommand rc = (RetrievalSearchCommand)bc;
        String folder = FileRepositoryDetails.getFolderPathForTemplate((String)rc.getDataFolder(), (String)template.getDisplayName());
        ArrayList instanceIds = new ArrayList(template.getInstanceIds());
        for (String inst : instanceIds) {
            this.deleteTaskInstance(name, inst, deleteRepos);
        }
        if (deleteRepos) {
            try {
                FileUtils.deleteDirectory((File)new File(folder));
            }
            catch (IOException ex) {
                Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, "Failed to delete template repo", ex.getLocalizedMessage());
            }
        }
        this.auditLog.templateDeleted(name, template);
        return this.taskManager.deleteTemplate(name, searchJobTemplateId);
    }

    public boolean deleteTaskInstance(String name, String instanceId, boolean deleteRepos) {
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to get task instance {0}", instanceId);
            return false;
        }
        FileRepositoryDetails details = this.getReposistoryDetailsforInstance(instanceId);
        if (details == null) {
            return false;
        }
        for (SubRepoTask sst : ((TaskInstance)opt.get()).getsubRepoTasks()) {
            this.resultsStore.deleteAllResultsForTaskInstance(sst.getUid());
        }
        this.resultsStore.deleteAllResultsForTaskInstance(instanceId);
        this.taskManager.deleteTaskInstance(name, instanceId);
        if (deleteRepos) {
            String path = details.getInstanceFolderPath();
            try {
                FileUtils.deleteDirectory((File)new File(path));
            }
            catch (IOException ex) {
                Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, "Failed to delete repo", ex);
            }
        }
        return true;
    }

    private boolean isOnRepoPath(String path) {
        ArrayList templates = this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL);
        for (TaskTemplate tt : templates) {
            Path root;
            RetrievalSearchCommand command = (RetrievalSearchCommand)tt.getBaseCommand();
            Path in = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            if (!in.startsWith(root = Paths.get(command.getDataFolder(), new String[0]))) continue;
            return true;
        }
        return false;
    }
}

