/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.retrieval;

import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.endpointcommon.domain.FileDates;
import com.geolang.ascema.endpointcommon.domain.RetrievalResult;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRepositoryDetails;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRetrievalManager;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileRepositoryDetails {
    private static final Logger LOG = Logger.getLogger(FileRepositoryDetails.class.getName());
    private static final String CSV_FILE = "FILE_DETAILS.csv";
    private final String instanceFolderPath;
    private String templateFolderPath;
    private final String dataFolder;
    private final HashFunction hf = Hashing.murmur3_128();
    private final List<ResultWrapper> results = new ArrayList();
    private final Map<String, Integer> filePathToIndex = new HashMap();
    private final Map<Long, Integer> checksumToIndex = new HashMap();
    private boolean dirty = false;

    FileRepositoryDetails(String dataFolder, String templateName, Date instanceDate) throws FileRepositoryDetailsException {
        boolean OK;
        this.dataFolder = dataFolder;
        this.instanceFolderPath = FileRepositoryDetails.getFolderPathForInstance((String)dataFolder, (String)templateName, (Date)instanceDate);
        File folder = new File(this.instanceFolderPath);
        if (!folder.exists() && !(OK = folder.mkdirs())) {
            LOG.log(Level.WARNING, "Failed to create folder {0}", this.instanceFolderPath);
            throw new FileRepositoryDetailsException("Failed to create folder");
        }
    }

    String getInstanceFolderPath() {
        return this.instanceFolderPath;
    }

    String getTemplateFolderPath() {
        return this.templateFolderPath;
    }

    public static String getFolderPathForInstance(String rootFolder, String templateName, Date instanceDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd@HH_mm_ss");
        String datePart = format.format(instanceDate);
        return rootFolder + File.separator + templateName + File.separator + datePart;
    }

    public static String getFolderPathForSubRepo(String rootFolder, String templateName, Date instanceDate, String subRepoName) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd@HH_mm_ss");
        String datePart = format.format(instanceDate);
        return rootFolder + File.separator + templateName + File.separator + datePart + File.separator + subRepoName;
    }

    public static String getFolderPathForTemplate(String rootFolder, String templateName) {
        return rootFolder + File.separator + templateName;
    }

    synchronized boolean writeFile(RetrievalResult result) {
        Path path;
        try {
            Path resultFilePath = Paths.get(result.getFilePath(), new String[0]);
            if (resultFilePath.getParent() != null && resultFilePath.getParent().toString().startsWith(this.dataFolder) && resultFilePath.toFile().exists()) {
                return false;
            }
        }
        catch (InvalidPathException resultFilePath) {
            // empty catch block
        }
        long checksum = this.hf.hashBytes(result.getContent()).asLong();
        String filename = result.getStoredFilename();
        try {
            filename = filename.replaceAll("[\\\\/:]", "_");
            path = Paths.get(this.getFolderForResult(result), filename);
            if (!path.toFile().getCanonicalPath().toLowerCase().equals(path.toAbsolutePath().toString().toLowerCase())) {
                LOG.warning("Relative path in filename - not resolving to path");
                return false;
            }
        }
        catch (FileRepositoryDetailsException | IOException ex) {
            Logger.getLogger(FileRepositoryDetails.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        if (this.checksumToIndex.containsKey(checksum)) {
            int index = (Integer)this.checksumToIndex.get(checksum);
            ResultWrapper fd = (ResultWrapper)this.results.get(index);
            result.setStoredPath(((RetrievalResult)fd.results.get(0)).getStoredPath());
            result.setStoredFilename(filename);
            result.setContent(new byte[0]);
            fd.results.add(result);
            return true;
        }
        if (this.filePathToIndex.containsKey(path.toString().toLowerCase())) {
            path = this.generateNewPath(path, filename);
        }
        try {
            Files.write(path, result.getContent(), StandardOpenOption.CREATE_NEW);
            result.setStoredPath(path.toString());
            result.setStoredFilename(filename);
            result.setContent(new byte[0]);
            ResultWrapper wrap = new ResultWrapper(result);
            this.results.add(wrap);
            int index = this.results.indexOf(wrap);
            this.checksumToIndex.put(checksum, index);
            this.filePathToIndex.put(path.toString().toLowerCase(), index);
            this.dirty = true;
        }
        catch (IOException ex) {
            Logger.getLogger(FileRetrievalManager.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    synchronized void setFinished() {
        if (this.dirty) {
            this.writeCsv();
            this.dirty = false;
        }
    }

    private String getFolderForResult(RetrievalResult result) throws FileRepositoryDetailsException {
        if (result.isIsEmail()) {
            return this.createFolder("email");
        }
        return switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$CloudPlatformAreaType[result.getNamedArea().getCloudAreaType().ordinal()]) {
            case 1 -> this.instanceFolderPath;
            default -> this.createFolder(result.getNamedArea().getCloudAreaType().toString());
        };
    }

    private String createFolder(String subPath) throws FileRepositoryDetailsException {
        boolean OK;
        String emailFolderPath = this.instanceFolderPath + File.separator + subPath;
        File folder = new File(emailFolderPath);
        if (!folder.exists() && !(OK = folder.mkdirs())) {
            LOG.log(Level.WARNING, "Failed to create folder {0}", emailFolderPath);
            throw new FileRepositoryDetailsException("Failed to create folder " + subPath);
        }
        return emailFolderPath;
    }

    private Path generateNewPath(Path path, String filename) {
        String newfileName = filename;
        String parent = path.getParent().toString();
        ResultWrapper fd = this.getDetailsForFilename(path);
        do {
            ++fd.renameCount;
            newfileName = this.rename(newfileName, fd.renameCount);
        } while (this.getDetailsForFilename(Paths.get(parent, newfileName)) != null);
        return Paths.get(parent, newfileName);
    }

    private String rename(String fileName, int count) {
        int extensionPos = fileName.lastIndexOf(".");
        String ext = "";
        String baseName = fileName;
        if (extensionPos > 0) {
            ext = fileName.substring(extensionPos);
            baseName = fileName.substring(0, extensionPos);
        }
        return baseName + "(" + count + ")" + ext;
    }

    private ResultWrapper getDetailsForFilename(Path path) {
        Integer index = (Integer)this.filePathToIndex.get(path.toString().toLowerCase());
        if (index == null) {
            return null;
        }
        return (ResultWrapper)this.results.get(index);
    }

    private void writeCsv() {
        Path path = Paths.get(this.instanceFolderPath, "FILE_DETAILS.csv");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(path.toString(), false), 1024);){
            bw.write("Repository Path, Device Name, Device FilePath, SubPath, File Created Date, File Modified Date, User, Info, Named Area, Pattern Match Summary, PatternMatches");
            bw.newLine();
            for (ResultWrapper wrap : this.results) {
                for (RetrievalResult res : wrap.results) {
                    bw.write(this.wrapInQuotes(res.getStoredPath()));
                    bw.write(",");
                    bw.write(this.wrapInQuotes(res.getDeviceName()));
                    bw.write(",");
                    bw.write(this.wrapInQuotes(res.getFilePath()));
                    bw.write(",");
                    bw.write(this.wrapInQuotes(res.getSubPath()));
                    bw.write(",");
                    FileDates dates = res.getFileDates();
                    if (dates != null) {
                        if (dates.getCreated().isPresent()) {
                            try {
                                String created = DateTimeFormatter.ISO_INSTANT.format((TemporalAccessor)dates.getCreated().get());
                                bw.write(this.wrapInQuotes(created));
                            }
                            catch (DateTimeException ex) {
                                LOG.warning(ex.getLocalizedMessage());
                                bw.write(this.wrapInQuotes(""));
                            }
                        } else {
                            bw.write(this.wrapInQuotes(""));
                        }
                        bw.write(",");
                        if (dates.getModified() != null) {
                            try {
                                String modified = DateTimeFormatter.ISO_INSTANT.format(dates.getModified());
                                bw.write(this.wrapInQuotes(modified));
                            }
                            catch (DateTimeException ex) {
                                LOG.warning(ex.getLocalizedMessage());
                                bw.write(this.wrapInQuotes(""));
                            }
                        } else {
                            bw.write(this.wrapInQuotes(""));
                        }
                    }
                    bw.write(",");
                    bw.write(res.getUserOrOtherName() == null ? this.wrapInQuotes("") : this.wrapInQuotes(res.getUserOrOtherName()));
                    bw.write(",");
                    bw.write(res.getInfo() == null ? this.wrapInQuotes("") : this.wrapInQuotes(res.getInfo()));
                    bw.write(",");
                    bw.write(this.wrapInQuotes(res.getNamedArea().getDisplayName()));
                    bw.write(",");
                    bw.write(this.wrapInQuotes(PatternMatchResult.getPatternMatchesAsDisplayString((Collection)res.getResults())));
                    for (PatternMatchResult pm : res.getResults()) {
                        bw.write(",");
                        bw.write(this.wrapInQuotes(pm.getDisplayName()));
                        bw.write(",");
                        bw.write(this.wrapInQuotes(pm.getSurroundingText()));
                    }
                    bw.newLine();
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FileRepositoryDetails.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String wrapInQuotes(String in) {
        return "\"" + in + "\"";
    }
}

