/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.ignore;

import com.geolang.ascema.endpointcommon.discovery.encrypt.MatchingTextEncryptor;
import com.geolang.ascema.managerdomain.domain.PatternIgnore;
import com.geolang.ascema.managerdomain.web.importexport.PatternIgnoreExport;
import com.geolang.ascema.managerpersistence.DatabaseResultsStore;
import com.geolang.ascema.managerpersistence.IPatternIgnoreRepository;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.ResultEncryptorCache;
import com.geolang.ascema.managerpersistence.serviceinterfaces.IPatternIgnoreController;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.results.ignore.IgnoreDBUpdater;
import com.geolang.ascema.parsers.ParserFactory;
import com.geolang.ascema.parsers.ParserSimple;
import com.geolang.ascema.patternmatching.PatternFactory;
import com.geolang.ascema.patternmatching.patterns.KeywordListCsvHelper;
import com.geolang.ascema.patternmatching.patterns.compound.CompoundPattern;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class PatternIgnoreController
implements IPatternIgnoreController {
    private static final Logger LOG = Logger.getLogger(PatternIgnoreController.class.getName());
    private final Map<String, List<String>> patternsToIgnoreList = new HashMap();
    @Autowired
    private IPatternIgnoreRepository repo;
    @Autowired
    private DatabaseResultsStore store;
    @Autowired
    private AuditLogService audit;
    private final ResultEncryptorCache encCache = ResultEncryptorCache.getInstance();
    private IgnoreDBUpdater databaseUpdater = null;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        for (PatternIgnore ig : this.repo.findAll()) {
            this.addToIgnore(ig.getPatternName(), ig.getIgnore());
        }
        this.databaseUpdater = new IgnoreDBUpdater(this.store, this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (this.databaseUpdater != null) {
            this.databaseUpdater.stop();
        }
    }

    public Map<String, List<String>> getAll() {
        return Collections.unmodifiableMap(this.patternsToIgnoreList);
    }

    public List<PatternIgnoreExport> getAllForExport() {
        ArrayList<PatternIgnoreExport> ret = new ArrayList<PatternIgnoreExport>();
        for (Map.Entry e : this.patternsToIgnoreList.entrySet()) {
            ret.add(new PatternIgnoreExport((String)e.getKey(), (List)e.getValue()));
        }
        return ret;
    }

    public boolean addIgnoresToPattern(String actor, String patternDisplayName, List<String> ignore) {
        boolean ret = true;
        for (String ig : ignore) {
            ret = ret && this.addIgnoreToPattern(actor, patternDisplayName, ig);
        }
        return ret;
    }

    public boolean addIgnoresToPatternFromFile(String actor, String patternDisplayName, InputStream is) {
        try {
            ParserSimple parser = ParserFactory.buildSimpleParser();
            String parsed = parser.parse(is, patternDisplayName);
            List parts = KeywordListCsvHelper.parseCsv((String)parsed);
            return this.addIgnoresToPattern(actor, patternDisplayName, parts);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean addIgnoreToPattern(String actor, String patternDisplayName, String ignore) {
        if (this.patternsToIgnoreList.containsKey(patternDisplayName)) {
            for (String ig : (List)this.patternsToIgnoreList.get(patternDisplayName)) {
                if (!ig.equalsIgnoreCase(ignore)) continue;
                LOG.log(Level.WARNING, "Ignore {1} already exists on pattern {0} ", new Object[]{patternDisplayName, ignore});
                return false;
            }
        }
        this.addToIgnore(patternDisplayName, ignore);
        PatternIgnore toAdd = new PatternIgnore(patternDisplayName, ignore);
        this.repo.save((Object)toAdd);
        this.databaseUpdater.addIgnore(patternDisplayName, ignore);
        this.audit.patternIgnoreCreated(actor, toAdd);
        LOG.log(Level.INFO, "{0} added ignore {1} from pattern {2}", new Object[]{actor, ignore, patternDisplayName});
        return true;
    }

    private void addToIgnore(String patternDisplayName, String ignore) {
        if (!this.patternsToIgnoreList.containsKey(patternDisplayName)) {
            this.patternsToIgnoreList.put(patternDisplayName, new ArrayList());
        }
        ((List)this.patternsToIgnoreList.get(patternDisplayName)).add(ignore);
    }

    public void ignoreDataPoint(String actor, String patternDisplayName, String matchingText, String deviceId) {
        MatchingTextEncryptor enc = this.encCache.getEncryptorForDeviceId(deviceId);
        String ignore = enc.dec(matchingText);
        this.addIgnoreToPattern(actor, patternDisplayName, ignore);
    }

    public void unIgnoreDataPoint(String actor, String patternDisplayName, String matchingText, String deviceId) {
        MatchingTextEncryptor enc = this.encCache.getEncryptorForDeviceId(deviceId);
        String ignore = enc.dec(matchingText);
        this.removeIgnoreFromPattern(actor, patternDisplayName, ignore);
    }

    public boolean removeIgnoresFromPattern(String actor, String patternDisplayName, List<String> ignores) {
        boolean ret = true;
        for (String ig : ignores) {
            ret = ret && this.removeIgnoreFromPattern(actor, patternDisplayName, ig);
        }
        return ret;
    }

    public boolean removeIgnoreFromPattern(String actor, String patternDisplayName, String ignore) {
        if (!this.patternsToIgnoreList.containsKey(patternDisplayName)) {
            LOG.log(Level.WARNING, "Pattern not found in remove ignore {0}", patternDisplayName);
            return false;
        }
        boolean ret = ((List)this.patternsToIgnoreList.get(patternDisplayName)).remove(ignore);
        if (ret) {
            if (((List)this.patternsToIgnoreList.get(patternDisplayName)).isEmpty()) {
                this.patternsToIgnoreList.remove(patternDisplayName);
            }
            this.repo.deleteByPatternNameAndIgnore(patternDisplayName, ignore);
            this.databaseUpdater.removeIgnore(patternDisplayName, ignore);
            this.audit.patternIgnoreDeleted(actor, new PatternIgnore(patternDisplayName, ignore));
            LOG.log(Level.INFO, "{0} removed ignore {1} from pattern {2}", new Object[]{actor, ignore, patternDisplayName});
        } else {
            LOG.log(Level.WARNING, "Ignore {1} not found to delete on pattern {0} ", new Object[]{patternDisplayName, ignore});
        }
        return ret;
    }

    public boolean removeAllIgnoresForPattern(String actor, String patternDisplayName) {
        if (!this.patternsToIgnoreList.containsKey(patternDisplayName)) {
            LOG.log(Level.WARNING, "No ignores were set for pattern {0}", patternDisplayName);
            return false;
        }
        this.repo.deleteByPatternName(patternDisplayName);
        this.patternsToIgnoreList.remove(patternDisplayName);
        this.databaseUpdater.removeAll(patternDisplayName);
        this.audit.patternIgnoreCreated(actor, new PatternIgnore(patternDisplayName, "*"));
        LOG.log(Level.INFO, "{0} removed all ignores from pattern {1}", new Object[]{actor, patternDisplayName});
        return true;
    }

    public List<String> listIgnoresForPattern(String patternDisplayName) {
        if (!this.patternsToIgnoreList.containsKey(patternDisplayName)) {
            return Collections.emptyList();
        }
        return (List)this.patternsToIgnoreList.get(patternDisplayName);
    }

    public boolean datapointIsIgnored(DataPoint dp) {
        String patternSerializedName = dp.getResult().getPatternSerialisedName();
        if (PatternFactory.isCompound((String)patternSerializedName)) {
            String patName = CompoundPattern.getJustMatchingPart((String)dp.getPatternName());
            return this.datapointIsIgnoredPriv(patName, dp.getDeviceId(), dp.getResult().getMatchingText(), this.patternsToIgnoreList);
        }
        return this.datapointIsIgnoredPriv(dp.getPatternName(), dp.getDeviceId(), dp.getResult().getMatchingText(), this.patternsToIgnoreList);
    }

    public boolean datapointIsIgnored(String patternSerializedName, String patternDisplayName, String deviceId, String matchingText) {
        if (PatternFactory.isCompound((String)patternSerializedName)) {
            String patName = CompoundPattern.getJustMatchingPart((String)patternDisplayName);
            return this.datapointIsIgnoredPriv(patName, deviceId, matchingText, this.patternsToIgnoreList);
        }
        return this.datapointIsIgnoredPriv(patternDisplayName, deviceId, matchingText, this.patternsToIgnoreList);
    }

    boolean datapointIsIgnoredPriv(String patternDisplayName, String deviceId, String matchingText, Map<String, List<String>> map) {
        if (!map.containsKey(patternDisplayName)) {
            return false;
        }
        List<String> ignores = map.get(patternDisplayName);
        if (!ignores.isEmpty()) {
            MatchingTextEncryptor enc = this.encCache.getEncryptorForDeviceId(deviceId);
            String dec = enc.dec(matchingText);
            for (String ignore : ignores) {
                if (!ignore.equalsIgnoreCase(dec)) continue;
                return true;
            }
        }
        return false;
    }
}

