/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.ignore;

import com.geolang.ascema.domainmodelpublic.HashDigest;
import com.geolang.ascema.endpointcommon.discovery.encrypt.MatchingTextEncryptor;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.DatabaseResultStored;
import com.geolang.ascema.managerpersistence.DatabaseResultsStore;
import com.geolang.ascema.managerservice.controllers.results.ignore.PatternIgnoreController;
import com.geolang.ascema.managerservice.rest.asyncmessages.IgnoreJobComplete;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class IgnoreDBUpdater {
    private static final Logger LOG = Logger.getLogger(IgnoreDBUpdater.class.getName());
    private final DatabaseResultsStore store;
    private final PatternIgnoreController ignoreController;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    private int jobCount = 0;

    public IgnoreDBUpdater(DatabaseResultsStore store, PatternIgnoreController ignoreController) {
        this.store = store;
        this.ignoreController = ignoreController;
        if (SettingsFile.getInstance().getDBIgnoreDirty().booleanValue()) {
            this.addJob(() -> this.runFullCheck());
        }
    }

    public void stop() throws Exception {
        this.executor.shutdownNow();
    }

    private synchronized void addJob(Runnable f) {
        ++this.jobCount;
        SettingsFile.getInstance().setDBIgnoreDirty(Boolean.valueOf(true));
        this.executor.submit(f);
    }

    private synchronized void jobDone(IgnoreJobComplete evToSend) {
        --this.jobCount;
        if (this.jobCount == 0) {
            SettingsFile.getInstance().setDBIgnoreDirty(Boolean.valueOf(false));
        }
        if (evToSend != null) {
            MessageBus.getBus().post((Object)evToSend);
        }
        LOG.log(Level.INFO, "Job Done for Ignore/Unignore {0}", evToSend);
    }

    void addIgnore(String patternDisplayName, String ignore) {
        LOG.log(Level.INFO, "createJob on add Ignore {0} {1}", new Object[]{patternDisplayName, ignore});
        IgnoreJobComplete toSend = new IgnoreJobComplete(true, patternDisplayName, ignore);
        this.addJob(() -> this.setorUnsetIgnore(toSend, true, patternDisplayName, ignore));
    }

    void removeIgnore(String patternDisplayName, String ignore) {
        LOG.log(Level.INFO, "createJob on remove Ignore {0} {1}", new Object[]{patternDisplayName, ignore});
        IgnoreJobComplete toSend = new IgnoreJobComplete(false, patternDisplayName, ignore);
        this.addJob(() -> this.setorUnsetIgnore(toSend, false, patternDisplayName, ignore));
    }

    void removeAll(String patternDisplayName) {
        LOG.log(Level.INFO, "createJob on remove all Ignores {0}", new Object[]{patternDisplayName});
        IgnoreJobComplete toSend = new IgnoreJobComplete(false, patternDisplayName, "");
        this.addJob(() -> this.removeAll(toSend, patternDisplayName));
    }

    private void setorUnsetIgnore(IgnoreJobComplete toSend, boolean set, String patternDisplayName, String ignore) {
        for (String devId : this.store.getDistinctDeviceIds()) {
            MatchingTextEncryptor enc = new MatchingTextEncryptor(devId);
            HashDigest digest = enc.getDigestForPlainText(ignore);
            this.store.setIgnoreFlagForPatternAndDeviceAndDigest(set, patternDisplayName, devId, digest.hash());
        }
        this.jobDone(toSend);
    }

    private void removeAll(IgnoreJobComplete toSend, String patternDisplayName) {
        this.store.unsetIgnoreFlagForPattern(patternDisplayName);
        this.jobDone(toSend);
    }

    private void runFullCheck() {
        LOG.info("run ignore check");
        int BATCH_SIZE = 100;
        Page slice = this.store.getPageOfResults((Pageable)PageRequest.of((int)0, (int)BATCH_SIZE));
        List list = slice.getContent();
        this.processList(list);
        while (slice.hasNext()) {
            slice = this.store.getPageOfResults(slice.nextPageable());
            this.processList(slice.getContent());
        }
        this.jobDone(null);
        LOG.info("run ignore check done");
    }

    private void processList(List<DatabaseResultStored> list) {
        int count = 0;
        for (DatabaseResultStored res : list) {
            boolean ignored = this.ignoreController.datapointIsIgnored(res.getPatternName(), res.getPatternDisplayName(), res.getDeviceId(), res.getMatchingText());
            if (ignored == res.isIgnored()) continue;
            res.setIgnored(ignored);
            ++count;
            this.store.updateIgnoreFlag(res.getId(), res.isIgnored());
        }
        if (count > 0) {
            LOG.log(Level.INFO, "updated {0} db results for ignore changes", count);
        }
    }
}

